/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.camelk.v1;

import io.fabric8.camelk.v1.ResourceSpec;
import io.fabric8.camelk.v1.ResourceSpecFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ResourceSpecFluentImpl<A extends ResourceSpecFluent<A>>
extends BaseFluent<A>
implements ResourceSpecFluent<A> {
    private Boolean compression;
    private String content;
    private String contentKey;
    private String contentRef;
    private String contentType;
    private String mountPath;
    private String name;
    private String path;
    private List<Integer> rawContent;
    private String type;

    public ResourceSpecFluentImpl() {
    }

    public ResourceSpecFluentImpl(ResourceSpec instance) {
        this.withCompression(instance.getCompression());
        this.withContent(instance.getContent());
        this.withContentKey(instance.getContentKey());
        this.withContentRef(instance.getContentRef());
        this.withContentType(instance.getContentType());
        this.withMountPath(instance.getMountPath());
        this.withName(instance.getName());
        this.withPath(instance.getPath());
        this.withRawContent(instance.getRawContent());
        this.withType(instance.getType());
    }

    @Override
    public Boolean getCompression() {
        return this.compression;
    }

    @Override
    public A withCompression(Boolean compression) {
        this.compression = compression;
        return (A)this;
    }

    @Override
    public Boolean hasCompression() {
        return this.compression != null;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public A withContent(String content) {
        this.content = content;
        return (A)this;
    }

    @Override
    public Boolean hasContent() {
        return this.content != null;
    }

    @Override
    @Deprecated
    public A withNewContent(String arg0) {
        return this.withContent(new String(arg0));
    }

    @Override
    public String getContentKey() {
        return this.contentKey;
    }

    @Override
    public A withContentKey(String contentKey) {
        this.contentKey = contentKey;
        return (A)this;
    }

    @Override
    public Boolean hasContentKey() {
        return this.contentKey != null;
    }

    @Override
    @Deprecated
    public A withNewContentKey(String arg0) {
        return this.withContentKey(new String(arg0));
    }

    @Override
    public String getContentRef() {
        return this.contentRef;
    }

    @Override
    public A withContentRef(String contentRef) {
        this.contentRef = contentRef;
        return (A)this;
    }

    @Override
    public Boolean hasContentRef() {
        return this.contentRef != null;
    }

    @Override
    @Deprecated
    public A withNewContentRef(String arg0) {
        return this.withContentRef(new String(arg0));
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public A withContentType(String contentType) {
        this.contentType = contentType;
        return (A)this;
    }

    @Override
    public Boolean hasContentType() {
        return this.contentType != null;
    }

    @Override
    @Deprecated
    public A withNewContentType(String arg0) {
        return this.withContentType(new String(arg0));
    }

    @Override
    public String getMountPath() {
        return this.mountPath;
    }

    @Override
    public A withMountPath(String mountPath) {
        this.mountPath = mountPath;
        return (A)this;
    }

    @Override
    public Boolean hasMountPath() {
        return this.mountPath != null;
    }

    @Override
    @Deprecated
    public A withNewMountPath(String arg0) {
        return this.withMountPath(new String(arg0));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public A withNewName(String arg0) {
        return this.withName(new String(arg0));
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public A withPath(String path) {
        this.path = path;
        return (A)this;
    }

    @Override
    public Boolean hasPath() {
        return this.path != null;
    }

    @Override
    @Deprecated
    public A withNewPath(String arg0) {
        return this.withPath(new String(arg0));
    }

    @Override
    public A addToRawContent(Integer index, Integer item) {
        if (this.rawContent == null) {
            this.rawContent = new ArrayList<Integer>();
        }
        this.rawContent.add(index, item);
        return (A)this;
    }

    @Override
    public A setToRawContent(Integer index, Integer item) {
        if (this.rawContent == null) {
            this.rawContent = new ArrayList<Integer>();
        }
        this.rawContent.set(index, item);
        return (A)this;
    }

    @Override
    public A addToRawContent(Integer ... items) {
        if (this.rawContent == null) {
            this.rawContent = new ArrayList<Integer>();
        }
        for (Integer item : items) {
            this.rawContent.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToRawContent(Collection<Integer> items) {
        if (this.rawContent == null) {
            this.rawContent = new ArrayList<Integer>();
        }
        for (Integer item : items) {
            this.rawContent.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromRawContent(Integer ... items) {
        for (Integer item : items) {
            if (this.rawContent == null) continue;
            this.rawContent.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRawContent(Collection<Integer> items) {
        for (Integer item : items) {
            if (this.rawContent == null) continue;
            this.rawContent.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Integer> getRawContent() {
        return this.rawContent;
    }

    @Override
    public Integer getRawContent(Integer index) {
        return this.rawContent.get(index);
    }

    @Override
    public Integer getFirstRawContent() {
        return this.rawContent.get(0);
    }

    @Override
    public Integer getLastRawContent() {
        return this.rawContent.get(this.rawContent.size() - 1);
    }

    @Override
    public Integer getMatchingRawContent(Predicate<Integer> predicate) {
        for (Integer item : this.rawContent) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRawContent(Predicate<Integer> predicate) {
        for (Integer item : this.rawContent) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRawContent(List<Integer> rawContent) {
        if (rawContent != null) {
            this.rawContent = new ArrayList<Integer>();
            for (Integer item : rawContent) {
                this.addToRawContent(item);
            }
        } else {
            this.rawContent = null;
        }
        return (A)this;
    }

    @Override
    public A withRawContent(Integer ... rawContent) {
        if (this.rawContent != null) {
            this.rawContent.clear();
        }
        if (rawContent != null) {
            for (Integer item : rawContent) {
                this.addToRawContent(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRawContent() {
        return this.rawContent != null && !this.rawContent.isEmpty();
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    @Override
    public Boolean hasType() {
        return this.type != null;
    }

    @Override
    @Deprecated
    public A withNewType(String arg0) {
        return this.withType(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceSpecFluentImpl that = (ResourceSpecFluentImpl)o;
        if (this.compression != null ? !this.compression.equals(that.compression) : that.compression != null) {
            return false;
        }
        if (this.content != null ? !this.content.equals(that.content) : that.content != null) {
            return false;
        }
        if (this.contentKey != null ? !this.contentKey.equals(that.contentKey) : that.contentKey != null) {
            return false;
        }
        if (this.contentRef != null ? !this.contentRef.equals(that.contentRef) : that.contentRef != null) {
            return false;
        }
        if (this.contentType != null ? !this.contentType.equals(that.contentType) : that.contentType != null) {
            return false;
        }
        if (this.mountPath != null ? !this.mountPath.equals(that.mountPath) : that.mountPath != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (this.rawContent != null ? !this.rawContent.equals(that.rawContent) : that.rawContent != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public int hashCode() {
        return Objects.hash(this.compression, this.content, this.contentKey, this.contentRef, this.contentType, this.mountPath, this.name, this.path, this.rawContent, this.type, super.hashCode());
    }
}

