package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public class IntegrationSpecFluentImpl<A extends io.fabric8.camelk.v1.IntegrationSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.camelk.v1.IntegrationSpecFluent<A>{
  public IntegrationSpecFluentImpl() {
  }
  public IntegrationSpecFluentImpl(io.fabric8.camelk.v1.IntegrationSpec instance) {
    this.withConfiguration(instance.getConfiguration()); 
    this.withDependencies(instance.getDependencies()); 
    this.withFlows(instance.getFlows()); 
    this.withIntegrationKit(instance.getIntegrationKit()); 
    this.withKit(instance.getKit()); 
    this.withProfile(instance.getProfile()); 
    this.withReplicas(instance.getReplicas()); 
    this.withRepositories(instance.getRepositories()); 
    this.withResources(instance.getResources()); 
    this.withServiceAccountName(instance.getServiceAccountName()); 
    this.withSources(instance.getSources()); 
    this.withTemplate(instance.getTemplate()); 
    this.withTraits(instance.getTraits()); 
  }
  private java.util.List<io.fabric8.camelk.v1.ConfigurationSpecBuilder> configuration;
  private java.util.List<java.lang.String> dependencies;
  private java.util.List<com.fasterxml.jackson.databind.JsonNode> flows;
  private io.fabric8.kubernetes.api.model.ObjectReferenceBuilder integrationKit;
  private java.lang.String kit;
  private java.lang.String profile;
  private java.lang.Integer replicas;
  private java.util.List<java.lang.String> repositories;
  private java.util.List<io.fabric8.camelk.v1.ResourceSpecBuilder> resources;
  private java.lang.String serviceAccountName;
  private java.util.List<io.fabric8.camelk.v1.SourceSpecBuilder> sources;
  private io.fabric8.camelk.v1.PodSpecTemplateBuilder template;
  private java.util.Map<java.lang.String,io.fabric8.camelk.v1.TraitSpec> traits;
  public A addToConfiguration(java.lang.Integer index,io.fabric8.camelk.v1.ConfigurationSpec item) {
    if (this.configuration == null) {this.configuration = new java.util.ArrayList<io.fabric8.camelk.v1.ConfigurationSpecBuilder>();}
    io.fabric8.camelk.v1.ConfigurationSpecBuilder builder = new io.fabric8.camelk.v1.ConfigurationSpecBuilder(item);_visitables.get("configuration").add(index >= 0 ? index : _visitables.get("configuration").size(), builder);this.configuration.add(index >= 0 ? index : configuration.size(), builder); return (A)this;
  }
  public A setToConfiguration(java.lang.Integer index,io.fabric8.camelk.v1.ConfigurationSpec item) {
    if (this.configuration == null) {this.configuration = new java.util.ArrayList<io.fabric8.camelk.v1.ConfigurationSpecBuilder>();}
    io.fabric8.camelk.v1.ConfigurationSpecBuilder builder = new io.fabric8.camelk.v1.ConfigurationSpecBuilder(item);
    if (index < 0 || index >= _visitables.get("configuration").size()) { _visitables.get("configuration").add(builder); } else { _visitables.get("configuration").set(index, builder);}
    if (index < 0 || index >= configuration.size()) { configuration.add(builder); } else { configuration.set(index, builder);}
     return (A)this;
  }
  public A addToConfiguration(io.fabric8.camelk.v1.ConfigurationSpec... items) {
    if (this.configuration == null) {this.configuration = new java.util.ArrayList<io.fabric8.camelk.v1.ConfigurationSpecBuilder>();}
    for (io.fabric8.camelk.v1.ConfigurationSpec item : items) {io.fabric8.camelk.v1.ConfigurationSpecBuilder builder = new io.fabric8.camelk.v1.ConfigurationSpecBuilder(item);_visitables.get("configuration").add(builder);this.configuration.add(builder);} return (A)this;
  }
  public A addAllToConfiguration(java.util.Collection<io.fabric8.camelk.v1.ConfigurationSpec> items) {
    if (this.configuration == null) {this.configuration = new java.util.ArrayList<io.fabric8.camelk.v1.ConfigurationSpecBuilder>();}
    for (io.fabric8.camelk.v1.ConfigurationSpec item : items) {io.fabric8.camelk.v1.ConfigurationSpecBuilder builder = new io.fabric8.camelk.v1.ConfigurationSpecBuilder(item);_visitables.get("configuration").add(builder);this.configuration.add(builder);} return (A)this;
  }
  public A removeFromConfiguration(io.fabric8.camelk.v1.ConfigurationSpec... items) {
    for (io.fabric8.camelk.v1.ConfigurationSpec item : items) {io.fabric8.camelk.v1.ConfigurationSpecBuilder builder = new io.fabric8.camelk.v1.ConfigurationSpecBuilder(item);_visitables.get("configuration").remove(builder);if (this.configuration != null) {this.configuration.remove(builder);}} return (A)this;
  }
  public A removeAllFromConfiguration(java.util.Collection<io.fabric8.camelk.v1.ConfigurationSpec> items) {
    for (io.fabric8.camelk.v1.ConfigurationSpec item : items) {io.fabric8.camelk.v1.ConfigurationSpecBuilder builder = new io.fabric8.camelk.v1.ConfigurationSpecBuilder(item);_visitables.get("configuration").remove(builder);if (this.configuration != null) {this.configuration.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConfiguration(java.util.function.Predicate<io.fabric8.camelk.v1.ConfigurationSpecBuilder> predicate) {
    if (configuration == null) return (A) this;
    final Iterator<io.fabric8.camelk.v1.ConfigurationSpecBuilder> each = configuration.iterator();
    final List visitables = _visitables.get("configuration");
    while (each.hasNext()) {
      io.fabric8.camelk.v1.ConfigurationSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConfiguration instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.camelk.v1.ConfigurationSpec> getConfiguration() {
    return build(configuration);
  }
  public java.util.List<io.fabric8.camelk.v1.ConfigurationSpec> buildConfiguration() {
    return build(configuration);
  }
  public io.fabric8.camelk.v1.ConfigurationSpec buildConfiguration(java.lang.Integer index) {
    return this.configuration.get(index).build();
  }
  public io.fabric8.camelk.v1.ConfigurationSpec buildFirstConfiguration() {
    return this.configuration.get(0).build();
  }
  public io.fabric8.camelk.v1.ConfigurationSpec buildLastConfiguration() {
    return this.configuration.get(configuration.size() - 1).build();
  }
  public io.fabric8.camelk.v1.ConfigurationSpec buildMatchingConfiguration(java.util.function.Predicate<io.fabric8.camelk.v1.ConfigurationSpecBuilder> predicate) {
    for (io.fabric8.camelk.v1.ConfigurationSpecBuilder item: configuration) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingConfiguration(java.util.function.Predicate<io.fabric8.camelk.v1.ConfigurationSpecBuilder> predicate) {
    for (io.fabric8.camelk.v1.ConfigurationSpecBuilder item: configuration) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConfiguration(java.util.List<io.fabric8.camelk.v1.ConfigurationSpec> configuration) {
    if (this.configuration != null) { _visitables.get("configuration").removeAll(this.configuration);}
    if (configuration != null) {this.configuration = new java.util.ArrayList(); for (io.fabric8.camelk.v1.ConfigurationSpec item : configuration){this.addToConfiguration(item);}} else { this.configuration = null;} return (A) this;
  }
  public A withConfiguration(io.fabric8.camelk.v1.ConfigurationSpec... configuration) {
    if (this.configuration != null) {this.configuration.clear();}
    if (configuration != null) {for (io.fabric8.camelk.v1.ConfigurationSpec item :configuration){ this.addToConfiguration(item);}} return (A) this;
  }
  public java.lang.Boolean hasConfiguration() {
    return configuration != null && !configuration.isEmpty();
  }
  public A addNewConfiguration(java.lang.String resourceKey,java.lang.String resourceMountPoint,java.lang.String resourceType,java.lang.String type,java.lang.String value) {
    return (A)addToConfiguration(new ConfigurationSpec(resourceKey, resourceMountPoint, resourceType, type, value));
  }
  public io.fabric8.camelk.v1.IntegrationSpecFluent.ConfigurationNested<A> addNewConfiguration() {
    return new io.fabric8.camelk.v1.IntegrationSpecFluentImpl.ConfigurationNestedImpl();
  }
  public io.fabric8.camelk.v1.IntegrationSpecFluent.ConfigurationNested<A> addNewConfigurationLike(io.fabric8.camelk.v1.ConfigurationSpec item) {
    return new io.fabric8.camelk.v1.IntegrationSpecFluentImpl.ConfigurationNestedImpl(-1, item);
  }
  public io.fabric8.camelk.v1.IntegrationSpecFluent.ConfigurationNested<A> setNewConfigurationLike(java.lang.Integer index,io.fabric8.camelk.v1.ConfigurationSpec item) {
    return new io.fabric8.camelk.v1.IntegrationSpecFluentImpl.ConfigurationNestedImpl(index, item);
  }
  public io.fabric8.camelk.v1.IntegrationSpecFluent.ConfigurationNested<A> editConfiguration(java.lang.Integer index) {
    if (configuration.size() <= index) throw new RuntimeException("Can't edit configuration. Index exceeds size.");
    return setNewConfigurationLike(index, buildConfiguration(index));
  }
  public io.fabric8.camelk.v1.IntegrationSpecFluent.ConfigurationNested<A> editFirstConfiguration() {
    if (configuration.size() == 0) throw new RuntimeException("Can't edit first configuration. The list is empty.");
    return setNewConfigurationLike(0, buildConfiguration(0));
  }
  public io.fabric8.camelk.v1.IntegrationSpecFluent.ConfigurationNested<A> editLastConfiguration() {
    int index = configuration.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last configuration. The list is empty.");
    return setNewConfigurationLike(index, buildConfiguration(index));
  }
  public io.fabric8.camelk.v1.IntegrationSpecFluent.ConfigurationNested<A> editMatchingConfiguration(java.util.function.Predicate<io.fabric8.camelk.v1.ConfigurationSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<configuration.size();i++) { 
    if (predicate.test(configuration.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching configuration. No match found.");
    return setNewConfigurationLike(index, buildConfiguration(index));
  }
  public A addToDependencies(java.lang.Integer index,java.lang.String item) {
    if (this.dependencies == null) {this.dependencies = new java.util.ArrayList<java.lang.String>();}
    this.dependencies.add(index, item);
    return (A)this;
  }
  public A setToDependencies(java.lang.Integer index,java.lang.String item) {
    if (this.dependencies == null) {this.dependencies = new java.util.ArrayList<java.lang.String>();}
    this.dependencies.set(index, item); return (A)this;
  }
  public A addToDependencies(java.lang.String... items) {
    if (this.dependencies == null) {this.dependencies = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.dependencies.add(item);} return (A)this;
  }
  public A addAllToDependencies(java.util.Collection<java.lang.String> items) {
    if (this.dependencies == null) {this.dependencies = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.dependencies.add(item);} return (A)this;
  }
  public A removeFromDependencies(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.dependencies!= null){ this.dependencies.remove(item);}} return (A)this;
  }
  public A removeAllFromDependencies(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.dependencies!= null){ this.dependencies.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getDependencies() {
    return this.dependencies;
  }
  public java.lang.String getDependency(java.lang.Integer index) {
    return this.dependencies.get(index);
  }
  public java.lang.String getFirstDependency() {
    return this.dependencies.get(0);
  }
  public java.lang.String getLastDependency() {
    return this.dependencies.get(dependencies.size() - 1);
  }
  public java.lang.String getMatchingDependency(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: dependencies) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingDependency(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: dependencies) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDependencies(java.util.List<java.lang.String> dependencies) {
    if (dependencies != null) {this.dependencies = new java.util.ArrayList(); for (java.lang.String item : dependencies){this.addToDependencies(item);}} else { this.dependencies = null;} return (A) this;
  }
  public A withDependencies(java.lang.String... dependencies) {
    if (this.dependencies != null) {this.dependencies.clear();}
    if (dependencies != null) {for (java.lang.String item :dependencies){ this.addToDependencies(item);}} return (A) this;
  }
  public java.lang.Boolean hasDependencies() {
    return dependencies != null && !dependencies.isEmpty();
  }
  public A addNewDependency(java.lang.String arg0) {
    return (A)addToDependencies(new String(arg0));
  }
  public A addToFlows(java.lang.Integer index,com.fasterxml.jackson.databind.JsonNode item) {
    if (this.flows == null) {this.flows = new java.util.ArrayList<com.fasterxml.jackson.databind.JsonNode>();}
    this.flows.add(index, item);
    return (A)this;
  }
  public A setToFlows(java.lang.Integer index,com.fasterxml.jackson.databind.JsonNode item) {
    if (this.flows == null) {this.flows = new java.util.ArrayList<com.fasterxml.jackson.databind.JsonNode>();}
    this.flows.set(index, item); return (A)this;
  }
  public A addToFlows(com.fasterxml.jackson.databind.JsonNode... items) {
    if (this.flows == null) {this.flows = new java.util.ArrayList<com.fasterxml.jackson.databind.JsonNode>();}
    for (com.fasterxml.jackson.databind.JsonNode item : items) {this.flows.add(item);} return (A)this;
  }
  public A addAllToFlows(java.util.Collection<com.fasterxml.jackson.databind.JsonNode> items) {
    if (this.flows == null) {this.flows = new java.util.ArrayList<com.fasterxml.jackson.databind.JsonNode>();}
    for (com.fasterxml.jackson.databind.JsonNode item : items) {this.flows.add(item);} return (A)this;
  }
  public A removeFromFlows(com.fasterxml.jackson.databind.JsonNode... items) {
    for (com.fasterxml.jackson.databind.JsonNode item : items) {if (this.flows!= null){ this.flows.remove(item);}} return (A)this;
  }
  public A removeAllFromFlows(java.util.Collection<com.fasterxml.jackson.databind.JsonNode> items) {
    for (com.fasterxml.jackson.databind.JsonNode item : items) {if (this.flows!= null){ this.flows.remove(item);}} return (A)this;
  }
  public java.util.List<com.fasterxml.jackson.databind.JsonNode> getFlows() {
    return this.flows;
  }
  public com.fasterxml.jackson.databind.JsonNode getFlow(java.lang.Integer index) {
    return this.flows.get(index);
  }
  public com.fasterxml.jackson.databind.JsonNode getFirstFlow() {
    return this.flows.get(0);
  }
  public com.fasterxml.jackson.databind.JsonNode getLastFlow() {
    return this.flows.get(flows.size() - 1);
  }
  public com.fasterxml.jackson.databind.JsonNode getMatchingFlow(java.util.function.Predicate<com.fasterxml.jackson.databind.JsonNode> predicate) {
    for (com.fasterxml.jackson.databind.JsonNode item: flows) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingFlow(java.util.function.Predicate<com.fasterxml.jackson.databind.JsonNode> predicate) {
    for (com.fasterxml.jackson.databind.JsonNode item: flows) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withFlows(java.util.List<com.fasterxml.jackson.databind.JsonNode> flows) {
    if (flows != null) {this.flows = new java.util.ArrayList(); for (com.fasterxml.jackson.databind.JsonNode item : flows){this.addToFlows(item);}} else { this.flows = null;} return (A) this;
  }
  public A withFlows(com.fasterxml.jackson.databind.JsonNode... flows) {
    if (this.flows != null) {this.flows.clear();}
    if (flows != null) {for (com.fasterxml.jackson.databind.JsonNode item :flows){ this.addToFlows(item);}} return (A) this;
  }
  public java.lang.Boolean hasFlows() {
    return flows != null && !flows.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildIntegrationKit instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ObjectReference getIntegrationKit() {
    return this.integrationKit!=null?this.integrationKit.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectReference buildIntegrationKit() {
    return this.integrationKit!=null?this.integrationKit.build():null;
  }
  public A withIntegrationKit(io.fabric8.kubernetes.api.model.ObjectReference integrationKit) {
    _visitables.get("integrationKit").remove(this.integrationKit);
    if (integrationKit!=null){ this.integrationKit= new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(integrationKit); _visitables.get("integrationKit").add(this.integrationKit);} return (A) this;
  }
  public java.lang.Boolean hasIntegrationKit() {
    return this.integrationKit != null;
  }
  public io.fabric8.camelk.v1.IntegrationSpecFluent.IntegrationKitNested<A> withNewIntegrationKit() {
    return new io.fabric8.camelk.v1.IntegrationSpecFluentImpl.IntegrationKitNestedImpl();
  }
  public io.fabric8.camelk.v1.IntegrationSpecFluent.IntegrationKitNested<A> withNewIntegrationKitLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
    return new io.fabric8.camelk.v1.IntegrationSpecFluentImpl.IntegrationKitNestedImpl(item);
  }
  public io.fabric8.camelk.v1.IntegrationSpecFluent.IntegrationKitNested<A> editIntegrationKit() {
    return withNewIntegrationKitLike(getIntegrationKit());
  }
  public io.fabric8.camelk.v1.IntegrationSpecFluent.IntegrationKitNested<A> editOrNewIntegrationKit() {
    return withNewIntegrationKitLike(getIntegrationKit() != null ? getIntegrationKit(): new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder().build());
  }
  public io.fabric8.camelk.v1.IntegrationSpecFluent.IntegrationKitNested<A> editOrNewIntegrationKitLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
    return withNewIntegrationKitLike(getIntegrationKit() != null ? getIntegrationKit(): item);
  }
  public java.lang.String getKit() {
    return this.kit;
  }
  public A withKit(java.lang.String kit) {
    this.kit=kit; return (A) this;
  }
  public java.lang.Boolean hasKit() {
    return this.kit != null;
  }
  
  /**
   * Method is deprecated. use withKit instead.
   */
  @java.lang.Deprecated
  public A withNewKit(java.lang.String arg0) {
    return (A)withKit(new String(arg0));
  }
  public java.lang.String getProfile() {
    return this.profile;
  }
  public A withProfile(java.lang.String profile) {
    this.profile=profile; return (A) this;
  }
  public java.lang.Boolean hasProfile() {
    return this.profile != null;
  }
  
  /**
   * Method is deprecated. use withProfile instead.
   */
  @java.lang.Deprecated
  public A withNewProfile(java.lang.String arg0) {
    return (A)withProfile(new String(arg0));
  }
  public java.lang.Integer getReplicas() {
    return this.replicas;
  }
  public A withReplicas(java.lang.Integer replicas) {
    this.replicas=replicas; return (A) this;
  }
  public java.lang.Boolean hasReplicas() {
    return this.replicas != null;
  }
  public A addToRepositories(java.lang.Integer index,java.lang.String item) {
    if (this.repositories == null) {this.repositories = new java.util.ArrayList<java.lang.String>();}
    this.repositories.add(index, item);
    return (A)this;
  }
  public A setToRepositories(java.lang.Integer index,java.lang.String item) {
    if (this.repositories == null) {this.repositories = new java.util.ArrayList<java.lang.String>();}
    this.repositories.set(index, item); return (A)this;
  }
  public A addToRepositories(java.lang.String... items) {
    if (this.repositories == null) {this.repositories = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.repositories.add(item);} return (A)this;
  }
  public A addAllToRepositories(java.util.Collection<java.lang.String> items) {
    if (this.repositories == null) {this.repositories = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.repositories.add(item);} return (A)this;
  }
  public A removeFromRepositories(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.repositories!= null){ this.repositories.remove(item);}} return (A)this;
  }
  public A removeAllFromRepositories(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.repositories!= null){ this.repositories.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getRepositories() {
    return this.repositories;
  }
  public java.lang.String getRepository(java.lang.Integer index) {
    return this.repositories.get(index);
  }
  public java.lang.String getFirstRepository() {
    return this.repositories.get(0);
  }
  public java.lang.String getLastRepository() {
    return this.repositories.get(repositories.size() - 1);
  }
  public java.lang.String getMatchingRepository(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: repositories) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingRepository(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: repositories) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRepositories(java.util.List<java.lang.String> repositories) {
    if (repositories != null) {this.repositories = new java.util.ArrayList(); for (java.lang.String item : repositories){this.addToRepositories(item);}} else { this.repositories = null;} return (A) this;
  }
  public A withRepositories(java.lang.String... repositories) {
    if (this.repositories != null) {this.repositories.clear();}
    if (repositories != null) {for (java.lang.String item :repositories){ this.addToRepositories(item);}} return (A) this;
  }
  public java.lang.Boolean hasRepositories() {
    return repositories != null && !repositories.isEmpty();
  }
  public A addNewRepository(java.lang.String arg0) {
    return (A)addToRepositories(new String(arg0));
  }
  public A addToResources(java.lang.Integer index,io.fabric8.camelk.v1.ResourceSpec item) {
    if (this.resources == null) {this.resources = new java.util.ArrayList<io.fabric8.camelk.v1.ResourceSpecBuilder>();}
    io.fabric8.camelk.v1.ResourceSpecBuilder builder = new io.fabric8.camelk.v1.ResourceSpecBuilder(item);_visitables.get("resources").add(index >= 0 ? index : _visitables.get("resources").size(), builder);this.resources.add(index >= 0 ? index : resources.size(), builder); return (A)this;
  }
  public A setToResources(java.lang.Integer index,io.fabric8.camelk.v1.ResourceSpec item) {
    if (this.resources == null) {this.resources = new java.util.ArrayList<io.fabric8.camelk.v1.ResourceSpecBuilder>();}
    io.fabric8.camelk.v1.ResourceSpecBuilder builder = new io.fabric8.camelk.v1.ResourceSpecBuilder(item);
    if (index < 0 || index >= _visitables.get("resources").size()) { _visitables.get("resources").add(builder); } else { _visitables.get("resources").set(index, builder);}
    if (index < 0 || index >= resources.size()) { resources.add(builder); } else { resources.set(index, builder);}
     return (A)this;
  }
  public A addToResources(io.fabric8.camelk.v1.ResourceSpec... items) {
    if (this.resources == null) {this.resources = new java.util.ArrayList<io.fabric8.camelk.v1.ResourceSpecBuilder>();}
    for (io.fabric8.camelk.v1.ResourceSpec item : items) {io.fabric8.camelk.v1.ResourceSpecBuilder builder = new io.fabric8.camelk.v1.ResourceSpecBuilder(item);_visitables.get("resources").add(builder);this.resources.add(builder);} return (A)this;
  }
  public A addAllToResources(java.util.Collection<io.fabric8.camelk.v1.ResourceSpec> items) {
    if (this.resources == null) {this.resources = new java.util.ArrayList<io.fabric8.camelk.v1.ResourceSpecBuilder>();}
    for (io.fabric8.camelk.v1.ResourceSpec item : items) {io.fabric8.camelk.v1.ResourceSpecBuilder builder = new io.fabric8.camelk.v1.ResourceSpecBuilder(item);_visitables.get("resources").add(builder);this.resources.add(builder);} return (A)this;
  }
  public A removeFromResources(io.fabric8.camelk.v1.ResourceSpec... items) {
    for (io.fabric8.camelk.v1.ResourceSpec item : items) {io.fabric8.camelk.v1.ResourceSpecBuilder builder = new io.fabric8.camelk.v1.ResourceSpecBuilder(item);_visitables.get("resources").remove(builder);if (this.resources != null) {this.resources.remove(builder);}} return (A)this;
  }
  public A removeAllFromResources(java.util.Collection<io.fabric8.camelk.v1.ResourceSpec> items) {
    for (io.fabric8.camelk.v1.ResourceSpec item : items) {io.fabric8.camelk.v1.ResourceSpecBuilder builder = new io.fabric8.camelk.v1.ResourceSpecBuilder(item);_visitables.get("resources").remove(builder);if (this.resources != null) {this.resources.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromResources(java.util.function.Predicate<io.fabric8.camelk.v1.ResourceSpecBuilder> predicate) {
    if (resources == null) return (A) this;
    final Iterator<io.fabric8.camelk.v1.ResourceSpecBuilder> each = resources.iterator();
    final List visitables = _visitables.get("resources");
    while (each.hasNext()) {
      io.fabric8.camelk.v1.ResourceSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildResources instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.camelk.v1.ResourceSpec> getResources() {
    return build(resources);
  }
  public java.util.List<io.fabric8.camelk.v1.ResourceSpec> buildResources() {
    return build(resources);
  }
  public io.fabric8.camelk.v1.ResourceSpec buildResource(java.lang.Integer index) {
    return this.resources.get(index).build();
  }
  public io.fabric8.camelk.v1.ResourceSpec buildFirstResource() {
    return this.resources.get(0).build();
  }
  public io.fabric8.camelk.v1.ResourceSpec buildLastResource() {
    return this.resources.get(resources.size() - 1).build();
  }
  public io.fabric8.camelk.v1.ResourceSpec buildMatchingResource(java.util.function.Predicate<io.fabric8.camelk.v1.ResourceSpecBuilder> predicate) {
    for (io.fabric8.camelk.v1.ResourceSpecBuilder item: resources) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingResource(java.util.function.Predicate<io.fabric8.camelk.v1.ResourceSpecBuilder> predicate) {
    for (io.fabric8.camelk.v1.ResourceSpecBuilder item: resources) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withResources(java.util.List<io.fabric8.camelk.v1.ResourceSpec> resources) {
    if (this.resources != null) { _visitables.get("resources").removeAll(this.resources);}
    if (resources != null) {this.resources = new java.util.ArrayList(); for (io.fabric8.camelk.v1.ResourceSpec item : resources){this.addToResources(item);}} else { this.resources = null;} return (A) this;
  }
  public A withResources(io.fabric8.camelk.v1.ResourceSpec... resources) {
    if (this.resources != null) {this.resources.clear();}
    if (resources != null) {for (io.fabric8.camelk.v1.ResourceSpec item :resources){ this.addToResources(item);}} return (A) this;
  }
  public java.lang.Boolean hasResources() {
    return resources != null && !resources.isEmpty();
  }
  public io.fabric8.camelk.v1.IntegrationSpecFluent.ResourcesNested<A> addNewResource() {
    return new io.fabric8.camelk.v1.IntegrationSpecFluentImpl.ResourcesNestedImpl();
  }
  public io.fabric8.camelk.v1.IntegrationSpecFluent.ResourcesNested<A> addNewResourceLike(io.fabric8.camelk.v1.ResourceSpec item) {
    return new io.fabric8.camelk.v1.IntegrationSpecFluentImpl.ResourcesNestedImpl(-1, item);
  }
  public io.fabric8.camelk.v1.IntegrationSpecFluent.ResourcesNested<A> setNewResourceLike(java.lang.Integer index,io.fabric8.camelk.v1.ResourceSpec item) {
    return new io.fabric8.camelk.v1.IntegrationSpecFluentImpl.ResourcesNestedImpl(index, item);
  }
  public io.fabric8.camelk.v1.IntegrationSpecFluent.ResourcesNested<A> editResource(java.lang.Integer index) {
    if (resources.size() <= index) throw new RuntimeException("Can't edit resources. Index exceeds size.");
    return setNewResourceLike(index, buildResource(index));
  }
  public io.fabric8.camelk.v1.IntegrationSpecFluent.ResourcesNested<A> editFirstResource() {
    if (resources.size() == 0) throw new RuntimeException("Can't edit first resources. The list is empty.");
    return setNewResourceLike(0, buildResource(0));
  }
  public io.fabric8.camelk.v1.IntegrationSpecFluent.ResourcesNested<A> editLastResource() {
    int index = resources.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last resources. The list is empty.");
    return setNewResourceLike(index, buildResource(index));
  }
  public io.fabric8.camelk.v1.IntegrationSpecFluent.ResourcesNested<A> editMatchingResource(java.util.function.Predicate<io.fabric8.camelk.v1.ResourceSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<resources.size();i++) { 
    if (predicate.test(resources.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching resources. No match found.");
    return setNewResourceLike(index, buildResource(index));
  }
  public java.lang.String getServiceAccountName() {
    return this.serviceAccountName;
  }
  public A withServiceAccountName(java.lang.String serviceAccountName) {
    this.serviceAccountName=serviceAccountName; return (A) this;
  }
  public java.lang.Boolean hasServiceAccountName() {
    return this.serviceAccountName != null;
  }
  
  /**
   * Method is deprecated. use withServiceAccountName instead.
   */
  @java.lang.Deprecated
  public A withNewServiceAccountName(java.lang.String arg0) {
    return (A)withServiceAccountName(new String(arg0));
  }
  public A addToSources(java.lang.Integer index,io.fabric8.camelk.v1.SourceSpec item) {
    if (this.sources == null) {this.sources = new java.util.ArrayList<io.fabric8.camelk.v1.SourceSpecBuilder>();}
    io.fabric8.camelk.v1.SourceSpecBuilder builder = new io.fabric8.camelk.v1.SourceSpecBuilder(item);_visitables.get("sources").add(index >= 0 ? index : _visitables.get("sources").size(), builder);this.sources.add(index >= 0 ? index : sources.size(), builder); return (A)this;
  }
  public A setToSources(java.lang.Integer index,io.fabric8.camelk.v1.SourceSpec item) {
    if (this.sources == null) {this.sources = new java.util.ArrayList<io.fabric8.camelk.v1.SourceSpecBuilder>();}
    io.fabric8.camelk.v1.SourceSpecBuilder builder = new io.fabric8.camelk.v1.SourceSpecBuilder(item);
    if (index < 0 || index >= _visitables.get("sources").size()) { _visitables.get("sources").add(builder); } else { _visitables.get("sources").set(index, builder);}
    if (index < 0 || index >= sources.size()) { sources.add(builder); } else { sources.set(index, builder);}
     return (A)this;
  }
  public A addToSources(io.fabric8.camelk.v1.SourceSpec... items) {
    if (this.sources == null) {this.sources = new java.util.ArrayList<io.fabric8.camelk.v1.SourceSpecBuilder>();}
    for (io.fabric8.camelk.v1.SourceSpec item : items) {io.fabric8.camelk.v1.SourceSpecBuilder builder = new io.fabric8.camelk.v1.SourceSpecBuilder(item);_visitables.get("sources").add(builder);this.sources.add(builder);} return (A)this;
  }
  public A addAllToSources(java.util.Collection<io.fabric8.camelk.v1.SourceSpec> items) {
    if (this.sources == null) {this.sources = new java.util.ArrayList<io.fabric8.camelk.v1.SourceSpecBuilder>();}
    for (io.fabric8.camelk.v1.SourceSpec item : items) {io.fabric8.camelk.v1.SourceSpecBuilder builder = new io.fabric8.camelk.v1.SourceSpecBuilder(item);_visitables.get("sources").add(builder);this.sources.add(builder);} return (A)this;
  }
  public A removeFromSources(io.fabric8.camelk.v1.SourceSpec... items) {
    for (io.fabric8.camelk.v1.SourceSpec item : items) {io.fabric8.camelk.v1.SourceSpecBuilder builder = new io.fabric8.camelk.v1.SourceSpecBuilder(item);_visitables.get("sources").remove(builder);if (this.sources != null) {this.sources.remove(builder);}} return (A)this;
  }
  public A removeAllFromSources(java.util.Collection<io.fabric8.camelk.v1.SourceSpec> items) {
    for (io.fabric8.camelk.v1.SourceSpec item : items) {io.fabric8.camelk.v1.SourceSpecBuilder builder = new io.fabric8.camelk.v1.SourceSpecBuilder(item);_visitables.get("sources").remove(builder);if (this.sources != null) {this.sources.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSources(java.util.function.Predicate<io.fabric8.camelk.v1.SourceSpecBuilder> predicate) {
    if (sources == null) return (A) this;
    final Iterator<io.fabric8.camelk.v1.SourceSpecBuilder> each = sources.iterator();
    final List visitables = _visitables.get("sources");
    while (each.hasNext()) {
      io.fabric8.camelk.v1.SourceSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSources instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.camelk.v1.SourceSpec> getSources() {
    return build(sources);
  }
  public java.util.List<io.fabric8.camelk.v1.SourceSpec> buildSources() {
    return build(sources);
  }
  public io.fabric8.camelk.v1.SourceSpec buildSource(java.lang.Integer index) {
    return this.sources.get(index).build();
  }
  public io.fabric8.camelk.v1.SourceSpec buildFirstSource() {
    return this.sources.get(0).build();
  }
  public io.fabric8.camelk.v1.SourceSpec buildLastSource() {
    return this.sources.get(sources.size() - 1).build();
  }
  public io.fabric8.camelk.v1.SourceSpec buildMatchingSource(java.util.function.Predicate<io.fabric8.camelk.v1.SourceSpecBuilder> predicate) {
    for (io.fabric8.camelk.v1.SourceSpecBuilder item: sources) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingSource(java.util.function.Predicate<io.fabric8.camelk.v1.SourceSpecBuilder> predicate) {
    for (io.fabric8.camelk.v1.SourceSpecBuilder item: sources) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSources(java.util.List<io.fabric8.camelk.v1.SourceSpec> sources) {
    if (this.sources != null) { _visitables.get("sources").removeAll(this.sources);}
    if (sources != null) {this.sources = new java.util.ArrayList(); for (io.fabric8.camelk.v1.SourceSpec item : sources){this.addToSources(item);}} else { this.sources = null;} return (A) this;
  }
  public A withSources(io.fabric8.camelk.v1.SourceSpec... sources) {
    if (this.sources != null) {this.sources.clear();}
    if (sources != null) {for (io.fabric8.camelk.v1.SourceSpec item :sources){ this.addToSources(item);}} return (A) this;
  }
  public java.lang.Boolean hasSources() {
    return sources != null && !sources.isEmpty();
  }
  public io.fabric8.camelk.v1.IntegrationSpecFluent.SourcesNested<A> addNewSource() {
    return new io.fabric8.camelk.v1.IntegrationSpecFluentImpl.SourcesNestedImpl();
  }
  public io.fabric8.camelk.v1.IntegrationSpecFluent.SourcesNested<A> addNewSourceLike(io.fabric8.camelk.v1.SourceSpec item) {
    return new io.fabric8.camelk.v1.IntegrationSpecFluentImpl.SourcesNestedImpl(-1, item);
  }
  public io.fabric8.camelk.v1.IntegrationSpecFluent.SourcesNested<A> setNewSourceLike(java.lang.Integer index,io.fabric8.camelk.v1.SourceSpec item) {
    return new io.fabric8.camelk.v1.IntegrationSpecFluentImpl.SourcesNestedImpl(index, item);
  }
  public io.fabric8.camelk.v1.IntegrationSpecFluent.SourcesNested<A> editSource(java.lang.Integer index) {
    if (sources.size() <= index) throw new RuntimeException("Can't edit sources. Index exceeds size.");
    return setNewSourceLike(index, buildSource(index));
  }
  public io.fabric8.camelk.v1.IntegrationSpecFluent.SourcesNested<A> editFirstSource() {
    if (sources.size() == 0) throw new RuntimeException("Can't edit first sources. The list is empty.");
    return setNewSourceLike(0, buildSource(0));
  }
  public io.fabric8.camelk.v1.IntegrationSpecFluent.SourcesNested<A> editLastSource() {
    int index = sources.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last sources. The list is empty.");
    return setNewSourceLike(index, buildSource(index));
  }
  public io.fabric8.camelk.v1.IntegrationSpecFluent.SourcesNested<A> editMatchingSource(java.util.function.Predicate<io.fabric8.camelk.v1.SourceSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<sources.size();i++) { 
    if (predicate.test(sources.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching sources. No match found.");
    return setNewSourceLike(index, buildSource(index));
  }
  
  /**
   * This method has been deprecated, please use method buildTemplate instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.camelk.v1.PodSpecTemplate getTemplate() {
    return this.template!=null?this.template.build():null;
  }
  public io.fabric8.camelk.v1.PodSpecTemplate buildTemplate() {
    return this.template!=null?this.template.build():null;
  }
  public A withTemplate(io.fabric8.camelk.v1.PodSpecTemplate template) {
    _visitables.get("template").remove(this.template);
    if (template!=null){ this.template= new io.fabric8.camelk.v1.PodSpecTemplateBuilder(template); _visitables.get("template").add(this.template);} return (A) this;
  }
  public java.lang.Boolean hasTemplate() {
    return this.template != null;
  }
  public io.fabric8.camelk.v1.IntegrationSpecFluent.TemplateNested<A> withNewTemplate() {
    return new io.fabric8.camelk.v1.IntegrationSpecFluentImpl.TemplateNestedImpl();
  }
  public io.fabric8.camelk.v1.IntegrationSpecFluent.TemplateNested<A> withNewTemplateLike(io.fabric8.camelk.v1.PodSpecTemplate item) {
    return new io.fabric8.camelk.v1.IntegrationSpecFluentImpl.TemplateNestedImpl(item);
  }
  public io.fabric8.camelk.v1.IntegrationSpecFluent.TemplateNested<A> editTemplate() {
    return withNewTemplateLike(getTemplate());
  }
  public io.fabric8.camelk.v1.IntegrationSpecFluent.TemplateNested<A> editOrNewTemplate() {
    return withNewTemplateLike(getTemplate() != null ? getTemplate(): new io.fabric8.camelk.v1.PodSpecTemplateBuilder().build());
  }
  public io.fabric8.camelk.v1.IntegrationSpecFluent.TemplateNested<A> editOrNewTemplateLike(io.fabric8.camelk.v1.PodSpecTemplate item) {
    return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
  }
  public A addToTraits(java.lang.String key,io.fabric8.camelk.v1.TraitSpec value) {
    if(this.traits == null && key != null && value != null) { this.traits = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.traits.put(key, value);} return (A)this;
  }
  public A addToTraits(java.util.Map<java.lang.String,io.fabric8.camelk.v1.TraitSpec> map) {
    if(this.traits == null && map != null) { this.traits = new java.util.LinkedHashMap(); }
    if(map != null) { this.traits.putAll(map);} return (A)this;
  }
  public A removeFromTraits(java.lang.String key) {
    if(this.traits == null) { return (A) this; }
    if(key != null && this.traits != null) {this.traits.remove(key);} return (A)this;
  }
  public A removeFromTraits(java.util.Map<java.lang.String,io.fabric8.camelk.v1.TraitSpec> map) {
    if(this.traits == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.traits != null){this.traits.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,io.fabric8.camelk.v1.TraitSpec> getTraits() {
    return this.traits;
  }
  public <K,V>A withTraits(java.util.Map<java.lang.String,io.fabric8.camelk.v1.TraitSpec> traits) {
    if (traits == null) { this.traits =  null;} else {this.traits = new java.util.LinkedHashMap(traits);} return (A) this;
  }
  public java.lang.Boolean hasTraits() {
    return this.traits != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    IntegrationSpecFluentImpl that = (IntegrationSpecFluentImpl) o;
    if (configuration != null ? !configuration.equals(that.configuration) :that.configuration != null) return false;
    if (dependencies != null ? !dependencies.equals(that.dependencies) :that.dependencies != null) return false;
    if (flows != null ? !flows.equals(that.flows) :that.flows != null) return false;
    if (integrationKit != null ? !integrationKit.equals(that.integrationKit) :that.integrationKit != null) return false;
    if (kit != null ? !kit.equals(that.kit) :that.kit != null) return false;
    if (profile != null ? !profile.equals(that.profile) :that.profile != null) return false;
    if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
    if (repositories != null ? !repositories.equals(that.repositories) :that.repositories != null) return false;
    if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
    if (serviceAccountName != null ? !serviceAccountName.equals(that.serviceAccountName) :that.serviceAccountName != null) return false;
    if (sources != null ? !sources.equals(that.sources) :that.sources != null) return false;
    if (template != null ? !template.equals(that.template) :that.template != null) return false;
    if (traits != null ? !traits.equals(that.traits) :that.traits != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(configuration,  dependencies,  flows,  integrationKit,  kit,  profile,  replicas,  repositories,  resources,  serviceAccountName,  sources,  template,  traits,  super.hashCode());
  }
  public class ConfigurationNestedImpl<N> extends io.fabric8.camelk.v1.ConfigurationSpecFluentImpl<io.fabric8.camelk.v1.IntegrationSpecFluent.ConfigurationNested<N>> implements io.fabric8.camelk.v1.IntegrationSpecFluent.ConfigurationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ConfigurationNestedImpl(java.lang.Integer index,io.fabric8.camelk.v1.ConfigurationSpec item) {
      this.index = index;
      this.builder = new io.fabric8.camelk.v1.ConfigurationSpecBuilder(this, item);
    }
    ConfigurationNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.camelk.v1.ConfigurationSpecBuilder(this);
    }
    io.fabric8.camelk.v1.ConfigurationSpecBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) IntegrationSpecFluentImpl.this.setToConfiguration(index,builder.build());
    }
    public N endConfiguration() {
      return and();
    }
    
  }
  public class IntegrationKitNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl<io.fabric8.camelk.v1.IntegrationSpecFluent.IntegrationKitNested<N>> implements io.fabric8.camelk.v1.IntegrationSpecFluent.IntegrationKitNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    IntegrationKitNestedImpl(io.fabric8.kubernetes.api.model.ObjectReference item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this, item);
    }
    IntegrationKitNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder;
    public N and() {
      return (N) IntegrationSpecFluentImpl.this.withIntegrationKit(builder.build());
    }
    public N endIntegrationKit() {
      return and();
    }
    
  }
  public class ResourcesNestedImpl<N> extends io.fabric8.camelk.v1.ResourceSpecFluentImpl<io.fabric8.camelk.v1.IntegrationSpecFluent.ResourcesNested<N>> implements io.fabric8.camelk.v1.IntegrationSpecFluent.ResourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ResourcesNestedImpl(java.lang.Integer index,io.fabric8.camelk.v1.ResourceSpec item) {
      this.index = index;
      this.builder = new io.fabric8.camelk.v1.ResourceSpecBuilder(this, item);
    }
    ResourcesNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.camelk.v1.ResourceSpecBuilder(this);
    }
    io.fabric8.camelk.v1.ResourceSpecBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) IntegrationSpecFluentImpl.this.setToResources(index,builder.build());
    }
    public N endResource() {
      return and();
    }
    
  }
  public class SourcesNestedImpl<N> extends io.fabric8.camelk.v1.SourceSpecFluentImpl<io.fabric8.camelk.v1.IntegrationSpecFluent.SourcesNested<N>> implements io.fabric8.camelk.v1.IntegrationSpecFluent.SourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    SourcesNestedImpl(java.lang.Integer index,io.fabric8.camelk.v1.SourceSpec item) {
      this.index = index;
      this.builder = new io.fabric8.camelk.v1.SourceSpecBuilder(this, item);
    }
    SourcesNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.camelk.v1.SourceSpecBuilder(this);
    }
    io.fabric8.camelk.v1.SourceSpecBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) IntegrationSpecFluentImpl.this.setToSources(index,builder.build());
    }
    public N endSource() {
      return and();
    }
    
  }
  public class TemplateNestedImpl<N> extends io.fabric8.camelk.v1.PodSpecTemplateFluentImpl<io.fabric8.camelk.v1.IntegrationSpecFluent.TemplateNested<N>> implements io.fabric8.camelk.v1.IntegrationSpecFluent.TemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    TemplateNestedImpl(io.fabric8.camelk.v1.PodSpecTemplate item) {
      this.builder = new io.fabric8.camelk.v1.PodSpecTemplateBuilder(this, item);
    }
    TemplateNestedImpl() {
      this.builder = new io.fabric8.camelk.v1.PodSpecTemplateBuilder(this);
    }
    io.fabric8.camelk.v1.PodSpecTemplateBuilder builder;
    public N and() {
      return (N) IntegrationSpecFluentImpl.this.withTemplate(builder.build());
    }
    public N endTemplate() {
      return and();
    }
    
  }
  
}