package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class KanikoTaskBuilder extends io.fabric8.camelk.v1.KanikoTaskFluentImpl<io.fabric8.camelk.v1.KanikoTaskBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.camelk.v1.KanikoTask,io.fabric8.camelk.v1.KanikoTaskBuilder>{
  public KanikoTaskBuilder() {
    this(false);
  }
  public KanikoTaskBuilder(java.lang.Boolean validationEnabled) {
    this(new KanikoTask(), validationEnabled);
  }
  public KanikoTaskBuilder(io.fabric8.camelk.v1.KanikoTaskFluent<?> fluent) {
    this(fluent, false);
  }
  public KanikoTaskBuilder(io.fabric8.camelk.v1.KanikoTaskFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new KanikoTask(), validationEnabled);
  }
  public KanikoTaskBuilder(io.fabric8.camelk.v1.KanikoTaskFluent<?> fluent,io.fabric8.camelk.v1.KanikoTask instance) {
    this(fluent, instance, false);
  }
  public KanikoTaskBuilder(io.fabric8.camelk.v1.KanikoTaskFluent<?> fluent,io.fabric8.camelk.v1.KanikoTask instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBaseImage(instance.getBaseImage()); 
    fluent.withCache(instance.getCache()); 
    fluent.withContextDir(instance.getContextDir()); 
    fluent.withHttpProxySecret(instance.getHttpProxySecret()); 
    fluent.withImage(instance.getImage()); 
    fluent.withName(instance.getName()); 
    fluent.withRegistry(instance.getRegistry()); 
    fluent.withVerbose(instance.getVerbose()); 
    this.validationEnabled = validationEnabled; 
  }
  public KanikoTaskBuilder(io.fabric8.camelk.v1.KanikoTask instance) {
    this(instance,false);
  }
  public KanikoTaskBuilder(io.fabric8.camelk.v1.KanikoTask instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withBaseImage(instance.getBaseImage()); 
    this.withCache(instance.getCache()); 
    this.withContextDir(instance.getContextDir()); 
    this.withHttpProxySecret(instance.getHttpProxySecret()); 
    this.withImage(instance.getImage()); 
    this.withName(instance.getName()); 
    this.withRegistry(instance.getRegistry()); 
    this.withVerbose(instance.getVerbose()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.camelk.v1.KanikoTaskFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.camelk.v1.KanikoTask build() {
    KanikoTask buildable = new KanikoTask(fluent.getBaseImage(),fluent.getCache(),fluent.getContextDir(),fluent.getHttpProxySecret(),fluent.getImage(),fluent.getName(),fluent.getRegistry(),fluent.getVerbose());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KanikoTaskBuilder that = (KanikoTaskBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}