package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
public class CamelArtifactFluentImpl<A extends io.fabric8.camelk.v1.CamelArtifactFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.camelk.v1.CamelArtifactFluent<A>{
  public CamelArtifactFluentImpl() {
  }
  public CamelArtifactFluentImpl(io.fabric8.camelk.v1.CamelArtifact instance) {
    this.withArtifactId(instance.getArtifactId()); 
    this.withDataformats(instance.getDataformats()); 
    this.withDependencies(instance.getDependencies()); 
    this.withExclusions(instance.getExclusions()); 
    this.withGroupId(instance.getGroupId()); 
    this.withJavaTypes(instance.getJavaTypes()); 
    this.withLanguages(instance.getLanguages()); 
    this.withSchemes(instance.getSchemes()); 
    this.withVersion(instance.getVersion()); 
  }
  private java.lang.String artifactId;
  private java.util.List<java.lang.String> dataformats;
  private java.util.List<io.fabric8.camelk.v1.CamelArtifactDependencyBuilder> dependencies;
  private java.util.List<io.fabric8.camelk.v1.CamelArtifactExclusionBuilder> exclusions;
  private java.lang.String groupId;
  private java.util.List<java.lang.String> javaTypes;
  private java.util.List<java.lang.String> languages;
  private java.util.List<io.fabric8.camelk.v1.CamelSchemeBuilder> schemes;
  private java.lang.String version;
  public java.lang.String getArtifactId() {
    return this.artifactId;
  }
  public A withArtifactId(java.lang.String artifactId) {
    this.artifactId=artifactId; return (A) this;
  }
  public java.lang.Boolean hasArtifactId() {
    return this.artifactId != null;
  }
  
  /**
   * Method is deprecated. use withArtifactId instead.
   */
  @java.lang.Deprecated
  public A withNewArtifactId(java.lang.String arg0) {
    return (A)withArtifactId(new String(arg0));
  }
  public A addToDataformats(java.lang.Integer index,java.lang.String item) {
    if (this.dataformats == null) {this.dataformats = new java.util.ArrayList<java.lang.String>();}
    this.dataformats.add(index, item);
    return (A)this;
  }
  public A setToDataformats(java.lang.Integer index,java.lang.String item) {
    if (this.dataformats == null) {this.dataformats = new java.util.ArrayList<java.lang.String>();}
    this.dataformats.set(index, item); return (A)this;
  }
  public A addToDataformats(java.lang.String... items) {
    if (this.dataformats == null) {this.dataformats = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.dataformats.add(item);} return (A)this;
  }
  public A addAllToDataformats(java.util.Collection<java.lang.String> items) {
    if (this.dataformats == null) {this.dataformats = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.dataformats.add(item);} return (A)this;
  }
  public A removeFromDataformats(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.dataformats!= null){ this.dataformats.remove(item);}} return (A)this;
  }
  public A removeAllFromDataformats(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.dataformats!= null){ this.dataformats.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getDataformats() {
    return this.dataformats;
  }
  public java.lang.String getDataformat(java.lang.Integer index) {
    return this.dataformats.get(index);
  }
  public java.lang.String getFirstDataformat() {
    return this.dataformats.get(0);
  }
  public java.lang.String getLastDataformat() {
    return this.dataformats.get(dataformats.size() - 1);
  }
  public java.lang.String getMatchingDataformat(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: dataformats) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingDataformat(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: dataformats) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDataformats(java.util.List<java.lang.String> dataformats) {
    if (dataformats != null) {this.dataformats = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : dataformats){this.addToDataformats(item);}} else { this.dataformats = null;} return (A) this;
  }
  public A withDataformats(java.lang.String... dataformats) {
    if (this.dataformats != null) {this.dataformats.clear();}
    if (dataformats != null) {for (java.lang.String item :dataformats){ this.addToDataformats(item);}} return (A) this;
  }
  public java.lang.Boolean hasDataformats() {
    return dataformats != null && !dataformats.isEmpty();
  }
  public A addNewDataformat(java.lang.String arg0) {
    return (A)addToDataformats(new String(arg0));
  }
  public A addToDependencies(java.lang.Integer index,io.fabric8.camelk.v1.CamelArtifactDependency item) {
    if (this.dependencies == null) {this.dependencies = new java.util.ArrayList<io.fabric8.camelk.v1.CamelArtifactDependencyBuilder>();}
    io.fabric8.camelk.v1.CamelArtifactDependencyBuilder builder = new io.fabric8.camelk.v1.CamelArtifactDependencyBuilder(item);_visitables.get("dependencies").add(index >= 0 ? index : _visitables.get("dependencies").size(), builder);this.dependencies.add(index >= 0 ? index : dependencies.size(), builder); return (A)this;
  }
  public A setToDependencies(java.lang.Integer index,io.fabric8.camelk.v1.CamelArtifactDependency item) {
    if (this.dependencies == null) {this.dependencies = new java.util.ArrayList<io.fabric8.camelk.v1.CamelArtifactDependencyBuilder>();}
    io.fabric8.camelk.v1.CamelArtifactDependencyBuilder builder = new io.fabric8.camelk.v1.CamelArtifactDependencyBuilder(item);
    if (index < 0 || index >= _visitables.get("dependencies").size()) { _visitables.get("dependencies").add(builder); } else { _visitables.get("dependencies").set(index, builder);}
    if (index < 0 || index >= dependencies.size()) { dependencies.add(builder); } else { dependencies.set(index, builder);}
     return (A)this;
  }
  public A addToDependencies(io.fabric8.camelk.v1.CamelArtifactDependency... items) {
    if (this.dependencies == null) {this.dependencies = new java.util.ArrayList<io.fabric8.camelk.v1.CamelArtifactDependencyBuilder>();}
    for (io.fabric8.camelk.v1.CamelArtifactDependency item : items) {io.fabric8.camelk.v1.CamelArtifactDependencyBuilder builder = new io.fabric8.camelk.v1.CamelArtifactDependencyBuilder(item);_visitables.get("dependencies").add(builder);this.dependencies.add(builder);} return (A)this;
  }
  public A addAllToDependencies(java.util.Collection<io.fabric8.camelk.v1.CamelArtifactDependency> items) {
    if (this.dependencies == null) {this.dependencies = new java.util.ArrayList<io.fabric8.camelk.v1.CamelArtifactDependencyBuilder>();}
    for (io.fabric8.camelk.v1.CamelArtifactDependency item : items) {io.fabric8.camelk.v1.CamelArtifactDependencyBuilder builder = new io.fabric8.camelk.v1.CamelArtifactDependencyBuilder(item);_visitables.get("dependencies").add(builder);this.dependencies.add(builder);} return (A)this;
  }
  public A removeFromDependencies(io.fabric8.camelk.v1.CamelArtifactDependency... items) {
    for (io.fabric8.camelk.v1.CamelArtifactDependency item : items) {io.fabric8.camelk.v1.CamelArtifactDependencyBuilder builder = new io.fabric8.camelk.v1.CamelArtifactDependencyBuilder(item);_visitables.get("dependencies").remove(builder);if (this.dependencies != null) {this.dependencies.remove(builder);}} return (A)this;
  }
  public A removeAllFromDependencies(java.util.Collection<io.fabric8.camelk.v1.CamelArtifactDependency> items) {
    for (io.fabric8.camelk.v1.CamelArtifactDependency item : items) {io.fabric8.camelk.v1.CamelArtifactDependencyBuilder builder = new io.fabric8.camelk.v1.CamelArtifactDependencyBuilder(item);_visitables.get("dependencies").remove(builder);if (this.dependencies != null) {this.dependencies.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromDependencies(java.util.function.Predicate<io.fabric8.camelk.v1.CamelArtifactDependencyBuilder> predicate) {
    if (dependencies == null) return (A) this;
    final Iterator<io.fabric8.camelk.v1.CamelArtifactDependencyBuilder> each = dependencies.iterator();
    final List visitables = _visitables.get("dependencies");
    while (each.hasNext()) {
      io.fabric8.camelk.v1.CamelArtifactDependencyBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildDependencies instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.camelk.v1.CamelArtifactDependency> getDependencies() {
    return build(dependencies);
  }
  public java.util.List<io.fabric8.camelk.v1.CamelArtifactDependency> buildDependencies() {
    return build(dependencies);
  }
  public io.fabric8.camelk.v1.CamelArtifactDependency buildDependency(java.lang.Integer index) {
    return this.dependencies.get(index).build();
  }
  public io.fabric8.camelk.v1.CamelArtifactDependency buildFirstDependency() {
    return this.dependencies.get(0).build();
  }
  public io.fabric8.camelk.v1.CamelArtifactDependency buildLastDependency() {
    return this.dependencies.get(dependencies.size() - 1).build();
  }
  public io.fabric8.camelk.v1.CamelArtifactDependency buildMatchingDependency(java.util.function.Predicate<io.fabric8.camelk.v1.CamelArtifactDependencyBuilder> predicate) {
    for (io.fabric8.camelk.v1.CamelArtifactDependencyBuilder item: dependencies) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingDependency(java.util.function.Predicate<io.fabric8.camelk.v1.CamelArtifactDependencyBuilder> predicate) {
    for (io.fabric8.camelk.v1.CamelArtifactDependencyBuilder item: dependencies) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDependencies(java.util.List<io.fabric8.camelk.v1.CamelArtifactDependency> dependencies) {
    if (this.dependencies != null) { _visitables.get("dependencies").removeAll(this.dependencies);}
    if (dependencies != null) {this.dependencies = new java.util.ArrayList<io.fabric8.camelk.v1.CamelArtifactDependencyBuilder>(); for (io.fabric8.camelk.v1.CamelArtifactDependency item : dependencies){this.addToDependencies(item);}} else { this.dependencies = null;} return (A) this;
  }
  public A withDependencies(io.fabric8.camelk.v1.CamelArtifactDependency... dependencies) {
    if (this.dependencies != null) {this.dependencies.clear();}
    if (dependencies != null) {for (io.fabric8.camelk.v1.CamelArtifactDependency item :dependencies){ this.addToDependencies(item);}} return (A) this;
  }
  public java.lang.Boolean hasDependencies() {
    return dependencies != null && !dependencies.isEmpty();
  }
  public io.fabric8.camelk.v1.CamelArtifactFluent.DependenciesNested<A> addNewDependency() {
    return new io.fabric8.camelk.v1.CamelArtifactFluentImpl.DependenciesNestedImpl();
  }
  public io.fabric8.camelk.v1.CamelArtifactFluent.DependenciesNested<A> addNewDependencyLike(io.fabric8.camelk.v1.CamelArtifactDependency item) {
    return new io.fabric8.camelk.v1.CamelArtifactFluentImpl.DependenciesNestedImpl(-1, item);
  }
  public io.fabric8.camelk.v1.CamelArtifactFluent.DependenciesNested<A> setNewDependencyLike(java.lang.Integer index,io.fabric8.camelk.v1.CamelArtifactDependency item) {
    return new io.fabric8.camelk.v1.CamelArtifactFluentImpl.DependenciesNestedImpl(index, item);
  }
  public io.fabric8.camelk.v1.CamelArtifactFluent.DependenciesNested<A> editDependency(java.lang.Integer index) {
    if (dependencies.size() <= index) throw new RuntimeException("Can't edit dependencies. Index exceeds size.");
    return setNewDependencyLike(index, buildDependency(index));
  }
  public io.fabric8.camelk.v1.CamelArtifactFluent.DependenciesNested<A> editFirstDependency() {
    if (dependencies.size() == 0) throw new RuntimeException("Can't edit first dependencies. The list is empty.");
    return setNewDependencyLike(0, buildDependency(0));
  }
  public io.fabric8.camelk.v1.CamelArtifactFluent.DependenciesNested<A> editLastDependency() {
    int index = dependencies.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last dependencies. The list is empty.");
    return setNewDependencyLike(index, buildDependency(index));
  }
  public io.fabric8.camelk.v1.CamelArtifactFluent.DependenciesNested<A> editMatchingDependency(java.util.function.Predicate<io.fabric8.camelk.v1.CamelArtifactDependencyBuilder> predicate) {
    int index = -1;
    for (int i=0;i<dependencies.size();i++) { 
    if (predicate.test(dependencies.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching dependencies. No match found.");
    return setNewDependencyLike(index, buildDependency(index));
  }
  public A addToExclusions(java.lang.Integer index,io.fabric8.camelk.v1.CamelArtifactExclusion item) {
    if (this.exclusions == null) {this.exclusions = new java.util.ArrayList<io.fabric8.camelk.v1.CamelArtifactExclusionBuilder>();}
    io.fabric8.camelk.v1.CamelArtifactExclusionBuilder builder = new io.fabric8.camelk.v1.CamelArtifactExclusionBuilder(item);_visitables.get("exclusions").add(index >= 0 ? index : _visitables.get("exclusions").size(), builder);this.exclusions.add(index >= 0 ? index : exclusions.size(), builder); return (A)this;
  }
  public A setToExclusions(java.lang.Integer index,io.fabric8.camelk.v1.CamelArtifactExclusion item) {
    if (this.exclusions == null) {this.exclusions = new java.util.ArrayList<io.fabric8.camelk.v1.CamelArtifactExclusionBuilder>();}
    io.fabric8.camelk.v1.CamelArtifactExclusionBuilder builder = new io.fabric8.camelk.v1.CamelArtifactExclusionBuilder(item);
    if (index < 0 || index >= _visitables.get("exclusions").size()) { _visitables.get("exclusions").add(builder); } else { _visitables.get("exclusions").set(index, builder);}
    if (index < 0 || index >= exclusions.size()) { exclusions.add(builder); } else { exclusions.set(index, builder);}
     return (A)this;
  }
  public A addToExclusions(io.fabric8.camelk.v1.CamelArtifactExclusion... items) {
    if (this.exclusions == null) {this.exclusions = new java.util.ArrayList<io.fabric8.camelk.v1.CamelArtifactExclusionBuilder>();}
    for (io.fabric8.camelk.v1.CamelArtifactExclusion item : items) {io.fabric8.camelk.v1.CamelArtifactExclusionBuilder builder = new io.fabric8.camelk.v1.CamelArtifactExclusionBuilder(item);_visitables.get("exclusions").add(builder);this.exclusions.add(builder);} return (A)this;
  }
  public A addAllToExclusions(java.util.Collection<io.fabric8.camelk.v1.CamelArtifactExclusion> items) {
    if (this.exclusions == null) {this.exclusions = new java.util.ArrayList<io.fabric8.camelk.v1.CamelArtifactExclusionBuilder>();}
    for (io.fabric8.camelk.v1.CamelArtifactExclusion item : items) {io.fabric8.camelk.v1.CamelArtifactExclusionBuilder builder = new io.fabric8.camelk.v1.CamelArtifactExclusionBuilder(item);_visitables.get("exclusions").add(builder);this.exclusions.add(builder);} return (A)this;
  }
  public A removeFromExclusions(io.fabric8.camelk.v1.CamelArtifactExclusion... items) {
    for (io.fabric8.camelk.v1.CamelArtifactExclusion item : items) {io.fabric8.camelk.v1.CamelArtifactExclusionBuilder builder = new io.fabric8.camelk.v1.CamelArtifactExclusionBuilder(item);_visitables.get("exclusions").remove(builder);if (this.exclusions != null) {this.exclusions.remove(builder);}} return (A)this;
  }
  public A removeAllFromExclusions(java.util.Collection<io.fabric8.camelk.v1.CamelArtifactExclusion> items) {
    for (io.fabric8.camelk.v1.CamelArtifactExclusion item : items) {io.fabric8.camelk.v1.CamelArtifactExclusionBuilder builder = new io.fabric8.camelk.v1.CamelArtifactExclusionBuilder(item);_visitables.get("exclusions").remove(builder);if (this.exclusions != null) {this.exclusions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromExclusions(java.util.function.Predicate<io.fabric8.camelk.v1.CamelArtifactExclusionBuilder> predicate) {
    if (exclusions == null) return (A) this;
    final Iterator<io.fabric8.camelk.v1.CamelArtifactExclusionBuilder> each = exclusions.iterator();
    final List visitables = _visitables.get("exclusions");
    while (each.hasNext()) {
      io.fabric8.camelk.v1.CamelArtifactExclusionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildExclusions instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.camelk.v1.CamelArtifactExclusion> getExclusions() {
    return build(exclusions);
  }
  public java.util.List<io.fabric8.camelk.v1.CamelArtifactExclusion> buildExclusions() {
    return build(exclusions);
  }
  public io.fabric8.camelk.v1.CamelArtifactExclusion buildExclusion(java.lang.Integer index) {
    return this.exclusions.get(index).build();
  }
  public io.fabric8.camelk.v1.CamelArtifactExclusion buildFirstExclusion() {
    return this.exclusions.get(0).build();
  }
  public io.fabric8.camelk.v1.CamelArtifactExclusion buildLastExclusion() {
    return this.exclusions.get(exclusions.size() - 1).build();
  }
  public io.fabric8.camelk.v1.CamelArtifactExclusion buildMatchingExclusion(java.util.function.Predicate<io.fabric8.camelk.v1.CamelArtifactExclusionBuilder> predicate) {
    for (io.fabric8.camelk.v1.CamelArtifactExclusionBuilder item: exclusions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingExclusion(java.util.function.Predicate<io.fabric8.camelk.v1.CamelArtifactExclusionBuilder> predicate) {
    for (io.fabric8.camelk.v1.CamelArtifactExclusionBuilder item: exclusions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withExclusions(java.util.List<io.fabric8.camelk.v1.CamelArtifactExclusion> exclusions) {
    if (this.exclusions != null) { _visitables.get("exclusions").removeAll(this.exclusions);}
    if (exclusions != null) {this.exclusions = new java.util.ArrayList<io.fabric8.camelk.v1.CamelArtifactExclusionBuilder>(); for (io.fabric8.camelk.v1.CamelArtifactExclusion item : exclusions){this.addToExclusions(item);}} else { this.exclusions = null;} return (A) this;
  }
  public A withExclusions(io.fabric8.camelk.v1.CamelArtifactExclusion... exclusions) {
    if (this.exclusions != null) {this.exclusions.clear();}
    if (exclusions != null) {for (io.fabric8.camelk.v1.CamelArtifactExclusion item :exclusions){ this.addToExclusions(item);}} return (A) this;
  }
  public java.lang.Boolean hasExclusions() {
    return exclusions != null && !exclusions.isEmpty();
  }
  public A addNewExclusion(java.lang.String artifactId,java.lang.String groupId) {
    return (A)addToExclusions(new CamelArtifactExclusion(artifactId, groupId));
  }
  public io.fabric8.camelk.v1.CamelArtifactFluent.ExclusionsNested<A> addNewExclusion() {
    return new io.fabric8.camelk.v1.CamelArtifactFluentImpl.ExclusionsNestedImpl();
  }
  public io.fabric8.camelk.v1.CamelArtifactFluent.ExclusionsNested<A> addNewExclusionLike(io.fabric8.camelk.v1.CamelArtifactExclusion item) {
    return new io.fabric8.camelk.v1.CamelArtifactFluentImpl.ExclusionsNestedImpl(-1, item);
  }
  public io.fabric8.camelk.v1.CamelArtifactFluent.ExclusionsNested<A> setNewExclusionLike(java.lang.Integer index,io.fabric8.camelk.v1.CamelArtifactExclusion item) {
    return new io.fabric8.camelk.v1.CamelArtifactFluentImpl.ExclusionsNestedImpl(index, item);
  }
  public io.fabric8.camelk.v1.CamelArtifactFluent.ExclusionsNested<A> editExclusion(java.lang.Integer index) {
    if (exclusions.size() <= index) throw new RuntimeException("Can't edit exclusions. Index exceeds size.");
    return setNewExclusionLike(index, buildExclusion(index));
  }
  public io.fabric8.camelk.v1.CamelArtifactFluent.ExclusionsNested<A> editFirstExclusion() {
    if (exclusions.size() == 0) throw new RuntimeException("Can't edit first exclusions. The list is empty.");
    return setNewExclusionLike(0, buildExclusion(0));
  }
  public io.fabric8.camelk.v1.CamelArtifactFluent.ExclusionsNested<A> editLastExclusion() {
    int index = exclusions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last exclusions. The list is empty.");
    return setNewExclusionLike(index, buildExclusion(index));
  }
  public io.fabric8.camelk.v1.CamelArtifactFluent.ExclusionsNested<A> editMatchingExclusion(java.util.function.Predicate<io.fabric8.camelk.v1.CamelArtifactExclusionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<exclusions.size();i++) { 
    if (predicate.test(exclusions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching exclusions. No match found.");
    return setNewExclusionLike(index, buildExclusion(index));
  }
  public java.lang.String getGroupId() {
    return this.groupId;
  }
  public A withGroupId(java.lang.String groupId) {
    this.groupId=groupId; return (A) this;
  }
  public java.lang.Boolean hasGroupId() {
    return this.groupId != null;
  }
  
  /**
   * Method is deprecated. use withGroupId instead.
   */
  @java.lang.Deprecated
  public A withNewGroupId(java.lang.String arg0) {
    return (A)withGroupId(new String(arg0));
  }
  public A addToJavaTypes(java.lang.Integer index,java.lang.String item) {
    if (this.javaTypes == null) {this.javaTypes = new java.util.ArrayList<java.lang.String>();}
    this.javaTypes.add(index, item);
    return (A)this;
  }
  public A setToJavaTypes(java.lang.Integer index,java.lang.String item) {
    if (this.javaTypes == null) {this.javaTypes = new java.util.ArrayList<java.lang.String>();}
    this.javaTypes.set(index, item); return (A)this;
  }
  public A addToJavaTypes(java.lang.String... items) {
    if (this.javaTypes == null) {this.javaTypes = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.javaTypes.add(item);} return (A)this;
  }
  public A addAllToJavaTypes(java.util.Collection<java.lang.String> items) {
    if (this.javaTypes == null) {this.javaTypes = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.javaTypes.add(item);} return (A)this;
  }
  public A removeFromJavaTypes(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.javaTypes!= null){ this.javaTypes.remove(item);}} return (A)this;
  }
  public A removeAllFromJavaTypes(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.javaTypes!= null){ this.javaTypes.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getJavaTypes() {
    return this.javaTypes;
  }
  public java.lang.String getJavaType(java.lang.Integer index) {
    return this.javaTypes.get(index);
  }
  public java.lang.String getFirstJavaType() {
    return this.javaTypes.get(0);
  }
  public java.lang.String getLastJavaType() {
    return this.javaTypes.get(javaTypes.size() - 1);
  }
  public java.lang.String getMatchingJavaType(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: javaTypes) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingJavaType(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: javaTypes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withJavaTypes(java.util.List<java.lang.String> javaTypes) {
    if (javaTypes != null) {this.javaTypes = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : javaTypes){this.addToJavaTypes(item);}} else { this.javaTypes = null;} return (A) this;
  }
  public A withJavaTypes(java.lang.String... javaTypes) {
    if (this.javaTypes != null) {this.javaTypes.clear();}
    if (javaTypes != null) {for (java.lang.String item :javaTypes){ this.addToJavaTypes(item);}} return (A) this;
  }
  public java.lang.Boolean hasJavaTypes() {
    return javaTypes != null && !javaTypes.isEmpty();
  }
  public A addNewJavaType(java.lang.String arg0) {
    return (A)addToJavaTypes(new String(arg0));
  }
  public A addToLanguages(java.lang.Integer index,java.lang.String item) {
    if (this.languages == null) {this.languages = new java.util.ArrayList<java.lang.String>();}
    this.languages.add(index, item);
    return (A)this;
  }
  public A setToLanguages(java.lang.Integer index,java.lang.String item) {
    if (this.languages == null) {this.languages = new java.util.ArrayList<java.lang.String>();}
    this.languages.set(index, item); return (A)this;
  }
  public A addToLanguages(java.lang.String... items) {
    if (this.languages == null) {this.languages = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.languages.add(item);} return (A)this;
  }
  public A addAllToLanguages(java.util.Collection<java.lang.String> items) {
    if (this.languages == null) {this.languages = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.languages.add(item);} return (A)this;
  }
  public A removeFromLanguages(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.languages!= null){ this.languages.remove(item);}} return (A)this;
  }
  public A removeAllFromLanguages(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.languages!= null){ this.languages.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getLanguages() {
    return this.languages;
  }
  public java.lang.String getLanguage(java.lang.Integer index) {
    return this.languages.get(index);
  }
  public java.lang.String getFirstLanguage() {
    return this.languages.get(0);
  }
  public java.lang.String getLastLanguage() {
    return this.languages.get(languages.size() - 1);
  }
  public java.lang.String getMatchingLanguage(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: languages) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingLanguage(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: languages) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withLanguages(java.util.List<java.lang.String> languages) {
    if (languages != null) {this.languages = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : languages){this.addToLanguages(item);}} else { this.languages = null;} return (A) this;
  }
  public A withLanguages(java.lang.String... languages) {
    if (this.languages != null) {this.languages.clear();}
    if (languages != null) {for (java.lang.String item :languages){ this.addToLanguages(item);}} return (A) this;
  }
  public java.lang.Boolean hasLanguages() {
    return languages != null && !languages.isEmpty();
  }
  public A addNewLanguage(java.lang.String arg0) {
    return (A)addToLanguages(new String(arg0));
  }
  public A addToSchemes(java.lang.Integer index,io.fabric8.camelk.v1.CamelScheme item) {
    if (this.schemes == null) {this.schemes = new java.util.ArrayList<io.fabric8.camelk.v1.CamelSchemeBuilder>();}
    io.fabric8.camelk.v1.CamelSchemeBuilder builder = new io.fabric8.camelk.v1.CamelSchemeBuilder(item);_visitables.get("schemes").add(index >= 0 ? index : _visitables.get("schemes").size(), builder);this.schemes.add(index >= 0 ? index : schemes.size(), builder); return (A)this;
  }
  public A setToSchemes(java.lang.Integer index,io.fabric8.camelk.v1.CamelScheme item) {
    if (this.schemes == null) {this.schemes = new java.util.ArrayList<io.fabric8.camelk.v1.CamelSchemeBuilder>();}
    io.fabric8.camelk.v1.CamelSchemeBuilder builder = new io.fabric8.camelk.v1.CamelSchemeBuilder(item);
    if (index < 0 || index >= _visitables.get("schemes").size()) { _visitables.get("schemes").add(builder); } else { _visitables.get("schemes").set(index, builder);}
    if (index < 0 || index >= schemes.size()) { schemes.add(builder); } else { schemes.set(index, builder);}
     return (A)this;
  }
  public A addToSchemes(io.fabric8.camelk.v1.CamelScheme... items) {
    if (this.schemes == null) {this.schemes = new java.util.ArrayList<io.fabric8.camelk.v1.CamelSchemeBuilder>();}
    for (io.fabric8.camelk.v1.CamelScheme item : items) {io.fabric8.camelk.v1.CamelSchemeBuilder builder = new io.fabric8.camelk.v1.CamelSchemeBuilder(item);_visitables.get("schemes").add(builder);this.schemes.add(builder);} return (A)this;
  }
  public A addAllToSchemes(java.util.Collection<io.fabric8.camelk.v1.CamelScheme> items) {
    if (this.schemes == null) {this.schemes = new java.util.ArrayList<io.fabric8.camelk.v1.CamelSchemeBuilder>();}
    for (io.fabric8.camelk.v1.CamelScheme item : items) {io.fabric8.camelk.v1.CamelSchemeBuilder builder = new io.fabric8.camelk.v1.CamelSchemeBuilder(item);_visitables.get("schemes").add(builder);this.schemes.add(builder);} return (A)this;
  }
  public A removeFromSchemes(io.fabric8.camelk.v1.CamelScheme... items) {
    for (io.fabric8.camelk.v1.CamelScheme item : items) {io.fabric8.camelk.v1.CamelSchemeBuilder builder = new io.fabric8.camelk.v1.CamelSchemeBuilder(item);_visitables.get("schemes").remove(builder);if (this.schemes != null) {this.schemes.remove(builder);}} return (A)this;
  }
  public A removeAllFromSchemes(java.util.Collection<io.fabric8.camelk.v1.CamelScheme> items) {
    for (io.fabric8.camelk.v1.CamelScheme item : items) {io.fabric8.camelk.v1.CamelSchemeBuilder builder = new io.fabric8.camelk.v1.CamelSchemeBuilder(item);_visitables.get("schemes").remove(builder);if (this.schemes != null) {this.schemes.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSchemes(java.util.function.Predicate<io.fabric8.camelk.v1.CamelSchemeBuilder> predicate) {
    if (schemes == null) return (A) this;
    final Iterator<io.fabric8.camelk.v1.CamelSchemeBuilder> each = schemes.iterator();
    final List visitables = _visitables.get("schemes");
    while (each.hasNext()) {
      io.fabric8.camelk.v1.CamelSchemeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSchemes instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.camelk.v1.CamelScheme> getSchemes() {
    return build(schemes);
  }
  public java.util.List<io.fabric8.camelk.v1.CamelScheme> buildSchemes() {
    return build(schemes);
  }
  public io.fabric8.camelk.v1.CamelScheme buildScheme(java.lang.Integer index) {
    return this.schemes.get(index).build();
  }
  public io.fabric8.camelk.v1.CamelScheme buildFirstScheme() {
    return this.schemes.get(0).build();
  }
  public io.fabric8.camelk.v1.CamelScheme buildLastScheme() {
    return this.schemes.get(schemes.size() - 1).build();
  }
  public io.fabric8.camelk.v1.CamelScheme buildMatchingScheme(java.util.function.Predicate<io.fabric8.camelk.v1.CamelSchemeBuilder> predicate) {
    for (io.fabric8.camelk.v1.CamelSchemeBuilder item: schemes) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingScheme(java.util.function.Predicate<io.fabric8.camelk.v1.CamelSchemeBuilder> predicate) {
    for (io.fabric8.camelk.v1.CamelSchemeBuilder item: schemes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSchemes(java.util.List<io.fabric8.camelk.v1.CamelScheme> schemes) {
    if (this.schemes != null) { _visitables.get("schemes").removeAll(this.schemes);}
    if (schemes != null) {this.schemes = new java.util.ArrayList<io.fabric8.camelk.v1.CamelSchemeBuilder>(); for (io.fabric8.camelk.v1.CamelScheme item : schemes){this.addToSchemes(item);}} else { this.schemes = null;} return (A) this;
  }
  public A withSchemes(io.fabric8.camelk.v1.CamelScheme... schemes) {
    if (this.schemes != null) {this.schemes.clear();}
    if (schemes != null) {for (io.fabric8.camelk.v1.CamelScheme item :schemes){ this.addToSchemes(item);}} return (A) this;
  }
  public java.lang.Boolean hasSchemes() {
    return schemes != null && !schemes.isEmpty();
  }
  public io.fabric8.camelk.v1.CamelArtifactFluent.SchemesNested<A> addNewScheme() {
    return new io.fabric8.camelk.v1.CamelArtifactFluentImpl.SchemesNestedImpl();
  }
  public io.fabric8.camelk.v1.CamelArtifactFluent.SchemesNested<A> addNewSchemeLike(io.fabric8.camelk.v1.CamelScheme item) {
    return new io.fabric8.camelk.v1.CamelArtifactFluentImpl.SchemesNestedImpl(-1, item);
  }
  public io.fabric8.camelk.v1.CamelArtifactFluent.SchemesNested<A> setNewSchemeLike(java.lang.Integer index,io.fabric8.camelk.v1.CamelScheme item) {
    return new io.fabric8.camelk.v1.CamelArtifactFluentImpl.SchemesNestedImpl(index, item);
  }
  public io.fabric8.camelk.v1.CamelArtifactFluent.SchemesNested<A> editScheme(java.lang.Integer index) {
    if (schemes.size() <= index) throw new RuntimeException("Can't edit schemes. Index exceeds size.");
    return setNewSchemeLike(index, buildScheme(index));
  }
  public io.fabric8.camelk.v1.CamelArtifactFluent.SchemesNested<A> editFirstScheme() {
    if (schemes.size() == 0) throw new RuntimeException("Can't edit first schemes. The list is empty.");
    return setNewSchemeLike(0, buildScheme(0));
  }
  public io.fabric8.camelk.v1.CamelArtifactFluent.SchemesNested<A> editLastScheme() {
    int index = schemes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last schemes. The list is empty.");
    return setNewSchemeLike(index, buildScheme(index));
  }
  public io.fabric8.camelk.v1.CamelArtifactFluent.SchemesNested<A> editMatchingScheme(java.util.function.Predicate<io.fabric8.camelk.v1.CamelSchemeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<schemes.size();i++) { 
    if (predicate.test(schemes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching schemes. No match found.");
    return setNewSchemeLike(index, buildScheme(index));
  }
  public java.lang.String getVersion() {
    return this.version;
  }
  public A withVersion(java.lang.String version) {
    this.version=version; return (A) this;
  }
  public java.lang.Boolean hasVersion() {
    return this.version != null;
  }
  
  /**
   * Method is deprecated. use withVersion instead.
   */
  @java.lang.Deprecated
  public A withNewVersion(java.lang.String arg0) {
    return (A)withVersion(new String(arg0));
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CamelArtifactFluentImpl that = (CamelArtifactFluentImpl) o;
    if (artifactId != null ? !artifactId.equals(that.artifactId) :that.artifactId != null) return false;
    if (dataformats != null ? !dataformats.equals(that.dataformats) :that.dataformats != null) return false;
    if (dependencies != null ? !dependencies.equals(that.dependencies) :that.dependencies != null) return false;
    if (exclusions != null ? !exclusions.equals(that.exclusions) :that.exclusions != null) return false;
    if (groupId != null ? !groupId.equals(that.groupId) :that.groupId != null) return false;
    if (javaTypes != null ? !javaTypes.equals(that.javaTypes) :that.javaTypes != null) return false;
    if (languages != null ? !languages.equals(that.languages) :that.languages != null) return false;
    if (schemes != null ? !schemes.equals(that.schemes) :that.schemes != null) return false;
    if (version != null ? !version.equals(that.version) :that.version != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(artifactId,  dataformats,  dependencies,  exclusions,  groupId,  javaTypes,  languages,  schemes,  version,  super.hashCode());
  }
  public class DependenciesNestedImpl<N> extends io.fabric8.camelk.v1.CamelArtifactDependencyFluentImpl<io.fabric8.camelk.v1.CamelArtifactFluent.DependenciesNested<N>> implements io.fabric8.camelk.v1.CamelArtifactFluent.DependenciesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    DependenciesNestedImpl(java.lang.Integer index,io.fabric8.camelk.v1.CamelArtifactDependency item) {
      this.index = index;
      this.builder = new io.fabric8.camelk.v1.CamelArtifactDependencyBuilder(this, item);
    }
    DependenciesNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.camelk.v1.CamelArtifactDependencyBuilder(this);
    }
    io.fabric8.camelk.v1.CamelArtifactDependencyBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) CamelArtifactFluentImpl.this.setToDependencies(index,builder.build());
    }
    public N endDependency() {
      return and();
    }
    
  }
  public class ExclusionsNestedImpl<N> extends io.fabric8.camelk.v1.CamelArtifactExclusionFluentImpl<io.fabric8.camelk.v1.CamelArtifactFluent.ExclusionsNested<N>> implements io.fabric8.camelk.v1.CamelArtifactFluent.ExclusionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ExclusionsNestedImpl(java.lang.Integer index,io.fabric8.camelk.v1.CamelArtifactExclusion item) {
      this.index = index;
      this.builder = new io.fabric8.camelk.v1.CamelArtifactExclusionBuilder(this, item);
    }
    ExclusionsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.camelk.v1.CamelArtifactExclusionBuilder(this);
    }
    io.fabric8.camelk.v1.CamelArtifactExclusionBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) CamelArtifactFluentImpl.this.setToExclusions(index,builder.build());
    }
    public N endExclusion() {
      return and();
    }
    
  }
  public class SchemesNestedImpl<N> extends io.fabric8.camelk.v1.CamelSchemeFluentImpl<io.fabric8.camelk.v1.CamelArtifactFluent.SchemesNested<N>> implements io.fabric8.camelk.v1.CamelArtifactFluent.SchemesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    SchemesNestedImpl(java.lang.Integer index,io.fabric8.camelk.v1.CamelScheme item) {
      this.index = index;
      this.builder = new io.fabric8.camelk.v1.CamelSchemeBuilder(this, item);
    }
    SchemesNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.camelk.v1.CamelSchemeBuilder(this);
    }
    io.fabric8.camelk.v1.CamelSchemeBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) CamelArtifactFluentImpl.this.setToSchemes(index,builder.build());
    }
    public N endScheme() {
      return and();
    }
    
  }
  
}