/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.arquillian.utils;

import io.fabric8.arquillian.kubernetes.Session;
import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.utils.MultiException;
import io.fabric8.utils.Zips;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.PomEquippedResolveStage;

public class Util {
    public static String readAsString(URL url) {
        StringBuilder response = new StringBuilder();
        try (InputStreamReader isr = new InputStreamReader(url.openStream());
             BufferedReader br = new BufferedReader(isr);){
            String line;
            while ((line = br.readLine()) != null) {
                response.append(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return response.toString();
    }

    public static void displaySessionStatus(KubernetesClient client, Session session) throws MultiException {
        for (ReplicationController replicationController : client.getReplicationControllers(session.getNamespace()).getItems()) {
            session.getLogger().info("Replication controller:" + KubernetesHelper.getId((ReplicationController)replicationController));
        }
        for (Pod pod : client.getPods(session.getNamespace()).getItems()) {
            session.getLogger().info("Pod:" + KubernetesHelper.getId((Pod)pod) + " Status:" + pod.getCurrentState().getStatus());
        }
        for (Service service : client.getServices(session.getNamespace()).getItems()) {
            session.getLogger().info("Service:" + KubernetesHelper.getId((Service)service) + " IP:" + KubernetesHelper.getPortalIP((Service)service) + " Port:" + KubernetesHelper.getPort((Service)service));
        }
    }

    public static void cleanupSession(KubernetesClient client, Session session) throws MultiException {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        Util.cleanupAllMatching(client, session, errors);
        if (!errors.isEmpty()) {
            throw new MultiException("Error while cleaning up session.", errors);
        }
    }

    public static void cleanupAllMatching(KubernetesClient client, Session session, List<Throwable> errors) throws MultiException {
        for (int i = 0; i < 10; ++i) {
            try {
                Util.deleteReplicationControllers(client, session);
            }
            catch (MultiException e) {
                errors.addAll(Arrays.asList(e.getCauses()));
            }
            try {
                Util.deletePods(client, session);
            }
            catch (MultiException e) {
                errors.addAll(Arrays.asList(e.getCauses()));
            }
            try {
                Util.deleteServices(client, session);
            }
            catch (MultiException e) {
                errors.addAll(Arrays.asList(e.getCauses()));
            }
            List filteredPods = client.getPods(session.getNamespace()).getItems();
            if (filteredPods.isEmpty()) {
                return;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static void deletePods(KubernetesClient client, Session session) throws MultiException {
        ArrayList<Exception> errors = new ArrayList<Exception>();
        for (Pod pod : client.getPods(session.getNamespace()).getItems()) {
            try {
                session.getLogger().info("Deleting pod:" + KubernetesHelper.getId((Pod)pod));
                client.deletePod(pod.getId(), session.getNamespace());
            }
            catch (Exception e) {
                errors.add(e);
            }
        }
        if (!errors.isEmpty()) {
            throw new MultiException("Error while deleting pods", errors);
        }
    }

    public static void deleteServices(KubernetesClient client, Session session) throws MultiException {
        ArrayList errors = new ArrayList();
        for (Service service : client.getServices(session.getNamespace()).getItems()) {
            try {
                session.getLogger().info("Deleting service:" + KubernetesHelper.getId((Service)service));
                client.deleteService(service.getId(), session.getNamespace());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!errors.isEmpty()) {
            throw new MultiException("Error while deleting services", errors);
        }
    }

    public static void deleteReplicationControllers(KubernetesClient client, Session session) throws MultiException {
        ArrayList errors = new ArrayList();
        for (ReplicationController replicationController : client.getReplicationControllers(session.getNamespace()).getItems()) {
            try {
                session.getLogger().info("Deleting replication controller:" + KubernetesHelper.getId((ReplicationController)replicationController));
                client.deleteReplicationController(replicationController.getId(), session.getNamespace());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!errors.isEmpty()) {
            throw new MultiException("Error while deleting replication controllers", errors);
        }
    }

    public static List<String> getMavenDependencies(Session session) throws IOException {
        ArrayList<String> dependencies = new ArrayList<String>();
        try {
            File[] files;
            for (File f : files = ((MavenFormatStage)((MavenStrategyStage)((PomEquippedResolveStage)((PomEquippedResolveStage)Maven.resolver().loadPomFromFile("pom.xml")).importTestDependencies()).resolve()).withoutTransitivity()).asFile()) {
                if (f.getName().endsWith("jar") && Util.hasKubernetesJson(f)) {
                    Path dir = Files.createTempDirectory(session.getId(), new FileAttribute[0]);
                    try (FileInputStream fis = new FileInputStream(f);
                         JarInputStream jis = new JarInputStream(fis);){
                        Zips.unzip((InputStream)new FileInputStream(f), (File)dir.toFile());
                        File jsonPath = dir.resolve("kubernetes.json").toFile();
                        if (!jsonPath.exists()) continue;
                        dependencies.add(jsonPath.toURI().toString());
                        continue;
                    }
                }
                if (!f.getName().endsWith(".json")) continue;
                dependencies.add(f.toURI().toString());
            }
        }
        catch (Exception e) {
            session.getLogger().warn("Skipping maven project dependencies. Caused by:" + e.getMessage());
        }
        return dependencies;
    }

    private static boolean hasKubernetesJson(File f) throws IOException {
        try (FileInputStream fis = new FileInputStream(f);
             JarInputStream jis = new JarInputStream(fis);){
            JarEntry entry = jis.getNextJarEntry();
            while (true) {
                if (entry != null) {
                    if (entry.getName().equals("kubernetes.json")) {
                        boolean bl = true;
                        return bl;
                    }
                    entry = jis.getNextJarEntry();
                    continue;
                }
                break;
            }
        }
        return false;
    }
}

