/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.arquillian.kubernetes.await;

import io.fabric8.arquillian.kubernetes.Configuration;
import io.fabric8.arquillian.kubernetes.Session;
import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.model.Service;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public class SessionServicesAreReady
implements Callable<Boolean> {
    private final Session session;
    private final KubernetesClient kubernetesClient;
    private final Configuration configuration;

    public SessionServicesAreReady(KubernetesClient kubernetesClient, Session session, Configuration configuration) {
        this.session = session;
        this.kubernetesClient = kubernetesClient;
        this.configuration = configuration;
    }

    @Override
    public Boolean call() throws Exception {
        boolean result = true;
        List services = this.kubernetesClient.getServices(this.session.getNamespace()).getItems();
        if (services.isEmpty()) {
            result = false;
            this.session.getLogger().warn("No services are available yet, waiting...");
        } else if (this.configuration.isWaitForServiceConnection()) {
            for (Service s : this.filterServices(services, this.configuration.getWaitForServices())) {
                if (this.isEndpointAvailable(s)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean isEndpointAvailable(Service s) {
        String serviceStatus = null;
        boolean result = false;
        for (String endpoit : this.kubernetesClient.endpointsForService(s.getId(), s.getNamespace()).getEndpoints()) {
            boolean bl;
            Throwable throwable;
            Socket socket;
            block17: {
                block18: {
                    String addr = endpoit.substring(0, endpoit.indexOf(":"));
                    Integer port = Integer.parseInt(endpoit.substring(endpoit.indexOf(":") + 1));
                    socket = new Socket();
                    throwable = null;
                    socket.connect(new InetSocketAddress(addr, (int)port), this.configuration.getServiceConnectionTimeout());
                    serviceStatus = "Service: " + s.getId() + " is ready. Provider:" + addr + ".";
                    bl = true;
                    if (socket == null) break block17;
                    if (throwable == null) break block18;
                    try {
                        socket.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    break block17;
                }
                socket.close();
            }
            this.session.getLogger().warn(serviceStatus);
            return bl;
            catch (Throwable throwable2) {
                try {
                    try {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (socket != null) {
                                if (throwable != null) {
                                    try {
                                        socket.close();
                                    }
                                    catch (Throwable x2) {
                                        throwable.addSuppressed(x2);
                                    }
                                } else {
                                    socket.close();
                                }
                            }
                            throw throwable3;
                        }
                    }
                    catch (Exception e) {
                        serviceStatus = "Service: " + s.getId() + " is not ready! Error: " + e.getMessage();
                        this.session.getLogger().warn(serviceStatus);
                    }
                }
                catch (Throwable throwable4) {
                    this.session.getLogger().warn(serviceStatus);
                    throw throwable4;
                }
            }
        }
        return result;
    }

    private List<Service> filterServices(List<Service> services, List<String> selectedIds) {
        if (selectedIds != null && !selectedIds.isEmpty()) {
            ArrayList<Service> result = new ArrayList<Service>();
            for (Service s : services) {
                if (!selectedIds.contains(s.getId())) continue;
                result.add(s);
            }
            return result;
        }
        return services;
    }
}

