/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.arquillian.kubernetes.await;

import io.fabric8.arquillian.kubernetes.Session;
import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.PodStatus;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.utils.Objects;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class SessionPodsAreReady
implements Callable<Boolean> {
    private final Session session;
    private final KubernetesClient kubernetesClient;

    public SessionPodsAreReady(KubernetesClient kubernetesClient, Session session) {
        this.session = session;
        this.kubernetesClient = kubernetesClient;
    }

    @Override
    public Boolean call() throws Exception {
        boolean result = true;
        List pods = this.kubernetesClient.getPods(this.session.getNamespace()).getItems();
        if (pods.isEmpty()) {
            result = false;
            this.session.getLogger().warn("No pods are available yet, waiting...");
        }
        for (Pod pod : pods) {
            if ((result = result && Objects.equal((Object)PodStatus.OK, (Object)KubernetesHelper.getPodStatus((Pod)pod))) || pod.getCurrentState().getInfo() == null) continue;
            for (Map.Entry entry : pod.getCurrentState().getInfo().entrySet()) {
                String containerId = (String)entry.getKey();
                ContainerStatus status = (ContainerStatus)entry.getValue();
                if (status.getState().getWaiting() == null) continue;
                this.session.getLogger().warn("Waiting for container:" + containerId + ". Reason:" + status.getState().getWaiting().getReason());
            }
        }
        return result;
    }
}

