/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tooling.archetype.commands;

import io.fabric8.boot.commands.support.AbstractCommandComponent;
import io.fabric8.tooling.archetype.ArchetypeService;
import io.fabric8.tooling.archetype.commands.ListArchetypesAction;
import io.fabric8.tooling.archetype.commands.support.ArchetypeCompleter;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.basic.AbstractCommand;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.felix.service.command.Function;

@Component(immediate=true)
@Service(value={Function.class, AbstractCommand.class})
@Properties(value={@Property(name="osgi.command.scope", value={"fabric"}), @Property(name="osgi.command.function", value={"list-archetypes"})})
public class ListArchetypes
extends AbstractCommandComponent {
    public static final String SCOPE_VALUE = "fabric";
    public static final String FUNCTION_VALUE = "list-archetypes";
    public static final String DESCRIPTION = "Displays available archetypes (soon the list will be configurable)";
    @Reference(referenceInterface=ArchetypeService.class, bind="bindArchetypeService", unbind="unbindArchetypeService")
    private ArchetypeService archetypeService;

    public Action createNewAction() {
        this.assertValid();
        return new ListArchetypesAction(this.archetypeService.listArchetypeGAVs());
    }

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    void bindArchetypeCompleter(ArchetypeCompleter completer) {
        this.bindCompleter(completer);
    }

    void unbindArchetypeCompleter(ArchetypeCompleter completer) {
        this.unbindCompleter(completer);
    }

    public void bindArchetypeService(ArchetypeService archetypeService) {
        this.archetypeService = archetypeService;
    }

    public void unbindArchetypeService(ArchetypeService archetypeService) {
        this.archetypeService = null;
    }
}

