/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tooling.archetype.commands;

import io.fabric8.agent.download.DownloadFuture;
import io.fabric8.agent.download.DownloadManager;
import io.fabric8.agent.download.FutureListener;
import io.fabric8.agent.mvn.MavenConfiguration;
import io.fabric8.agent.mvn.MavenConfigurationImpl;
import io.fabric8.agent.mvn.MavenSettings;
import io.fabric8.agent.mvn.MavenSettingsImpl;
import io.fabric8.agent.mvn.PropertiesPropertyResolver;
import io.fabric8.agent.mvn.PropertyResolver;
import io.fabric8.tooling.archetype.ArchetypeService;
import io.fabric8.tooling.archetype.catalog.Archetype;
import io.fabric8.tooling.archetype.generator.ArchetypeHelper;
import io.fabric8.utils.shell.ShellUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="archetype-info", scope="fabric", description="Creates Maven project from Maven Archetype")
public class ArchetypeCreateAction
extends AbstractAction {
    @Argument(index=0, name="archetype", description="Archetype coordinates", required=true, multiValued=false)
    private String archetypeGAV;
    @Argument(index=1, name="target", description="Target directory where the project will be generated", required=true, multiValued=false)
    private File target;
    private final ArchetypeService archetypeService;

    public ArchetypeCreateAction(ArchetypeService archetypeService) {
        this.archetypeService = archetypeService;
    }

    protected Object doExecute() throws Exception {
        Archetype archetype = this.archetypeService.getArchetype(this.archetypeGAV);
        if (archetype != null) {
            System.out.println(String.format("Generating %s:%s in %s", archetype.groupId, archetype.artifactId, this.target.getCanonicalPath()));
            InputStream archetypeInputStream = this.fetchArchetype(archetype);
            if (archetypeInputStream == null) {
                System.err.println("No archetype found for \"" + this.archetypeGAV + "\" coordinates");
                return null;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)archetypeInputStream, (OutputStream)baos);
            IOUtils.closeQuietly((InputStream)archetypeInputStream);
            ByteArrayInputStream stream = new ByteArrayInputStream(baos.toByteArray());
            String defaultGroupId = "io.fabric8";
            String defaultArtifactId = archetype.artifactId + "-example";
            String defaultVersion = "1.0-SNAPSHOT";
            System.out.println("----- Configure archetype -----");
            String groupId = ShellUtils.readLine(this.session, String.format("Define value for property 'groupId' (%s):", defaultGroupId), false);
            String artifactId = ShellUtils.readLine(this.session, String.format("Define value for property 'artifactId' (%s):", defaultArtifactId), false);
            String version = ShellUtils.readLine(this.session, String.format("Define value for property 'version' (%s):", defaultVersion), false);
            groupId = groupId == null || groupId.trim().equals("") ? defaultGroupId : groupId;
            artifactId = artifactId == null || artifactId.trim().equals("") ? defaultArtifactId : artifactId;
            version = version == null || version.trim().equals("") ? defaultVersion : version;
            String defaultPackageName = (groupId + "." + artifactId).replaceAll("-", ".");
            String packageName = ShellUtils.readLine(this.session, String.format("Define value for property 'package' (%s):", defaultPackageName), false);
            packageName = packageName == null || packageName.trim().equals("") ? defaultPackageName : packageName;
            ArchetypeHelper helper = new ArchetypeHelper((InputStream)stream, this.target, groupId, artifactId, version);
            helper.setPackageName(packageName);
            Map properties = helper.parseProperties();
            if (!properties.isEmpty()) {
                System.out.println("----- Configure additional properties -----");
                for (String key : properties.keySet()) {
                    String p = ShellUtils.readLine(this.session, String.format("Define value for property '%s' (%s):", key, properties.get(key)), false);
                    p = p == null || p.trim().equals("") ? (String)properties.get(key) : p;
                    properties.put(key, p);
                }
            }
            helper.setOverrideProperties(properties);
            ((InputStream)stream).reset();
            helper.execute();
        } else {
            System.err.println("No archetype found for \"" + this.archetypeGAV + "\" coordinates");
        }
        return null;
    }

    private InputStream fetchArchetype(Archetype archetype) throws IOException {
        MavenConfigurationImpl config = new MavenConfigurationImpl((PropertyResolver)new PropertiesPropertyResolver(System.getProperties()), "org.ops4j.pax.url.mvn");
        config.setSettings((MavenSettings)new MavenSettingsImpl(config.getSettingsFileUrl(), config.useFallbackRepositories().booleanValue()));
        DownloadManager dm = new DownloadManager((MavenConfiguration)config, Executors.newSingleThreadExecutor());
        final CountDownLatch latch = new CountDownLatch(1);
        DownloadFuture df = dm.download(String.format("mvn:%s/%s/%s", archetype.groupId, archetype.artifactId, archetype.version));
        df.addListener((FutureListener)new FutureListener<DownloadFuture>(){

            public void operationComplete(DownloadFuture future) {
                latch.countDown();
            }
        });
        try {
            latch.await(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            System.err.println("Failed to download " + archetype);
            throw new IOException(e.getMessage(), e);
        }
        System.out.println("Downloaded archetype (" + df.getFile() + ")");
        return new FileInputStream(df.getFile());
    }
}

