/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tooling.archetype.commands;

import io.fabric8.tooling.archetype.ArchetypeService;
import io.fabric8.tooling.archetype.catalog.Archetype;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="archetype-info", scope="fabric", description="Displays information about archetypes")
public class ArchetypeInfoAction
extends AbstractAction {
    @Argument(index=0, name="archetype", description="Archetype coordinates", required=true, multiValued=false)
    private String archetypeGAV;
    private final ArchetypeService archetypeService;

    public ArchetypeInfoAction(ArchetypeService archetypeService) {
        this.archetypeService = archetypeService;
    }

    protected Object doExecute() throws Exception {
        Archetype archetype = this.archetypeService.getArchetype(this.archetypeGAV);
        if (archetype != null) {
            System.out.println(String.format("Archetype coordinates: %s:%s:%s", archetype.groupId, archetype.artifactId, archetype.version));
            System.out.println();
            System.out.println(String.format("Description: %s", archetype.description));
            System.out.println(String.format("Repository: %s", archetype.repository));
        } else {
            System.err.println("No archetype found for \"" + this.archetypeGAV + "\" coordinates");
        }
        return null;
    }
}

