/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tooling.archetype;

import io.fabric8.utils.Files;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ArchetypeUtils {
    public static Logger LOG = LoggerFactory.getLogger(ArchetypeUtils.class);
    public static final String[] sourceCodeDirNames = new String[]{"java", "groovy", "kotlin", "scala"};
    private static final Set<String> excludeExtensions = new HashSet<String>(Arrays.asList("iml", "iws", "ipr"));
    private static final Set<String> sourceCodeDirPaths = new HashSet<String>();
    private DocumentBuilder documentBuilder;
    private TransformerFactory transformerFactory;

    public ArchetypeUtils() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            this.documentBuilder = dbf.newDocumentBuilder();
            this.transformerFactory = TransformerFactory.newInstance();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String relativePath(File base, File nested) throws IOException {
        String basePath = base.getCanonicalPath();
        String nestedPath = nested.getCanonicalPath();
        if (nestedPath.equals(basePath)) {
            return "";
        }
        if (nestedPath.startsWith(basePath)) {
            return nestedPath.substring(basePath.length() + 1);
        }
        return nestedPath;
    }

    public File findRootPackage(File directory) throws IOException {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("Can't find package inside file. Argument should be valid directory.");
        }
        File[] children = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return ArchetypeUtils.this.isValidSourceFileOrDir(pathname);
            }
        });
        if (children != null) {
            LinkedList<File> results = new LinkedList<File>();
            for (File it : children) {
                if (!it.isDirectory()) {
                    results.add(directory);
                    break;
                }
                File pkg = this.findRootPackage(it);
                if (pkg == null) continue;
                results.add(pkg);
            }
            if (results.size() == 1) {
                return (File)results.get(0);
            }
            return directory;
        }
        return null;
    }

    public boolean isValidSourceFileOrDir(File file) {
        String name = file.getName();
        return !name.startsWith(".") && !excludeExtensions.contains(Files.getExtension((String)file.getName()));
    }

    public boolean isValidFileToCopy(File projectDir, File src) throws IOException {
        if (this.isValidSourceFileOrDir(src)) {
            if (src.equals(projectDir)) {
                return true;
            }
            String relative = this.relativePath(projectDir, src);
            return !sourceCodeDirPaths.contains(relative);
        }
        return false;
    }

    public boolean isValidProjectPom(File pom) {
        Document doc = null;
        try {
            doc = this.parseXml(new InputSource(new FileReader(pom)));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        Element root = doc.getDocumentElement();
        String packaging = this.firstElementText(root, "packaging", "");
        return packaging == null || !packaging.equals("pom");
    }

    public Document parseXml(InputSource inputSource) {
        try {
            return this.documentBuilder.parse(inputSource);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void writeXmlDocument(Document document, File file) throws IOException {
        try {
            Transformer tr = this.transformerFactory.newTransformer();
            tr.setOutputProperty("encoding", "UTF-8");
            tr.setOutputProperty("indent", "yes");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            tr.transform(new DOMSource(document), new StreamResult(fileOutputStream));
            fileOutputStream.close();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public String writeXmlDocumentAsString(Document document) throws IOException {
        try {
            Transformer tr = this.transformerFactory.newTransformer();
            tr.setOutputProperty("encoding", "UTF-8");
            tr.setOutputProperty("indent", "yes");
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            tr.transform(new DOMSource(document), result);
            return writer.toString();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public String firstElementText(Element root, String elementName, String defaultValue) {
        String answer = null;
        NodeList children = root.getChildNodes();
        for (int cn = 0; cn < children.getLength(); ++cn) {
            if (!elementName.equals(children.item(cn).getNodeName())) continue;
            answer = children.item(cn).getTextContent();
            break;
        }
        if (answer == null) {
            children = root.getElementsByTagName(elementName);
            if (children.getLength() == 0) {
                answer = defaultValue;
            } else {
                Node first = children.item(0);
                answer = first.getTextContent();
            }
        }
        return answer == null ? defaultValue : answer;
    }

    public static void writeGitIgnore(File gitIgnore) {
        ArchetypeUtils.writeFile(gitIgnore, "src\n", false);
    }

    public static void writeFile(File file, String data, boolean append) {
        try {
            FileOutputStream fos = new FileOutputStream(file, append);
            fos.write(data.getBytes());
            fos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isEmpty(String s) {
        if (s == null) {
            return true;
        }
        return (s = s.trim()).length() == 0;
    }

    static {
        for (String scdn : sourceCodeDirNames) {
            sourceCodeDirPaths.add(Files.normalizePath((String)("src/main/" + scdn)));
            sourceCodeDirPaths.add(Files.normalizePath((String)("src/test/" + scdn)));
        }
        sourceCodeDirPaths.addAll(Arrays.asList("target", "build", "pom.xml", "archetype-metadata.xml"));
    }
}

