/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tooling.archetype.builder;

import io.fabric8.tooling.archetype.ArchetypeUtils;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class ArchetypeBuilder {
    public static Logger LOG = LoggerFactory.getLogger(ArchetypeBuilder.class);
    private static final Set<String> sourceFileExtensions = new HashSet<String>(Arrays.asList("bpmn", "csv", "drl", "html", "groovy", "jade", "java", "jbpm", "js", "json", "jsp", "kotlin", "ks", "md", "properties", "scala", "ssp", "ts", "txt", "xml"));
    private ArchetypeUtils archetypeUtils = new ArchetypeUtils();
    private File bomFile;
    private File catalogXmlFile;
    private PrintWriter printWriter;
    private final Map<String, String> versionProperties = new HashMap<String, String>();
    private int indentSize = 2;
    private String indent = "  ";

    public ArchetypeBuilder(File catalogXmlFile) {
        this.catalogXmlFile = catalogXmlFile;
    }

    public void setIndentSize(int indentSize) {
        this.indentSize = Math.min(indentSize <= 0 ? 0 : indentSize, 8);
        this.indent = "";
        for (int c = 0; c < this.indentSize; ++c) {
            this.indent = this.indent + " ";
        }
    }

    public void setBomFile(File bomFile) {
        this.bomFile = bomFile;
    }

    public void configure() throws IOException {
        this.catalogXmlFile.getParentFile().mkdirs();
        LOG.info("Writing catalog: " + this.catalogXmlFile);
        this.printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.catalogXmlFile), "UTF-8"));
        this.printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<archetype-catalog xmlns=\"http://maven.apache.org/plugins/maven-archetype-plugin/archetype-catalog/1.0.0\"\n" + this.indent + this.indent + "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n" + this.indent + this.indent + "xsi:schemaLocation=\"http://maven.apache.org/plugins/maven-archetype-plugin/archetype-catalog/1.0.0 http://maven.apache.org/xsd/archetype-catalog-1.0.0.xsd\">\n" + this.indent + "<archetypes>");
        if (this.bomFile != null && this.bomFile.exists()) {
            String text = FileUtils.readFileToString((File)this.bomFile);
            Document doc = this.archetypeUtils.parseXml(new InputSource(new StringReader(text)));
            Element root = doc.getDocumentElement();
            NodeList propertyElements = root.getElementsByTagName("properties");
            if (propertyElements.getLength() > 0) {
                Element propertyElement = (Element)propertyElements.item(0);
                NodeList children = propertyElement.getChildNodes();
                for (int cn = 0; cn < children.getLength(); ++cn) {
                    Node e = children.item(cn);
                    if (!(e instanceof Element)) continue;
                    this.versionProperties.put(e.getNodeName(), e.getTextContent());
                }
            }
            if (LOG.isDebugEnabled()) {
                for (Map.Entry<String, String> entry : this.versionProperties.entrySet()) {
                    LOG.debug("bom property: {}={}", (Object)entry.getKey(), (Object)entry.getValue());
                }
            }
        }
    }

    public void close() {
        this.printWriter.println(this.indent + "</archetypes>\n" + "</archetype-catalog>");
        this.printWriter.close();
    }

    public void generateArchetypes(String containerType, File baseDir, File outputDir, boolean clean, List<String> dirs) throws IOException {
        LOG.debug("Generating archetypes from {} to {}", (Object)baseDir.getCanonicalPath(), (Object)outputDir.getCanonicalPath());
        File[] files = baseDir.listFiles();
        if (files != null) {
            for (File file : files) {
                File projectDir;
                File projectPom;
                if (!file.isDirectory() || !(projectPom = new File(projectDir = file, "pom.xml")).exists() || ArchetypeBuilder.skipImport(projectDir)) continue;
                if (this.archetypeUtils.isValidProjectPom(projectPom)) {
                    String archetypeDirName;
                    String fileName = file.getName();
                    if (fileName.equals(archetypeDirName = fileName.replace("example", "archetype"))) {
                        archetypeDirName = archetypeDirName + "-archetype";
                    }
                    archetypeDirName = containerType + "-" + archetypeDirName;
                    File archetypeDir = new File(outputDir, archetypeDirName);
                    this.generateArchetype(projectDir, projectPom, archetypeDir, clean, dirs);
                    File archetypePom = new File(archetypeDir, "pom.xml");
                    if (!archetypePom.exists()) continue;
                    this.addArchetypeMetaData(archetypePom, archetypeDirName);
                    continue;
                }
                String childContainerType = file.getName();
                if (Strings.isNotBlank((String)containerType)) {
                    childContainerType = containerType + "-" + childContainerType;
                }
                this.generateArchetypes(childContainerType, file, outputDir, clean, dirs);
            }
        }
    }

    private static boolean skipImport(File dir) {
        String[] files = dir.list();
        if (files != null) {
            for (String name : files) {
                if (!".skipimport".equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    private void generateArchetype(File projectDir, File projectPom, File archetypeDir, boolean clean, List<String> dirs) throws IOException {
        File rootPackage;
        File rootPackage2;
        LOG.debug("Generating archetype from {} to {}", (Object)projectDir.getName(), (Object)archetypeDir.getCanonicalPath());
        dirs.add(archetypeDir.getName());
        File srcDir = new File(projectDir, "src/main");
        File testDir = new File(projectDir, "src/test");
        File outputSrcDir = new File(archetypeDir, "src");
        File outputGitIgnoreFile = new File(archetypeDir, ".gitignore");
        if (clean) {
            LOG.debug("Removing generated archetype dir {}", (Object)archetypeDir);
            FileUtils.deleteDirectory((File)archetypeDir);
        } else if (outputSrcDir.exists() && outputGitIgnoreFile.exists() && this.fileIncludesLine(outputGitIgnoreFile, "src")) {
            LOG.debug("Removing generated src dir {}", (Object)outputSrcDir);
            FileUtils.deleteDirectory((File)outputSrcDir);
            if (outputSrcDir.exists()) {
                throw new RuntimeException("The projectDir " + outputSrcDir + " should not exist!");
            }
        }
        File archetypeOutputDir = new File(archetypeDir, "src/main/resources/archetype-resources");
        File metadataXmlOutFile = new File(archetypeDir, "src/main/resources-filtered/META-INF/maven/archetype-metadata.xml");
        Replacement replaceFunction = new IdentityReplacement();
        File mainSrcDir = null;
        for (String it : ArchetypeUtils.sourceCodeDirNames) {
            File dir = new File(srcDir, it);
            if (!dir.exists()) continue;
            mainSrcDir = dir;
            break;
        }
        if (mainSrcDir != null && (rootPackage2 = this.archetypeUtils.findRootPackage(mainSrcDir)) != null) {
            String packagePath = this.archetypeUtils.relativePath(mainSrcDir, rootPackage2);
            String packageName = packagePath.replace(File.separatorChar, '.');
            LOG.debug("Found root package in {}: {}", (Object)mainSrcDir, (Object)packageName);
            final String regex = packageName.replace(".", "\\.");
            replaceFunction = new Replacement(){

                @Override
                public String replace(String token) {
                    return token.replaceAll(regex, "\\${package}");
                }
            };
            File outputMainSrc = new File(archetypeOutputDir, this.archetypeUtils.relativePath(projectDir, mainSrcDir));
            this.copyCodeFiles(rootPackage2, outputMainSrc, replaceFunction);
        }
        File testSrcDir = null;
        for (String it : ArchetypeUtils.sourceCodeDirNames) {
            File dir = new File(testDir, it);
            if (!dir.exists()) continue;
            testSrcDir = dir;
            break;
        }
        if (testSrcDir != null && (rootPackage = this.archetypeUtils.findRootPackage(testSrcDir)) != null) {
            String packagePath = this.archetypeUtils.relativePath(testSrcDir, rootPackage);
            String packageName = packagePath.replace(File.separatorChar, '.');
            LOG.debug("Found root package in {}: {}", (Object)testSrcDir, (Object)packageName);
            final String regex = packageName.replace(".", "\\.");
            replaceFunction = new Replacement(){

                @Override
                public String replace(String token) {
                    return token.replaceAll(regex, "\\${package}");
                }
            };
            File rootTestDir = new File(testSrcDir, packagePath);
            File outputTestSrc = new File(archetypeOutputDir, this.archetypeUtils.relativePath(projectDir, testSrcDir));
            if (rootTestDir.exists()) {
                this.copyCodeFiles(rootTestDir, outputTestSrc, replaceFunction);
            } else {
                this.copyCodeFiles(testSrcDir, outputTestSrc, replaceFunction);
            }
        }
        this.createArchetypeDescriptors(projectPom, archetypeDir, new File(archetypeOutputDir, "pom.xml"), metadataXmlOutFile, replaceFunction);
        this.copyOtherFiles(projectDir, projectDir, archetypeOutputDir, replaceFunction);
        if (!outputGitIgnoreFile.exists()) {
            ArchetypeUtils.writeGitIgnore(outputGitIgnoreFile);
        }
    }

    private void createArchetypeDescriptors(File projectPom, File archetypeDir, File archetypePom, File metadataXmlOutFile, Replacement replaceFn) throws IOException {
        LOG.debug("Parsing " + projectPom);
        String text = replaceFn.replace(FileUtils.readFileToString((File)projectPom));
        Document doc = this.archetypeUtils.parseXml(new InputSource(new StringReader(text)));
        Element root = doc.getDocumentElement();
        Element artifactIdEl = (Element)this.findChild(root, "artifactId");
        Element nameEl = (Element)this.findChild(root, "name");
        Element descriptionEl = (Element)this.findChild(root, "description");
        String originalArtifactId = artifactIdEl != null && artifactIdEl.getTextContent() != null && artifactIdEl.getTextContent().trim().length() > 0 ? artifactIdEl.getTextContent().trim() : archetypeDir.getName();
        String originalName = nameEl != null && nameEl.getTextContent() != null && nameEl.getTextContent().trim().length() > 0 ? nameEl.getTextContent().trim() : originalArtifactId;
        String originalDescription = descriptionEl != null && descriptionEl.getTextContent() != null && descriptionEl.getTextContent().trim().length() > 0 ? descriptionEl.getTextContent().trim() : originalName;
        LinkedHashMap<String, String> propertyNameSet = new LinkedHashMap<String, String>();
        if (root != null) {
            NodeList parents = root.getElementsByTagName("parent");
            if (parents.getLength() > 0) {
                if (parents.item(0).getNextSibling().getNodeType() == 3) {
                    root.removeChild(parents.item(0).getNextSibling());
                }
                root.removeChild(parents.item(0));
            }
            LinkedHashMap<String, String> pomProperties = new LinkedHashMap<String, String>();
            NodeList propertyElements = root.getElementsByTagName("properties");
            if (propertyElements.getLength() > 0) {
                Element propertyElement = (Element)propertyElements.item(0);
                NodeList children = propertyElement.getChildNodes();
                for (int cn = 0; cn < children.getLength(); ++cn) {
                    Node e = children.item(cn);
                    if (!(e instanceof Element)) continue;
                    pomProperties.put(e.getNodeName(), e.getTextContent());
                }
            }
            if (LOG.isDebugEnabled()) {
                for (Map.Entry entry : pomProperties.entrySet()) {
                    LOG.debug("pom property: {}={}", entry.getKey(), entry.getValue());
                }
            }
            NodeList children = root.getElementsByTagName("*");
            for (int cn = 0; cn < children.getLength(); ++cn) {
                String name;
                int offset;
                int idx;
                String prefix;
                String cText;
                Node e = children.item(cn);
                if (!(e instanceof Element) || !(cText = e.getTextContent()).startsWith(prefix = "${") || (idx = cText.indexOf("}", (offset = prefix.length()) + 1)) <= 0 || pomProperties.containsKey(name = cText.substring(offset, idx)) || !this.isValidRequiredPropertyName(name)) continue;
                String value = (String)pomProperties.get(name);
                if (value == null) {
                    value = this.versionProperties.get(name);
                }
                propertyNameSet.put(name, value);
            }
            String profile = this.replaceNodeValue(doc, root, "fabric8.profile", "${fabric8-profile}");
            if (profile != null) {
                propertyNameSet.put("fabric8-profile", null);
            }
            List<String> beforeNames = Arrays.asList("artifactId", "version", "packaging", "name", "properties", "fabric8-profile");
            this.replaceOrAddElementText(doc, root, "version", "${version}", beforeNames);
            this.replaceOrAddElementText(doc, root, "artifactId", "${artifactId}", beforeNames);
            this.replaceOrAddElementText(doc, root, "groupId", "${groupId}", beforeNames);
        }
        archetypePom.getParentFile().mkdirs();
        this.removeCommentNodes(doc);
        this.archetypeUtils.writeXmlDocument(doc, archetypePom);
        String archetypeXmlText = this.defaultArchetypeXmlText();
        Document archDoc = this.archetypeUtils.parseXml(new InputSource(new StringReader(archetypeXmlText)));
        Element archRoot = archDoc.getDocumentElement();
        archRoot.setAttribute("name", archetypeDir.getName());
        LOG.debug("Found property names: {}", propertyNameSet);
        Element requiredProperties = this.replaceOrAddElement(archDoc, archRoot, "requiredProperties", Arrays.asList("fileSets"));
        for (Map.Entry entry : propertyNameSet.entrySet()) {
            requiredProperties.appendChild(archDoc.createTextNode("\n" + this.indent + this.indent));
            Element requiredProperty = archDoc.createElement("requiredProperty");
            requiredProperties.appendChild(requiredProperty);
            requiredProperty.setAttribute("key", (String)entry.getKey());
            if (entry.getValue() != null) {
                requiredProperty.appendChild(archDoc.createTextNode("\n" + this.indent + this.indent + this.indent));
                Element defaultValue = archDoc.createElement("defaultValue");
                requiredProperty.appendChild(defaultValue);
                defaultValue.appendChild(archDoc.createTextNode((String)entry.getValue()));
            }
            requiredProperty.appendChild(archDoc.createTextNode("\n" + this.indent + this.indent));
        }
        requiredProperties.appendChild(archDoc.createTextNode("\n" + this.indent));
        metadataXmlOutFile.getParentFile().mkdirs();
        this.archetypeUtils.writeXmlDocument(archDoc, metadataXmlOutFile);
        File archetypeProjectPom = new File(archetypeDir, "pom.xml");
        if (!archetypeProjectPom.exists()) {
            StringWriter sw = new StringWriter();
            IOUtils.copy((InputStream)this.getClass().getResourceAsStream("default-archetype-pom.xml"), (Writer)sw, (String)"UTF-8");
            Document pomDocument = this.archetypeUtils.parseXml(new InputSource(new StringReader(sw.toString())));
            List<String> emptyList = Collections.emptyList();
            Element artifactId = this.replaceOrAddElement(pomDocument, pomDocument.getDocumentElement(), "artifactId", emptyList);
            artifactId.setTextContent(archetypeDir.getName());
            Element name = this.replaceOrAddElement(pomDocument, pomDocument.getDocumentElement(), "name", emptyList);
            if (originalName.contains(" :: ")) {
                String[] originalNameTab = originalName.split(" :: ");
                if (originalNameTab.length > 2) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Fabric8 :: Archetypes");
                    for (int idx = 2; idx < originalNameTab.length; ++idx) {
                        sb.append(" :: ").append(originalNameTab[idx]);
                    }
                    name.setTextContent(sb.toString());
                } else {
                    name.setTextContent("Fabric8 :: Archetypes :: " + originalNameTab[1]);
                }
            } else {
                name.setTextContent("Fabric8 :: Archetypes :: " + originalName);
            }
            Element description = this.replaceOrAddElement(pomDocument, pomDocument.getDocumentElement(), "description", emptyList);
            description.setTextContent("Creates a new " + originalDescription);
            this.archetypeUtils.writeXmlDocument(pomDocument, archetypeProjectPom);
        }
    }

    private void removeCommentNodes(Document doc) {
        ArrayList<Node> toRemove = new ArrayList<Node>();
        NodeList children = doc.getChildNodes();
        for (int cn = 0; cn < children.getLength(); ++cn) {
            Node child = children.item(cn);
            if (8 != child.getNodeType()) continue;
            toRemove.add(child);
        }
        for (Node child : toRemove) {
            doc.removeChild(child);
        }
    }

    private String replaceNodeValue(Document doc, Element parent, String name, String newValue) {
        NodeList children = parent.getChildNodes();
        for (int cn = 0; cn < children.getLength(); ++cn) {
            String answer;
            Node child = children.item(cn);
            if (child instanceof Element && child.getNodeName().equals(name)) {
                Element e = (Element)children.item(cn);
                String answer2 = e.getTextContent();
                e.setTextContent(newValue);
                return answer2;
            }
            if (!(child instanceof Element) || !child.hasChildNodes() || (answer = this.replaceNodeValue(doc, (Element)child, name, newValue)) == null) continue;
            return answer;
        }
        return null;
    }

    protected Element replaceOrAddElementText(Document doc, Element parent, String name, String content, List<String> beforeNames) {
        Element element = this.replaceOrAddElement(doc, parent, name, beforeNames);
        element.setTextContent(content);
        return element;
    }

    private Element replaceOrAddElement(Document doc, Element parent, String name, List<String> beforeNames) {
        NodeList children = parent.getChildNodes();
        LinkedList<Element> elements = new LinkedList<Element>();
        for (int cn = 0; cn < children.getLength(); ++cn) {
            if (!(children.item(cn) instanceof Element) || !children.item(cn).getNodeName().equals(name)) continue;
            elements.add((Element)children.item(cn));
        }
        Element element = null;
        if (elements.isEmpty()) {
            String n;
            Element newElement = doc.createElement(name);
            Node first = null;
            Iterator<String> i$ = beforeNames.iterator();
            while (i$.hasNext() && (first = this.findChild(parent, n = i$.next())) == null) {
            }
            Node node = null;
            node = first != null ? first : parent.getFirstChild();
            Text text = doc.createTextNode("\n" + this.indent);
            parent.insertBefore(text, node);
            parent.insertBefore(newElement, text);
            element = newElement;
        } else {
            element = (Element)elements.get(0);
        }
        return element;
    }

    protected void addArchetypeMetaData(File pom, String outputName) throws FileNotFoundException {
        Document doc = this.archetypeUtils.parseXml(new InputSource(new FileReader(pom)));
        Element root = doc.getDocumentElement();
        String groupId = "io.fabric8.archetypes";
        String artifactId = this.archetypeUtils.firstElementText(root, "artifactId", outputName);
        String name = this.archetypeUtils.firstElementText(root, "name", "");
        String description = this.archetypeUtils.firstElementText(root, "description", "");
        String version = "";
        NodeList parents = root.getElementsByTagName("parent");
        if (parents.getLength() > 0) {
            version = this.archetypeUtils.firstElementText((Element)parents.item(0), "version", "");
        }
        if (version.length() == 0) {
            version = this.archetypeUtils.firstElementText(root, "version", "");
        }
        this.printWriter.println(String.format(this.indent + this.indent + "<archetype>\n" + this.indent + this.indent + this.indent + "<groupId>%s</groupId>\n" + this.indent + this.indent + this.indent + "<artifactId>%s</artifactId>\n" + this.indent + this.indent + this.indent + "<version>%s</version>\n" + this.indent + this.indent + this.indent + "<description>%s</description>\n" + this.indent + this.indent + "</archetype>", groupId, artifactId, version, description));
    }

    private boolean fileIncludesLine(File file, String matches) throws IOException {
        for (String line : FileUtils.readLines((File)file)) {
            String trimmed = line.trim();
            if (!trimmed.equals(matches)) continue;
            return true;
        }
        return false;
    }

    private void copyCodeFiles(File rootPackage, File outDir, Replacement replaceFn) throws IOException {
        if (rootPackage.isFile()) {
            this.copyFile(rootPackage, outDir, replaceFn);
        } else {
            outDir.mkdirs();
            String[] names = rootPackage.list();
            if (names != null) {
                for (String name : names) {
                    this.copyCodeFiles(new File(rootPackage, name), new File(outDir, name), replaceFn);
                }
            }
        }
    }

    private void copyFile(File src, File dest, Replacement replaceFn) throws IOException {
        if (replaceFn != null && this.isSourceFile(src)) {
            String original;
            String escapeDollarSquiggly = original = FileUtils.readFileToString((File)src);
            if (original.contains("${")) {
                String replaced = original.replaceAll(Pattern.quote("${"), "\\${D}{");
                escapeDollarSquiggly = "#set( $D = '$' )\n" + replaced;
            }
            String text = replaceFn.replace(escapeDollarSquiggly);
            FileUtils.write((File)dest, (CharSequence)text);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.warn("Not a source dir as the extension is {}", (Object)FilenameUtils.getExtension((String)src.getName()));
            }
            FileUtils.copyFile((File)src, (File)dest);
        }
    }

    private void copyOtherFiles(File projectDir, File srcDir, File outDir, Replacement replaceFn) throws IOException {
        if (this.archetypeUtils.isValidFileToCopy(projectDir, srcDir)) {
            if (srcDir.isFile()) {
                this.copyFile(srcDir, outDir, replaceFn);
            } else {
                outDir.mkdirs();
                String[] names = srcDir.list();
                if (names != null) {
                    for (String name : names) {
                        this.copyOtherFiles(projectDir, new File(srcDir, name), new File(outDir, name), replaceFn);
                    }
                }
            }
        }
    }

    private void copyDataFiles(File projectDir, File srcDir, File outDir, Replacement replaceFn) throws IOException {
        if (srcDir.isFile()) {
            this.copyFile(srcDir, outDir, replaceFn);
        } else {
            outDir.mkdirs();
            String[] names = srcDir.list();
            if (names != null) {
                for (String name : names) {
                    this.copyDataFiles(projectDir, new File(srcDir, name), new File(outDir, name), replaceFn);
                }
            }
        }
    }

    private boolean isSourceFile(File file) {
        String name = FilenameUtils.getExtension((String)file.getName()).toLowerCase();
        return sourceFileExtensions.contains(name);
    }

    protected boolean isValidRequiredPropertyName(String name) {
        return !name.equals("basedir") && !name.startsWith("project.") && !name.startsWith("pom.") && !name.equals("package");
    }

    protected Node findChild(Element parent, String n) {
        NodeList children = parent.getChildNodes();
        for (int cn = 0; cn < children.getLength(); ++cn) {
            if (!n.equals(children.item(cn).getNodeName())) continue;
            return children.item(cn);
        }
        return null;
    }

    private String defaultArchetypeXmlText() throws IOException {
        StringWriter sw = new StringWriter();
        IOUtils.copy((InputStream)this.getClass().getResourceAsStream("default-archetype-descriptor.xml"), (Writer)sw, (String)"UTF-8");
        return sw.toString();
    }

    private static class IdentityReplacement
    implements Replacement {
        private IdentityReplacement() {
        }

        @Override
        public String replace(String token) {
            return token;
        }
    }

    private static interface Replacement {
        public String replace(String var1);
    }
}

