/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tooling.archetype.builder;

import io.fabric8.tooling.archetype.builder.ArchetypeBuilder;
import io.fabric8.utils.Strings;
import java.io.File;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    public static Logger LOG = LoggerFactory.getLogger(Main.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        try {
            String sourcedir;
            String basedir = System.getProperty("basedir");
            if (Strings.isNullOrBlank((String)basedir)) {
                basedir = ".";
            }
            if (Strings.isNullOrBlank((String)(sourcedir = System.getProperty("sourcedir")))) {
                throw new IllegalArgumentException("No sourcedir system property");
            }
            File bomFile = new File(basedir, System.getProperty("rootPomFile", "../pom.xml"));
            File catalogFile = new File(basedir, "target/classes/archetype-catalog.xml").getCanonicalFile();
            catalogFile.getParentFile().mkdirs();
            String outputPath = System.getProperty("outputdir");
            File outputDir = Strings.isNotBlank((String)outputPath) ? new File(outputPath) : new File(basedir);
            ArchetypeBuilder builder = new ArchetypeBuilder(catalogFile);
            builder.setBomFile(bomFile);
            builder.configure();
            ArrayList<String> dirs = new ArrayList<String>();
            try {
                File sourceDirectory = new File(sourcedir);
                if (!sourceDirectory.exists() || !sourceDirectory.isDirectory()) {
                    throw new IllegalArgumentException("Source directory: " + sourcedir + " is not a valid directory");
                }
                builder.generateArchetypes("", sourceDirectory, outputDir, false, dirs);
            }
            finally {
                LOG.debug("Completed the generation. Closing!");
                builder.close();
            }
            StringBuffer sb = new StringBuffer();
            for (String dir : dirs) {
                sb.append("\n\t<module>" + dir + "</module>");
            }
            System.out.println("Done creating archetypes:\n" + sb + "\n");
        }
        catch (Exception e) {
            System.out.println("Caught: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

