/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tooling.archetype.builder;

import io.fabric8.tooling.archetype.builder.ArchetypeBuilder;
import java.io.File;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    public static Logger LOG = LoggerFactory.getLogger(Main.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        try {
            String basedir = System.getProperty("basedir");
            if (basedir == null) {
                basedir = ".";
            }
            File bomFile = new File(basedir, "../../pom.xml");
            File karafProfilesDir = new File(basedir, "../../fabric/fabric8-karaf/src/main/resources/distro/fabric/import/fabric/profiles/").getCanonicalFile();
            File catalogFile = new File(basedir, "target/classes/archetype-catalog.xml").getCanonicalFile();
            File quickStartJavaSrcDir = new File(basedir, "../../quickstarts/java").getCanonicalFile();
            File quickStartKarafSrcDir = new File(basedir, "../../quickstarts/karaf").getCanonicalFile();
            File quickStartKarafBeginnerSrcDir = new File(basedir, "../../quickstarts/karaf/beginner").getCanonicalFile();
            File quickStartKarafCxfSrcDir = new File(basedir, "../../quickstarts/karaf/cxf").getCanonicalFile();
            File quickStartMuleSrcDir = new File(basedir, "../../quickstarts/mule").getCanonicalFile();
            File quickStartSpringBootSrcDir = new File(basedir, "../../quickstarts/spring-boot").getCanonicalFile();
            File quickStartWarSrcDir = new File(basedir, "../../quickstarts/war").getCanonicalFile();
            File outputDir = args.length > 0 ? new File(args[0]) : new File(basedir, "../archetypes");
            ArchetypeBuilder builder = new ArchetypeBuilder(catalogFile);
            builder.setBomFile(bomFile);
            builder.configure();
            ArrayList<String> dirs = new ArrayList<String>();
            try {
                builder.generateArchetypes("java", quickStartJavaSrcDir, outputDir, false, dirs, karafProfilesDir);
                builder.generateArchetypes("karaf", quickStartKarafSrcDir, outputDir, false, dirs, karafProfilesDir);
                builder.generateArchetypes("karaf", quickStartKarafBeginnerSrcDir, outputDir, false, dirs, karafProfilesDir);
                builder.generateArchetypes("karaf", quickStartKarafCxfSrcDir, outputDir, false, dirs, karafProfilesDir);
                builder.generateArchetypes("mule", quickStartMuleSrcDir, outputDir, false, dirs, karafProfilesDir);
                builder.generateArchetypes("springboot", quickStartSpringBootSrcDir, outputDir, false, dirs, karafProfilesDir);
                builder.generateArchetypes("war", quickStartWarSrcDir, outputDir, false, dirs, karafProfilesDir);
            }
            finally {
                LOG.debug("Completed the generation. Closing!");
                builder.close();
            }
            StringBuffer sb = new StringBuffer();
            for (String dir : dirs) {
                sb.append("\n\t<module>" + dir + "</module>");
            }
            LOG.info("Done creating archetypes:\n{}\n\n", (Object)sb.toString());
        }
        catch (Exception e) {
            LOG.error("Caught: " + e.getMessage(), (Throwable)e);
        }
    }
}

