/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tooling.archetype;

import io.fabric8.tooling.archetype.ArchetypeService;
import io.fabric8.tooling.archetype.catalog.Archetype;
import io.fabric8.tooling.archetype.catalog.Archetypes;
import io.fabric8.utils.JMXUtils;
import io.fabric8.utils.Strings;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="io.fabric8.tooling.archetype.ArchetypeService", label="Fabric8 Archetype Service", description="Generates projects from Maven Archetypes.", policy=ConfigurationPolicy.OPTIONAL, immediate=true, metatype=true)
@Service(value={ArchetypeService.class})
public class ArchetypeServiceImpl
implements ArchetypeService {
    private static final transient Logger LOG = LoggerFactory.getLogger(ArchetypeServiceImpl.class);
    public static ObjectName OBJECT_NAME;
    private Map<String, Archetype> archetypes = new TreeMap<String, Archetype>();
    @Reference(referenceInterface=MBeanServer.class, bind="bindMBeanServer", unbind="unbindMBeanServer")
    private MBeanServer mbeanServer;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();

    @Activate
    void activate(Map<String, ?> configuration, ComponentContext componentContext) throws Exception {
        if (this.mbeanServer != null) {
            JMXUtils.registerMBean((Object)this, (MBeanServer)this.mbeanServer, (ObjectName)OBJECT_NAME);
        }
        URL catalog = componentContext.getBundleContext().getBundle().getResource("archetype-catalog.xml");
        Archetypes archetypes = (Archetypes)Archetypes.newUnmarshaller().unmarshal((Source)new StreamSource(catalog.openStream()));
        for (Archetype arch : archetypes.getArchetypes()) {
            this.archetypes.put(String.format("%s:%s:%s", arch.groupId, arch.artifactId, arch.version), arch);
        }
    }

    @Deactivate
    void deactivate() throws Exception {
        if (this.mbeanServer != null) {
            JMXUtils.unregisterMBean((MBeanServer)this.mbeanServer, (ObjectName)OBJECT_NAME);
        }
    }

    @Override
    public List<String[]> listArchetypeGAVs() {
        this.assertValid();
        ArrayList<String[]> answer = new ArrayList<String[]>(this.archetypes.size());
        for (Archetype a : this.archetypes.values()) {
            answer.add(new String[]{a.groupId, a.artifactId, a.version});
        }
        return answer;
    }

    private void assertValid() {
    }

    @Override
    public Collection<Archetype> listArchetypes() {
        this.assertValid();
        return this.archetypes.values();
    }

    @Override
    public List<Archetype> listArchetypes(String filter, boolean artifactIdOnly) {
        ArrayList<Archetype> answer = new ArrayList<Archetype>();
        if (Strings.isNullOrBlank((String)filter)) {
            answer.addAll(this.listArchetypes());
            return answer;
        }
        filter = filter.toLowerCase();
        for (Archetype archetype : this.archetypes.values()) {
            if (artifactIdOnly && archetype.artifactId.toLowerCase().contains(filter)) {
                answer.add(archetype);
                continue;
            }
            if (!archetype.groupId.toLowerCase().contains(filter) && !archetype.artifactId.toLowerCase().contains(filter) && !archetype.version.toLowerCase().contains(filter)) continue;
            answer.add(archetype);
        }
        return answer;
    }

    @Override
    public Archetype getArchetype(String gav) {
        return this.archetypes.get(gav);
    }

    @Override
    public Archetype getArchetypeByArtifact(String artifactId) {
        for (Archetype archetype : this.archetypes.values()) {
            if (!archetype.artifactId.equals(artifactId)) continue;
            return archetype;
        }
        return null;
    }

    void bindMBeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    void unbindMBeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = null;
    }

    static {
        try {
            OBJECT_NAME = new ObjectName("io.fabric8:type=ArchetypeService");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
    }
}

