/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tooling.archetype.builder;

import io.fabric8.common.util.Files;
import io.fabric8.tooling.archetype.builder.ArchetypeBuilder$copyPom$1;
import io.fabric8.tooling.archetype.builder.ArchetypeBuilder$fileIncludesLine$1;
import io.fabric8.tooling.archetype.builder.ArchetypeBuilder$findChild$1;
import io.fabric8.tooling.archetype.builder.ArchetypeBuilder$findRootPackage$children$1;
import io.fabric8.tooling.archetype.builder.ArchetypeBuilder$findRootPackage$results$1;
import io.fabric8.tooling.archetype.builder.ArchetypeBuilder$findRootPackage$results$2;
import io.fabric8.tooling.archetype.builder.ArchetypeBuilder$generateArchetype$1;
import io.fabric8.tooling.archetype.builder.ArchetypeBuilder$generateArchetype$mainSrcDir$1;
import io.fabric8.tooling.archetype.builder.ArchetypeBuilder$generateArchetype$mainSrcDir$2;
import io.fabric8.tooling.archetype.builder.ArchetypeBuilder$generateArchetype$replaceFunction$1;
import io.fabric8.tooling.archetype.builder.ArchetypeBuilder$generateArchetype$testSrcDir$1;
import io.fabric8.tooling.archetype.builder.ArchetypeBuilder$generateArchetype$testSrcDir$2;
import io.fabric8.tooling.archetype.builder.ArchetypeBuilder$replaceOrAddElement$elements$1;
import io.fabric8.tooling.archetype.builder.BuilderPackage$src$ArchetypeBuilder$-696200939;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jet.ExtensionFunction0;
import jet.Function1;
import jet.JetObject;
import jet.TypeCastException;
import jet.Unit;
import jet.runtime.Intrinsics;
import jet.runtime.SharedVar;
import jet.runtime.typeinfo.JetClass;
import jet.runtime.typeinfo.JetConstructor;
import jet.runtime.typeinfo.JetMethod;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.dom.DomPackage;
import kotlin.io.IoPackage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

@JetClass(signature="Ljava/lang/Object;", abiVersion=6)
public class ArchetypeBuilder
implements JetObject {
    private PrintWriter printWriter;
    private final File catalogXmlFile;

    @JetMethod(flags=17, propertyType="?Ljava/io/PrintWriter;")
    public final PrintWriter getPrintWriter() {
        return this.printWriter;
    }

    @JetMethod(flags=17, propertyType="?Ljava/io/PrintWriter;")
    public final void setPrintWriter(@JetValueParameter(name="<set-?>", type="?Ljava/io/PrintWriter;") PrintWriter printWriter) {
        this.printWriter = printWriter;
    }

    @JetMethod(returnType="V")
    public void configure(@JetValueParameter(name="args", type="[Ljava/lang/String;") String[] args) {
        block0: {
            File file = this.catalogXmlFile.getParentFile();
            Boolean bl = file != null ? Boolean.valueOf(file.mkdirs()) : null;
            IoPackage.println((Object)("writing catalog: " + this.catalogXmlFile));
            PrintWriter printWriter = this.printWriter = new PrintWriter(new FileWriter(this.catalogXmlFile));
            if (printWriter == null) break block0;
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<archetype-catalog  xmlns=\"http://maven.apache.org/plugins/maven-archetype-plugin/archetype-catalog/1.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:schemaLocation=\"http://maven.apache.org/plugins/maven-archetype-plugin/archetype-catalog/1.0.0 http://maven.apache.org/xsd/archetype-catalog-1.0.0.xsd\">\n  <archetypes>");
        }
    }

    @JetMethod(returnType="V")
    public void close() {
        block1: {
            PrintWriter printWriter = this.printWriter;
            if (printWriter != null) {
                printWriter.println("\n  </archetypes>\n</archetype-catalog>\n");
            }
            PrintWriter printWriter2 = this.printWriter;
            if (printWriter2 == null) break block1;
            printWriter2.close();
        }
    }

    @JetMethod(returnType="V")
    public void generateArchetypes(@JetValueParameter(name="sourceDir", type="Ljava/io/File;") File sourceDir, @JetValueParameter(name="outputDir", type="Ljava/io/File;") File outputDir) {
        File[] files = sourceDir.listFiles();
        boolean bl = true;
        if (files == null) {
            bl = false;
        }
        if (bl) {
            for (int i = 0; i < files.length; ++i) {
                String outputName;
                File pom;
                File file = files[i];
                if (!file.isDirectory() || !((pom = new File(file, "pom.xml")).exists() ? this.isValidPom(pom) : false)) continue;
                String fileName = IoPackage.getName((File)file);
                if (Intrinsics.areEqual((Object)fileName, (Object)(outputName = KotlinPackage.replace((String)fileName, (CharSequence)"example", (CharSequence)"archetype")))) {
                    outputName = outputName + "-archetype";
                }
                File archetypeDir = new File(outputDir, outputName);
                this.generateArchetype(file, pom, archetypeDir);
                File archetypePom = new File(archetypeDir, "pom.xml");
                if (!archetypePom.exists()) continue;
                this.addArchetypeMetaData(archetypePom, outputName);
            }
        }
    }

    @JetMethod(flags=32, returnType="Z")
    protected final boolean isValidPom(@JetValueParameter(name="pom", type="Ljava/io/File;") File pom) {
        Document doc = DomPackage.parseXml$default((InputSource)new InputSource(new FileReader(pom)), null, (int)2);
        Element element = DomPackage.getDocumentElement((Document)doc);
        if (element == null) {
            Intrinsics.throwNpe();
        }
        Element root = element;
        String packaging = this.firstElementText(root, "packaging", "");
        boolean bl = true;
        if (packaging == null) {
            bl = false;
        }
        return !(bl ? packaging.equals("pom") : false);
    }

    @JetMethod(flags=32, returnType="V")
    protected void addArchetypeMetaData(@JetValueParameter(name="pom", type="Ljava/io/File;") File pom, @JetValueParameter(name="outputName", type="Ljava/lang/String;") String outputName) {
        block4: {
            Document doc = DomPackage.parseXml$default((InputSource)new InputSource(new FileReader(pom)), null, (int)2);
            Element element = DomPackage.getDocumentElement((Document)doc);
            if (element == null) {
                Intrinsics.throwNpe();
            }
            Element root = element;
            String groupId = "io.fabric8";
            String artifactId = this.firstElementText(root, "artifactId", outputName);
            String description = this.firstElementText(root, "description", "");
            String version = "";
            List parents = DomPackage.childElements((Element)root, (String)"parent");
            if (!parents.isEmpty()) {
                version = this.firstElementText((Element)parents.get(0), "version", "");
            }
            boolean bl = true;
            if (version.length() != 0) {
                bl = false;
            }
            if (bl) {
                this.firstElementText(root, "version", "");
            }
            String repo = "https://repo.fusesource.com/nexus/content/groups/public";
            PrintWriter printWriter = this.printWriter;
            if (printWriter == null) break block4;
            printWriter.println("\n" + "    <archetype>" + "\n" + "      <groupId>" + groupId + "</groupId>" + "\n" + "      <artifactId>" + artifactId + "</artifactId>" + "\n" + "      <version>" + version + "</version>" + "\n" + "      <repository>" + repo + "</repository>" + "\n" + "      <description>" + description + "</description>" + "\n" + "    </archetype>");
        }
    }

    @JetMethod(flags=32, returnType="Ljava/lang/String;")
    protected String firstElementText(@JetValueParameter(name="root", type="Lorg/w3c/dom/Element;") Element root, @JetValueParameter(name="elementName", type="Ljava/lang/String;") String elementName, @JetValueParameter(name="defaultValue", type="Ljava/lang/String;") String defaultValue) {
        List children2 = DomPackage.childElements((Element)root, (String)elementName);
        if (children2.isEmpty()) {
            return defaultValue;
        }
        Element first = (Element)children2.get(0);
        return DomPackage.getTextContent((Node)first);
    }

    @JetMethod(flags=32, returnType="V")
    protected void generateArchetype(@JetValueParameter(name="directory", type="Ljava/io/File;") File directory, @JetValueParameter(name="pom", type="Ljava/io/File;") File pom, @JetValueParameter(name="outputDir", type="Ljava/io/File;") File outputDir) {
        IoPackage.println((Object)("Generating archetype at " + IoPackage.getCanonicalPath((File)outputDir) + " from " + IoPackage.getCanonicalPath((File)directory)));
        File srcDir = new File(directory, "src/main");
        File testDir = new File(directory, "src/test");
        File outputSrcDir = new File(outputDir, "src");
        File outputGitIgnoreFile = new File(outputDir, ".gitignore");
        if (outputSrcDir.exists() ? this.fileIncludesLine(outputGitIgnoreFile, "src") : false) {
            IoPackage.println((Object)("Removing generated src dir " + outputSrcDir));
            Files.recursiveDelete((File)outputSrcDir, (FileFilter)null);
            KotlinPackage.assert((!outputSrcDir.exists() ? 1 : 0) != 0, (Object)("the directory " + outputSrcDir + " should not exist!"));
        }
        File archetypeOutputDir = new File(outputDir, "src/main/resources/archetype-resources");
        File metadataXmlFile = new File(directory, "archetype-metadata.xml");
        File metadataXmlOutFile = new File(outputDir, "src/main/resources-filtered/META-INF/maven/archetype-metadata.xml");
        Function1 replaceFunction2 = (Function1)ArchetypeBuilder$generateArchetype$replaceFunction$1.instance$;
        File mainSrcDir2 = (File)KotlinPackage.find((Iterable)KotlinPackage.map((Collection)BuilderPackage$src$ArchetypeBuilder$-696200939.getSourceCodeDirNames(), (Function1)((Function1)new ArchetypeBuilder$generateArchetype$mainSrcDir$1(srcDir))), (Function1)((Function1)ArchetypeBuilder$generateArchetype$mainSrcDir$2.instance$));
        boolean bl = true;
        if (mainSrcDir2 == null) {
            bl = false;
        }
        if (bl) {
            File rootPackage = this.findRootPackage(mainSrcDir2);
            boolean bl2 = true;
            if (rootPackage == null) {
                bl2 = false;
            }
            if (bl2) {
                String packagePath = IoPackage.relativePath((File)mainSrcDir2, (File)rootPackage);
                String packageName = KotlinPackage.replaceAll((String)packagePath, (String)"/", (String)".");
                String regex = KotlinPackage.replaceAll((String)packageName, (String)"\\.", (String)"\\\\.");
                replaceFunction2 = (Function1)new ArchetypeBuilder$generateArchetype$1(regex);
                File outputMainSrc = new File(archetypeOutputDir, IoPackage.relativePath((File)directory, (File)mainSrcDir2));
                this.copyCodeFiles(rootPackage, outputMainSrc, (Function1<? super String, ? extends String>)replaceFunction2);
                File testSrcDir2 = (File)KotlinPackage.find((Iterable)KotlinPackage.map((Collection)BuilderPackage$src$ArchetypeBuilder$-696200939.getSourceCodeDirNames(), (Function1)((Function1)new ArchetypeBuilder$generateArchetype$testSrcDir$1(testDir))), (Function1)((Function1)ArchetypeBuilder$generateArchetype$testSrcDir$2.instance$));
                boolean bl3 = true;
                if (testSrcDir2 == null) {
                    bl3 = false;
                }
                if (bl3) {
                    File rootTestDir = new File(testSrcDir2, packagePath);
                    File outputTestSrc = new File(archetypeOutputDir, IoPackage.relativePath((File)directory, (File)testSrcDir2));
                    if (rootTestDir.exists()) {
                        this.copyCodeFiles(rootTestDir, outputTestSrc, (Function1<? super String, ? extends String>)replaceFunction2);
                    } else {
                        this.copyCodeFiles(testSrcDir2, outputTestSrc, (Function1<? super String, ? extends String>)replaceFunction2);
                    }
                }
            }
        }
        this.copyPom(pom, new File(archetypeOutputDir, "pom.xml"), metadataXmlFile, metadataXmlOutFile, (Function1<? super String, ? extends String>)replaceFunction2);
        this.copyOtherFiles(directory, directory, archetypeOutputDir, (Function1<? super String, ? extends String>)replaceFunction2);
    }

    @JetMethod(flags=32, returnType="Z")
    protected boolean fileIncludesLine(@JetValueParameter(name="gitIgnore", type="Ljava/io/File;") File gitIgnore, @JetValueParameter(name="matches", type="Ljava/lang/String;") String matches) {
        SharedVar.Boolean answer = new SharedVar.Boolean();
        answer.ref = 0;
        IoPackage.forEachLine$default((File)gitIgnore, null, (Function1)((Function1)new ArchetypeBuilder$fileIncludesLine$1(answer, matches)), (int)1);
        return answer.ref;
    }

    @JetMethod(flags=32, returnType="V")
    protected void copyCodeFiles(@JetValueParameter(name="srcDir", type="Ljava/io/File;") File srcDir, @JetValueParameter(name="outDir", type="Ljava/io/File;") File outDir, @JetValueParameter(name="replaceFn", type="Ljet/Function1<Ljava/lang/String;Ljava/lang/String;>;") Function1<? super String, ? extends String> replaceFn) {
        if (srcDir.isFile()) {
            this.copyFile(srcDir, outDir, replaceFn);
        } else {
            outDir.mkdirs();
            String[] names = srcDir.list();
            boolean bl = true;
            if (names == null) {
                bl = false;
            }
            if (bl) {
                for (int i = 0; i < names.length; ++i) {
                    String name = names[i];
                    this.copyCodeFiles(new File(srcDir, name), new File(outDir, name), replaceFn);
                }
            }
        }
    }

    @JetMethod(flags=32, returnType="V")
    protected void copyPom(@JetValueParameter(name="pom", type="Ljava/io/File;") File pom, @JetValueParameter(name="outFile", type="Ljava/io/File;") File outFile, @JetValueParameter(name="metadataXmlFile", type="Ljava/io/File;") File metadataXmlFile, @JetValueParameter(name="metadataXmlOutFile", type="Ljava/io/File;") File metadataXmlOutFile, @JetValueParameter(name="replaceFn", type="Ljet/Function1<Ljava/lang/String;Ljava/lang/String;>;") Function1<? super String, ? extends String> replaceFn) {
        IoPackage.println((Object)("Parsing " + pom));
        String text = (String)replaceFn.invoke((Object)IoPackage.readText$default((File)pom, null, (int)1));
        Document doc = DomPackage.parseXml$default((InputSource)new InputSource(new StringReader(text)), null, (int)2);
        Element root = DomPackage.getDocumentElement((Document)doc);
        Set propertyNameSet = KotlinPackage.sortedSet((Object[])new String[0]);
        boolean bl = true;
        if (root == null) {
            bl = false;
        }
        if (bl) {
            List parents = DomPackage.elements((Element)root, (String)"parent");
            if (KotlinPackage.notEmpty((Collection)parents)) {
                root.removeChild((Node)parents.get(0));
            }
            HashSet<String> pomPropertyNames = new HashSet<String>();
            List propertyElements = DomPackage.elements((Element)root, (String)"properties");
            if (KotlinPackage.notEmpty((Collection)propertyElements)) {
                Element propertyElement = (Element)propertyElements.get(0);
                for (Object e : DomPackage.children((Element)propertyElement)) {
                    if (!(e instanceof Element)) continue;
                    pomPropertyNames.add(DomPackage.getNodeName((Node)e));
                }
            }
            for (Element e : DomPackage.elements((Element)root, (String)"*")) {
                String name;
                int offset;
                int idx;
                String prefix;
                String text2 = DomPackage.getChildrenText((Element)e);
                if (!KotlinPackage.startsWith((String)text2, (String)(prefix = "${")) || (idx = KotlinPackage.indexOf((String)text2, (char)'}', (int)((offset = KotlinPackage.getSize((String)prefix)) + 1))) <= 0 || !(!pomPropertyNames.contains(name = KotlinPackage.substring((String)text2, (int)offset, (int)idx)) ? this.isValidRequiredPropertyName(name) : false)) continue;
                propertyNameSet.add(name);
            }
            ArrayList beforeNames = KotlinPackage.arrayList((Object[])new String[]{"artifactId", "version", "packaging", "name", "properties"});
            this.replaceOrAddElementText(doc, root, "version", "${version}", beforeNames);
            this.replaceOrAddElementText(doc, root, "artifactId", "${artifactId}", beforeNames);
            this.replaceOrAddElementText(doc, root, "groupId", "${groupId}", beforeNames);
        }
        File file = outFile.getParentFile();
        Boolean bl2 = file != null ? Boolean.valueOf(file.mkdirs()) : null;
        DomPackage.writeXmlString((Node)doc, (Writer)new FileWriter(outFile), (boolean)true);
        String archetypeXmlText = metadataXmlFile.exists() ? IoPackage.readText$default((File)metadataXmlFile, null, (int)1) : this.defaultArchetypeXmlText();
        Document archDoc = DomPackage.parseXml$default((InputSource)new InputSource(new StringReader(archetypeXmlText)), null, (int)2);
        Element archRoot = DomPackage.getDocumentElement((Document)archDoc);
        IoPackage.println((Object)("Found property names " + propertyNameSet));
        boolean bl3 = true;
        if (archRoot == null) {
            bl3 = false;
        }
        if (bl3) {
            Element requiredProperties = this.replaceOrAddElement(archDoc, archRoot, "requiredProperties", KotlinPackage.arrayList((Object[])new String[]{"fileSets"}));
            for (String propertyName : propertyNameSet) {
                DomPackage.addText$default((Element)requiredProperties, (String)"\n    ", null, (int)2);
                DomPackage.addElement$default((Element)requiredProperties, (String)"requiredProperty", null, (ExtensionFunction0)((ExtensionFunction0)new ArchetypeBuilder$copyPom$1(propertyName)), (int)2);
            }
            DomPackage.addText$default((Element)requiredProperties, (String)"\n  ", null, (int)2);
        }
        File file2 = metadataXmlOutFile.getParentFile();
        Boolean bl4 = file2 != null ? Boolean.valueOf(file2.mkdirs()) : null;
        DomPackage.writeXmlString((Node)archDoc, (Writer)new FileWriter(metadataXmlOutFile), (boolean)true);
    }

    @JetMethod(flags=32, returnType="Lorg/w3c/dom/Element;")
    protected final Element replaceOrAddElementText(@JetValueParameter(name="doc", type="Lorg/w3c/dom/Document;") Document doc, @JetValueParameter(name="parent", type="Lorg/w3c/dom/Element;") Element parent, @JetValueParameter(name="name", type="Ljava/lang/String;") String name, @JetValueParameter(name="content", type="Ljava/lang/String;") String content, @JetValueParameter(name="beforeNames", type="Ljet/Iterable<Ljava/lang/String;>;") Iterable<? extends String> beforeNames) {
        Element element = this.replaceOrAddElement(doc, parent, name, beforeNames);
        DomPackage.setText((Node)element, (String)content);
        return element;
    }

    /*
     * WARNING - void declaration
     */
    @JetMethod(flags=32, returnType="Lorg/w3c/dom/Element;")
    protected final Element replaceOrAddElement(@JetValueParameter(name="doc", type="Lorg/w3c/dom/Document;") Document doc, @JetValueParameter(name="parent", type="Lorg/w3c/dom/Element;") Element parent, @JetValueParameter(name="name", type="Ljava/lang/String;") String name, @JetValueParameter(name="beforeNames", type="Ljet/Iterable<Ljava/lang/String;>;") Iterable<? extends String> beforeNames) {
        Node element;
        Node node;
        List children2 = DomPackage.children((Element)parent);
        List elements2 = KotlinPackage.filter((Collection)children2, (Function1)((Function1)new ArchetypeBuilder$replaceOrAddElement$elements$1(name)));
        if (elements2.isEmpty()) {
            void var8_7;
            Node node2;
            Element element2 = doc.createElement(name);
            if (element2 == null) {
                Intrinsics.throwNpe();
            }
            Element newElement = element2;
            Node first = null;
            for (String string : beforeNames) {
                first = this.findChild(parent, string);
                boolean bl = true;
                if (first == null) {
                    bl = false;
                }
                if (!bl) continue;
                break;
            }
            boolean bl = true;
            if (first == null) {
                bl = false;
            }
            if (bl) {
                node2 = first;
                if (node2 == null) {
                    Intrinsics.throwNpe();
                }
            } else {
                node2 = parent.getFirstChild();
                if (node2 == null) {
                    Intrinsics.throwNpe();
                }
            }
            Node node3 = node2;
            Text text = doc.createTextNode("\n  ");
            if (text == null) {
                Intrinsics.throwNpe();
            }
            Text text2 = text;
            parent.insertBefore(text2, node3);
            parent.insertBefore(newElement, text2);
            node = (Node)var8_7;
        } else {
            node = (Node)elements2.get(0);
        }
        Node node4 = element = node;
        if (node4 == null) {
            throw new TypeCastException("org.w3c.dom.Node cannot be cast to org.w3c.dom.Element");
        }
        return (Element)node4;
    }

    @JetMethod(flags=32, returnType="?Lorg/w3c/dom/Node;")
    protected final Node findChild(@JetValueParameter(name="parent", type="Lorg/w3c/dom/Element;") Element parent, @JetValueParameter(name="n", type="Ljava/lang/String;") String n) {
        List children2 = DomPackage.children((Element)parent);
        return (Node)KotlinPackage.find((Iterable)children2, (Function1)((Function1)new ArchetypeBuilder$findChild$1(n)));
    }

    @JetMethod(flags=32, returnType="V")
    protected final void copyFile(@JetValueParameter(name="src", type="Ljava/io/File;") File src2, @JetValueParameter(name="dest", type="Ljava/io/File;") File dest, @JetValueParameter(name="replaceFn", type="Ljet/Function1<Ljava/lang/String;Ljava/lang/String;>;") Function1<? super String, ? extends String> replaceFn) {
        Long l;
        if (this.isSourceFile(src2)) {
            String original;
            String escapeDollarSquiggly = original = IoPackage.readText$default((File)src2, null, (int)1);
            if (KotlinPackage.contains((String)original, (CharSequence)"${")) {
                String replaced = KotlinPackage.replaceAll((String)original, (String)"\\$\\{", (String)"\\$\\{D\\}\\{");
                escapeDollarSquiggly = "#set( $D = '$' )\n" + replaced;
            }
            String text = (String)replaceFn.invoke((Object)escapeDollarSquiggly);
            IoPackage.writeText$default((File)dest, (String)text, null, (int)2);
            l = Unit.VALUE;
        } else {
            IoPackage.println((Object)("Not a source dir as the extention is " + IoPackage.getExtension((File)src2)));
            l = IoPackage.copyTo$default((File)src2, (File)dest, (int)0, (int)2);
        }
    }

    @JetMethod(flags=32, returnType="V")
    protected void copyOtherFiles(@JetValueParameter(name="projectDir", type="Ljava/io/File;") File projectDir, @JetValueParameter(name="srcDir", type="Ljava/io/File;") File srcDir, @JetValueParameter(name="outDir", type="Ljava/io/File;") File outDir, @JetValueParameter(name="replaceFn", type="Ljet/Function1<Ljava/lang/String;Ljava/lang/String;>;") Function1<? super String, ? extends String> replaceFn) {
        if (this.isValidFileToCopy(projectDir, srcDir)) {
            if (srcDir.isFile()) {
                this.copyFile(srcDir, outDir, replaceFn);
            } else {
                outDir.mkdirs();
                String[] names = srcDir.list();
                boolean bl = true;
                if (names == null) {
                    bl = false;
                }
                if (bl) {
                    for (int i = 0; i < names.length; ++i) {
                        String name = names[i];
                        this.copyOtherFiles(projectDir, new File(srcDir, name), new File(outDir, name), replaceFn);
                    }
                }
            }
        }
    }

    @JetMethod(flags=32, returnType="?Ljava/io/File;")
    protected File findRootPackage(@JetValueParameter(name="directory", type="Ljava/io/File;") File directory) {
        File[] children2 = IoPackage.listFiles((File)directory, (Function1)((Function1)new ArchetypeBuilder$findRootPackage$children$1(this)));
        boolean bl = true;
        if (children2 == null) {
            bl = false;
        }
        if (bl) {
            List results2 = KotlinPackage.filter((Collection)KotlinPackage.map((Object[])children2, (Function1)((Function1)new ArchetypeBuilder$findRootPackage$results$1(this))), (Function1)((Function1)ArchetypeBuilder$findRootPackage$results$2.instance$));
            if (KotlinPackage.getSize((Collection)results2) == 1) {
                return (File)results2.get(0);
            }
            return directory;
        }
        return null;
    }

    @JetMethod(flags=32, returnType="Z")
    protected boolean isValidSourceFileOrDir(@JetValueParameter(name="file", type="Ljava/io/File;") File file) {
        String name = IoPackage.getName((File)file);
        return !KotlinPackage.startsWith((String)name, (String)".") ? !BuilderPackage$src$ArchetypeBuilder$-696200939.getExcludeExtensions().contains(IoPackage.getExtension((File)file)) : false;
    }

    @JetMethod(flags=32, returnType="Z")
    protected boolean isSourceFile(@JetValueParameter(name="file", type="Ljava/io/File;") File file) {
        String name = KotlinPackage.toLowerCase((String)IoPackage.getExtension((File)file));
        return BuilderPackage$src$ArchetypeBuilder$-696200939.getSourceFileExtensions().contains(name);
    }

    @JetMethod(flags=32, returnType="Z")
    protected boolean isValidFileToCopy(@JetValueParameter(name="projectDir", type="Ljava/io/File;") File projectDir, @JetValueParameter(name="src", type="Ljava/io/File;") File src2) {
        if (this.isValidSourceFileOrDir(src2)) {
            if (Intrinsics.areEqual((Object)src2, (Object)projectDir)) {
                return true;
            }
            String relative = IoPackage.relativePath((File)projectDir, (File)src2);
            return !BuilderPackage$src$ArchetypeBuilder$-696200939.getSourceCodeDirPaths().contains(relative);
        }
        return false;
    }

    @JetMethod(flags=32, returnType="Z")
    protected boolean isValidRequiredPropertyName(@JetValueParameter(name="name", type="Ljava/lang/String;") String name) {
        return Intrinsics.areEqual((Object)name, (Object)"basedir") ^ true ? !KotlinPackage.startsWith((String)name, (String)"project.") : false;
    }

    @JetMethod(flags=32, returnType="Ljava/lang/String;")
    protected String defaultArchetypeXmlText() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<archetype-descriptor xsi:schemaLocation=\"http://maven.apache.org/plugins/maven-archetype-plugin/archetype-descriptor/1.0.0 http://maven.apache.org/xsd/archetype-descriptor-1.0.0.xsd\" name=\"camel-archetype-java\"\n    xmlns=\"http://maven.apache.org/plugins/maven-archetype-plugin/archetype-descriptor/1.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <requiredProperties/>\n  <fileSets>\n    <fileSet filtered=\"true\" packaged=\"true\" encoding=\"UTF-8\">\n      <directory>src/main/java</directory>\n      <includes>\n        <include>**/*.java</include>\n      </includes>\n    </fileSet>\n    <fileSet filtered=\"true\" encoding=\"UTF-8\">\n      <directory>src/main</directory>\n      <includes>\n        <include>**/*.bpm*</include>\n        <include>**/*.csv</include>\n        <include>**/*.drl</include>\n        <include>**/*.wsdl</include>\n        <include>**/*.xml</include>\n        <include>**/*.properties</include>\n      </includes>\n      <excludes>\n        <exclude>java/**</exclude>\n      </excludes>\n    </fileSet>\n    <fileSet filtered=\"false\" encoding=\"UTF-8\">\n      <directory>src/main</directory>\n      <includes>\n        <include>**/*.xls</include>\n      </includes>\n      <excludes>\n        <exclude>java/**</exclude>\n      </excludes>\n    </fileSet>\n    <fileSet filtered=\"true\" packaged=\"true\" encoding=\"UTF-8\">\n      <directory>src/test/java</directory>\n      <includes>\n        <include>**/*.java</include>\n      </includes>\n    </fileSet>\n    <fileSet filtered=\"true\" encoding=\"UTF-8\">\n      <directory>src/test</directory>\n      <includes>\n        <include>**/*.bpm*</include>\n        <include>**/*.csv</include>\n        <include>**/*.drl</include>\n        <include>**/*.wsdl</include>\n        <include>**/*.xml</include>\n        <include>**/*.properties</include>\n      </includes>\n      <excludes>\n        <exclude>java/**</exclude>\n      </excludes>\n    </fileSet>\n    <fileSet filtered=\"false\" encoding=\"UTF-8\">\n      <directory>src/test</directory>\n      <includes>\n        <include>**/*.xls</include>\n      </includes>\n      <excludes>\n        <exclude>java/**</exclude>\n      </excludes>\n    </fileSet>\n    <fileSet filtered=\"true\" encoding=\"UTF-8\">\n      <directory>src/data</directory>\n      <includes>\n        <include>**/*.xml</include>\n      </includes>\n    </fileSet>\n    <fileSet filtered=\"true\" encoding=\"UTF-8\">\n      <directory></directory>\n      <includes>\n        <include>ReadMe.*</include>\n      </includes>\n    </fileSet>\n  </fileSets>\n</archetype-descriptor>\n";
    }

    @JetMethod(flags=17, propertyType="Ljava/io/File;")
    public final File getCatalogXmlFile() {
        return this.catalogXmlFile;
    }

    @JetConstructor
    public ArchetypeBuilder(@JetValueParameter(name="catalogXmlFile", type="Ljava/io/File;") File catalogXmlFile) {
        this.catalogXmlFile = catalogXmlFile;
    }
}

