/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.apps.console;

import io.fabric8.kubernetes.api.model.BaseKubernetesListFluent;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.ServiceAccountFluent;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import io.fabric8.kubernetes.generator.annotation.KubernetesModelProcessor;
import java.util.Arrays;
import java.util.List;

@KubernetesModelProcessor
public class ConsoleModelProcessor {
    int jenkinshiftPort = 9191;

    public void onPodSpec(PodSpecBuilder builder) {
        List containers = builder.getContainers();
        if (containers.isEmpty()) {
            System.out.println("WARNING: no containers to modify!");
        } else {
            Container container = (Container)containers.get(0);
            container.setCommand(Arrays.asList("/kuisp", "-p", "9090", "-c", "/site/osconsole/config.basic.js.tmpl=/site/osconsole/config.js", "--bearer-token=/var/run/secrets/kubernetes.io/serviceaccount/token", "--skip-cert-validation=true", "--default-page=/index.html", "--max-age=24h", "-s", "/k8s/=https://kubernetes:443/", "--compress"));
            List envVars = container.getEnv();
            envVars.add(((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName("KUBERNETES_MASTER_URI")).withValue("k8s")).build());
            container.setEnv(envVars);
            builder.withContainers(containers);
            System.out.println("Updated container command for " + container.getName() + " " + container.getImage() + " to: " + container.getCommand());
        }
    }

    public void onList(KubernetesListBuilder builder) {
        ((KubernetesListBuilder)((BaseKubernetesListFluent.ServiceAccountItemsNested)((ServiceAccountFluent.MetadataNested)builder.addNewServiceAccountItem().withNewMetadata().withName("fabric8")).endMetadata()).endServiceAccountItem()).build();
        ((KubernetesListBuilder)((BaseKubernetesListFluent.ServiceItemsNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceFluent.SpecNested)((BaseKubernetesListFluent.ServiceItemsNested)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)builder.addNewServiceItem().withNewMetadata().withName("jenkinshift")).addToLabels("group", "io.fabric8.apps")).addToLabels("project", "console")).addToLabels("provider", "fabric8")).endMetadata()).withNewSpec().withType("LoadBalancer")).addNewPort().withName("http")).withProtocol("TCP")).withPort(Integer.valueOf(80))).withNewTargetPort(Integer.valueOf(this.jenkinshiftPort))).endPort()).addToSelector("group", "io.fabric8.apps")).addToSelector("project", "console")).addToSelector("provider", "fabric8")).endSpec()).endServiceItem()).build();
    }

    public void onPodTemplateSpec(PodSpecBuilder builder) {
        String jenkinshiftVersion = System.getProperty("project.version");
        ((PodSpecBuilder)((PodSpecFluent.ContainersNested)((ContainerFluent.PortsNested)((ContainerFluent.PortsNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)builder.addNewContainer().withName("jenkinshift")).withImage("fabric8/jenkinshift:" + jenkinshiftVersion)).addNewPort().withContainerPort(Integer.valueOf(this.jenkinshiftPort))).withProtocol("TCP")).endPort()).endContainer()).build();
    }
}

