/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.shaded.jmx_exporter.io.prometheus.jmx.shaded.io.prometheus.client.hotspot;

import com.sun.management.OperatingSystemMXBean;
import com.sun.management.UnixOperatingSystemMXBean;
import io.fabric8.agent.shaded.jmx_exporter.io.prometheus.jmx.shaded.io.prometheus.client.Collector;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class StandardExports
extends Collector {
    private static final Logger LOGGER = Logger.getLogger(StandardExports.class.getName());
    private StatusReader statusReader;
    private OperatingSystemMXBean osBean;
    private RuntimeMXBean runtimeBean;
    private boolean unix;
    private boolean linux;
    private static final double KB = 1024.0;

    public StandardExports() {
        this(new StatusReader(), (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean(), ManagementFactory.getRuntimeMXBean());
    }

    StandardExports(StatusReader statusReader, OperatingSystemMXBean osBean, RuntimeMXBean runtimeBean) {
        this.statusReader = statusReader;
        this.osBean = osBean;
        this.runtimeBean = runtimeBean;
        if (osBean instanceof UnixOperatingSystemMXBean) {
            this.unix = true;
        }
        if (osBean.getName().indexOf("Linux") == 0) {
            this.linux = true;
        }
    }

    Collector.MetricFamilySamples singleMetric(String name, Collector.Type type, String help, double value) {
        ArrayList<Collector.MetricFamilySamples.Sample> samples = new ArrayList<Collector.MetricFamilySamples.Sample>();
        samples.add(new Collector.MetricFamilySamples.Sample(name, new ArrayList<String>(), new ArrayList<String>(), value));
        return new Collector.MetricFamilySamples(name, type, help, samples);
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        mfs.add(this.singleMetric("process_cpu_seconds_total", Collector.Type.COUNTER, "CPU time used by the process in seconds.", (double)this.osBean.getProcessCpuTime() / 1.0E9));
        mfs.add(this.singleMetric("process_start_time_seconds", Collector.Type.GAUGE, "Start time of the process, in unixtime.", (double)this.runtimeBean.getStartTime() / 1000.0));
        if (this.unix) {
            UnixOperatingSystemMXBean unixBean = (UnixOperatingSystemMXBean)this.osBean;
            mfs.add(this.singleMetric("process_open_fds", Collector.Type.GAUGE, "The number of open file descriptors.", unixBean.getOpenFileDescriptorCount()));
            mfs.add(this.singleMetric("process_max_fds", Collector.Type.GAUGE, "The maximum number of open file descriptors.", unixBean.getMaxFileDescriptorCount()));
        }
        if (this.linux) {
            try {
                this.collectMemoryMetricsLinux(mfs);
            }
            catch (Exception e) {
                LOGGER.warning(e.toString());
            }
        }
        return mfs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void collectMemoryMetricsLinux(List<Collector.MetricFamilySamples> mfs) {
        BufferedReader br = null;
        try {
            String line;
            br = this.statusReader.procSelfStatusReader();
            while ((line = br.readLine()) != null) {
                if (line.startsWith("VmSize:")) {
                    mfs.add(this.singleMetric("process_virtual_memory_bytes", Collector.Type.GAUGE, "The virtual memory size of the process, in bytes.", (double)Float.parseFloat(line.split("\\s+")[1]) * 1024.0));
                    continue;
                }
                if (!line.startsWith("VmRSS:")) continue;
                mfs.add(this.singleMetric("process_resident_memory_bytes", Collector.Type.GAUGE, "The resident memory size of the process, in bytes.", (double)Float.parseFloat(line.split("\\s+")[1]) * 1024.0));
            }
        }
        catch (IOException e) {
            LOGGER.fine(e.toString());
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    LOGGER.fine(e.toString());
                }
            }
        }
    }

    static class StatusReader {
        StatusReader() {
        }

        BufferedReader procSelfStatusReader() throws FileNotFoundException {
            return new BufferedReader(new FileReader("/proc/self/status"));
        }
    }
}

