/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.shaded.jmx_exporter.io.prometheus.jmx.shaded.io.prometheus.client.hotspot;

import io.fabric8.agent.shaded.jmx_exporter.io.prometheus.jmx.shaded.io.prometheus.client.Collector;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MemoryPoolsExports
extends Collector {
    private final MemoryMXBean memoryBean;
    private final List<MemoryPoolMXBean> poolBeans;

    public MemoryPoolsExports() {
        this(ManagementFactory.getMemoryMXBean(), ManagementFactory.getMemoryPoolMXBeans());
    }

    public MemoryPoolsExports(MemoryMXBean memoryBean, List<MemoryPoolMXBean> poolBeans) {
        this.memoryBean = memoryBean;
        this.poolBeans = poolBeans;
    }

    void addMemoryAreaMetrics(List<Collector.MetricFamilySamples> sampleFamilies) {
        MemoryUsage heapUsage = this.memoryBean.getHeapMemoryUsage();
        MemoryUsage nonHeapUsage = this.memoryBean.getNonHeapMemoryUsage();
        ArrayList<Collector.MetricFamilySamples.Sample> usedSamples = new ArrayList<Collector.MetricFamilySamples.Sample>();
        usedSamples.add(new Collector.MetricFamilySamples.Sample("jvm_memory_bytes_used", Arrays.asList("area"), Arrays.asList("heap"), heapUsage.getUsed()));
        usedSamples.add(new Collector.MetricFamilySamples.Sample("jvm_memory_bytes_used", Arrays.asList("area"), Arrays.asList("nonheap"), nonHeapUsage.getUsed()));
        sampleFamilies.add(new Collector.MetricFamilySamples("jvm_memory_bytes_used", Collector.Type.GAUGE, "Used bytes of a given JVM memory area.", usedSamples));
        ArrayList<Collector.MetricFamilySamples.Sample> committedSamples = new ArrayList<Collector.MetricFamilySamples.Sample>();
        committedSamples.add(new Collector.MetricFamilySamples.Sample("jvm_memory_bytes_committed", Arrays.asList("area"), Arrays.asList("heap"), heapUsage.getCommitted()));
        committedSamples.add(new Collector.MetricFamilySamples.Sample("jvm_memory_bytes_committed", Arrays.asList("area"), Arrays.asList("nonheap"), nonHeapUsage.getCommitted()));
        sampleFamilies.add(new Collector.MetricFamilySamples("jvm_memory_bytes_committed", Collector.Type.GAUGE, "Committed (bytes) of a given JVM memory area.", committedSamples));
        ArrayList<Collector.MetricFamilySamples.Sample> maxSamples = new ArrayList<Collector.MetricFamilySamples.Sample>();
        maxSamples.add(new Collector.MetricFamilySamples.Sample("jvm_memory_bytes_max", Arrays.asList("area"), Arrays.asList("heap"), heapUsage.getMax()));
        maxSamples.add(new Collector.MetricFamilySamples.Sample("jvm_memory_bytes_max", Arrays.asList("area"), Arrays.asList("nonheap"), nonHeapUsage.getMax()));
        sampleFamilies.add(new Collector.MetricFamilySamples("jvm_memory_bytes_max", Collector.Type.GAUGE, "Maximum (bytes) of a given JVM memory area.", maxSamples));
    }

    void addMemoryPoolMetrics(List<Collector.MetricFamilySamples> sampleFamilies) {
        ArrayList<Collector.MetricFamilySamples.Sample> usedSamples = new ArrayList<Collector.MetricFamilySamples.Sample>();
        ArrayList<Collector.MetricFamilySamples.Sample> committedSamples = new ArrayList<Collector.MetricFamilySamples.Sample>();
        ArrayList<Collector.MetricFamilySamples.Sample> maxSamples = new ArrayList<Collector.MetricFamilySamples.Sample>();
        for (MemoryPoolMXBean pool : this.poolBeans) {
            MemoryUsage poolUsage = pool.getUsage();
            usedSamples.add(new Collector.MetricFamilySamples.Sample("jvm_memory_pool_bytes_used", Arrays.asList("pool"), Arrays.asList(pool.getName()), poolUsage.getUsed()));
            committedSamples.add(new Collector.MetricFamilySamples.Sample("jvm_memory_pool_bytes_committed", Arrays.asList("pool"), Arrays.asList(pool.getName()), poolUsage.getCommitted()));
            maxSamples.add(new Collector.MetricFamilySamples.Sample("jvm_memory_pool_bytes_max", Arrays.asList("pool"), Arrays.asList(pool.getName()), poolUsage.getMax()));
        }
        sampleFamilies.add(new Collector.MetricFamilySamples("jvm_memory_pool_bytes_used", Collector.Type.GAUGE, "Used bytes of a given JVM memory pool.", usedSamples));
        sampleFamilies.add(new Collector.MetricFamilySamples("jvm_memory_pool_bytes_committed", Collector.Type.GAUGE, "Limit (bytes) of a given JVM memory pool.", committedSamples));
        sampleFamilies.add(new Collector.MetricFamilySamples("jvm_memory_pool_bytes_max", Collector.Type.GAUGE, "Max (bytes) of a given JVM memory pool.", maxSamples));
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        this.addMemoryAreaMetrics(mfs);
        this.addMemoryPoolMetrics(mfs);
        return mfs;
    }
}

