/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.shaded.jmx_exporter.io.prometheus.jmx.shaded.io.prometheus.client.hotspot;

import io.fabric8.agent.shaded.jmx_exporter.io.prometheus.jmx.shaded.io.prometheus.client.Collector;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GarbageCollectorExports
extends Collector {
    private final List<GarbageCollectorMXBean> garbageCollectors;

    public GarbageCollectorExports() {
        this(ManagementFactory.getGarbageCollectorMXBeans());
    }

    GarbageCollectorExports(List<GarbageCollectorMXBean> garbageCollectors) {
        this.garbageCollectors = garbageCollectors;
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples.Sample> samples = new ArrayList<Collector.MetricFamilySamples.Sample>();
        for (GarbageCollectorMXBean gc : this.garbageCollectors) {
            samples.add(new Collector.MetricFamilySamples.Sample("jvm_gc_collection_seconds_sum", Arrays.asList("gc"), Arrays.asList(gc.getName()), (double)gc.getCollectionTime() / 1000.0));
            samples.add(new Collector.MetricFamilySamples.Sample("jvm_gc_collection_seconds_count", Arrays.asList("gc"), Arrays.asList(gc.getName()), gc.getCollectionCount()));
        }
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        mfs.add(new Collector.MetricFamilySamples("jvm_gc_collection_seconds", Collector.Type.SUMMARY, "Time spent in a given JVM garbage collector in seconds.", samples));
        return mfs;
    }
}

