/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.driver.observability.trace;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.baggage.propagation.W3CBaggagePropagator;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporter;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.semconv.ResourceAttributes;
import java.time.Duration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OpenTelemetryClientTracerSetup {
    private static final String SERVICE_NAME = "evitaDB-Java-Client";
    private static String TRACING_ENDPOINT_URL;
    private static String TRACING_ENDPOINT_PROTOCOL;
    private static OpenTelemetry OPEN_TELEMETRY;
    private static final String SPAN_HTTP_PROTOCOL = "HTTP";
    private static final String SPAN_GRPC_PROTOCOL = "GRPC";

    public static void setTracingEndpointUrlAndProtocol(@Nonnull String tracingEndpointUrl, @Nullable String protocol) {
        TRACING_ENDPOINT_URL = tracingEndpointUrl;
        TRACING_ENDPOINT_PROTOCOL = protocol;
    }

    @Nonnull
    private static OpenTelemetry initializeOpenTelemetry() {
        Resource resource = Resource.getDefault().toBuilder().put(ResourceAttributes.SERVICE_NAME, (Object)SERVICE_NAME).build();
        SdkTracerProvider sdkTracerProvider = SdkTracerProvider.builder().addSpanProcessor(OpenTelemetryClientTracerSetup.getSpanProcessor()).setResource(resource).build();
        return OpenTelemetrySdk.builder().setTracerProvider(sdkTracerProvider).setPropagators(ContextPropagators.create((TextMapPropagator)TextMapPropagator.composite((TextMapPropagator[])new TextMapPropagator[]{W3CTraceContextPropagator.getInstance(), W3CBaggagePropagator.getInstance()}))).buildAndRegisterGlobal();
    }

    @Nonnull
    private static SpanProcessor getSpanProcessor() {
        if (SPAN_HTTP_PROTOCOL.equalsIgnoreCase(TRACING_ENDPOINT_PROTOCOL)) {
            return BatchSpanProcessor.builder((SpanExporter)OtlpHttpSpanExporter.builder().setEndpoint(TRACING_ENDPOINT_URL).setTimeout(Duration.ofSeconds(10L)).build()).build();
        }
        return BatchSpanProcessor.builder((SpanExporter)OtlpGrpcSpanExporter.builder().setEndpoint(TRACING_ENDPOINT_URL).setTimeout(Duration.ofSeconds(10L)).build()).build();
    }

    @Nonnull
    public static OpenTelemetry getOpenTelemetry() {
        if (OPEN_TELEMETRY == null) {
            OPEN_TELEMETRY = OpenTelemetryClientTracerSetup.initializeOpenTelemetry();
        }
        return OPEN_TELEMETRY;
    }
}

