/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.system;

import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpResponseBuilder;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.file.HttpFile;
import io.evitadb.api.EvitaContract;
import io.evitadb.api.observability.ReadinessState;
import io.evitadb.api.requestResponse.system.SystemStatus;
import io.evitadb.core.Evita;
import io.evitadb.exception.GenericEvitaInternalError;
import io.evitadb.externalApi.api.system.ProbesProvider;
import io.evitadb.externalApi.configuration.AbstractApiOptions;
import io.evitadb.externalApi.configuration.ApiOptions;
import io.evitadb.externalApi.configuration.CertificateOptions;
import io.evitadb.externalApi.configuration.CertificatePath;
import io.evitadb.externalApi.event.ReadinessEvent;
import io.evitadb.externalApi.http.CorsService;
import io.evitadb.externalApi.http.ExternalApiProvider;
import io.evitadb.externalApi.http.ExternalApiProviderRegistrar;
import io.evitadb.externalApi.http.ExternalApiServer;
import io.evitadb.externalApi.system.SystemProvider;
import io.evitadb.externalApi.system.configuration.SystemOptions;
import io.evitadb.externalApi.utils.path.RoutingHandlerService;
import io.evitadb.utils.CertificateUtils;
import io.evitadb.utils.StringUtils;
import java.io.File;
import java.time.Duration;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class SystemProviderRegistrar
implements ExternalApiProviderRegistrar<SystemOptions> {
    public static final String ENDPOINT_SERVER_NAME = "server-name";
    public static final String ENDPOINT_SYSTEM_STATUS = "status";
    public static final String ENDPOINT_SYSTEM_LIVENESS = "liveness";
    public static final String ENDPOINT_SYSTEM_READINESS = "readiness";

    private static HttpResponse printApiStatus(@Nonnull HttpResponseBuilder builder, @Nonnull ProbesProvider.Readiness readiness) {
        return builder.content(MediaType.JSON, "{\n\t\"status\": \"" + readiness.state().name() + "\",\n\t\"apis\": {\n" + Arrays.stream(readiness.apiStates()).sorted(Comparator.comparing(ProbesProvider.ApiState::apiCode)).map(entry -> "\t\t\"" + entry.apiCode() + "\": \"" + (entry.isReady() ? "ready" : "not ready") + "\"").collect(Collectors.joining(",\n")) + "\n\t}\n}").build();
    }

    private static HttpResponse renderUnavailable() {
        return HttpResponse.of((HttpStatus)HttpStatus.SERVICE_UNAVAILABLE, (MediaType)MediaType.JSON, (String)("{\"status\": \"" + ReadinessState.SHUTDOWN.name() + "\"}"));
    }

    private static CompletableFuture<HttpResponse> renderStatus(@Nonnull Evita evita, @Nonnull ExternalApiServer externalApiServer, @Nonnull ApiOptions apiOptions, @Nonnull String[] enabledEndPoints) {
        return evita.executeAsyncInRequestThreadPool(() -> {
            if (evita.isActive()) {
                HttpResponseBuilder builder = HttpResponse.builder();
                builder.status(HttpStatus.OK);
                Set healthProblems = externalApiServer.getProbeProviders().stream().flatMap(it -> it.getHealthProblems((EvitaContract)evita, externalApiServer, enabledEndPoints).stream()).collect(Collectors.toSet());
                SystemStatus systemStatus = evita.management().getSystemStatus();
                return builder.content(MediaType.JSON, String.format("{\n   \"serverName\": \"%s\",\n   \"version\": \"%s\",\n   \"startedAt\": \"%s\",\n   \"uptime\": %d,\n   \"uptimeForHuman\": \"%s\",\n   \"catalogsCorrupted\": %d,\n   \"catalogsOk\": %d,\n   \"healthProblems\": [%s],\n   \"apis\": [\n%s\n   ]\n}", evita.getConfiguration().name(), systemStatus.version(), DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(systemStatus.startedAt()), systemStatus.uptime().toSeconds(), StringUtils.formatDuration((Duration)systemStatus.uptime()), systemStatus.catalogsCorrupted(), systemStatus.catalogsOk(), healthProblems.stream().sorted().map(it -> "\"" + it.name() + "\"").collect(Collectors.joining(", ")), apiOptions.endpoints().entrySet().stream().filter(entry -> Arrays.stream(enabledEndPoints).anyMatch(it -> it.equals(entry.getKey()))).sorted(Map.Entry.comparingByKey()).map(entry -> "      {\n         \"" + (String)entry.getKey() + "\": [\n" + Arrays.stream(((AbstractApiOptions)entry.getValue()).getBaseUrls()).map(it -> "            \"" + it + "\"").collect(Collectors.joining(",\n")) + "\n         ]\n      }").collect(Collectors.joining(",\n")))).build();
            }
            return SystemProviderRegistrar.renderUnavailable();
        });
    }

    private static CompletableFuture<HttpResponse> renderReadinessResponse(@Nonnull Evita evita, @Nonnull ExternalApiServer externalApiServer, @Nonnull String[] enabledEndPoints) {
        return evita.executeAsyncInRequestThreadPool(() -> {
            HttpResponseBuilder builder = HttpResponse.builder();
            if (evita.isActive()) {
                Optional<ProbesProvider.Readiness> readiness = externalApiServer.getProbeProviders().stream().map(it -> it.getReadiness((EvitaContract)evita, externalApiServer, enabledEndPoints)).findFirst();
                if (readiness.map(it -> it.state() == ReadinessState.READY).orElse(false).booleanValue()) {
                    builder.status(HttpStatus.OK);
                    return SystemProviderRegistrar.printApiStatus(builder, readiness.get());
                }
                if (readiness.isPresent()) {
                    builder.status(HttpStatus.SERVICE_UNAVAILABLE);
                    return SystemProviderRegistrar.printApiStatus(builder, readiness.get());
                }
                builder.status(HttpStatus.SERVICE_UNAVAILABLE);
                return builder.content(MediaType.JSON, "{\"status\": \"" + ReadinessState.UNKNOWN.name() + "\"}").build();
            }
            return SystemProviderRegistrar.renderUnavailable();
        });
    }

    private static CompletableFuture<HttpResponse> renderLivenessResponse(@Nonnull Evita evita, @Nonnull ExternalApiServer externalApiServer, @Nonnull String[] enabledEndPoints) {
        return evita.executeAsyncInRequestThreadPool(() -> {
            if (evita.isActive()) {
                Set healthProblems = externalApiServer.getProbeProviders().stream().flatMap(it -> it.getHealthProblems((EvitaContract)evita, externalApiServer, enabledEndPoints).stream()).collect(Collectors.toSet());
                if (healthProblems.isEmpty()) {
                    return HttpResponse.of((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON, (String)"{\"status\": \"healthy\"}");
                }
                return HttpResponse.of((HttpStatus)HttpStatus.SERVICE_UNAVAILABLE, (MediaType)MediaType.JSON, (String)("{\"status\": \"unhealthy\", \"problems\": [" + healthProblems.stream().sorted().map(it -> "\"" + it.name() + "\"").collect(Collectors.joining(", ")) + "]}"));
            }
            return SystemProviderRegistrar.renderUnavailable();
        });
    }

    @Nonnull
    public String getExternalApiCode() {
        return "system";
    }

    @Nonnull
    public Class<SystemOptions> getConfigurationClass() {
        return SystemOptions.class;
    }

    @Nonnull
    public ExternalApiProvider<SystemOptions> register(@Nonnull Evita evita, @Nonnull ExternalApiServer externalApiServer, @Nonnull ApiOptions apiOptions, @Nonnull SystemOptions systemConfig) {
        RoutingHandlerService router = new RoutingHandlerService();
        router.add(HttpMethod.GET, "/server-name", SystemProviderRegistrar.createCorsWrapper((ctx, req) -> {
            new ReadinessEvent("system", ReadinessEvent.Prospective.SERVER).finish(ReadinessEvent.Result.READY);
            return HttpResponse.of((HttpStatus)HttpStatus.OK, (MediaType)MediaType.PLAIN_TEXT, (String)evita.getConfiguration().name());
        }));
        String[] enabledEndPoints = apiOptions.getEnabledApiEndpoints();
        router.add(HttpMethod.GET, "/status", SystemProviderRegistrar.createCorsWrapper((ctx, req) -> HttpResponse.of(SystemProviderRegistrar.renderStatus(evita, externalApiServer, apiOptions, enabledEndPoints))));
        router.add(HttpMethod.GET, "/liveness", SystemProviderRegistrar.createCorsWrapper((ctx, req) -> HttpResponse.of(SystemProviderRegistrar.renderLivenessResponse(evita, externalApiServer, enabledEndPoints))));
        router.add(HttpMethod.GET, "/readiness", SystemProviderRegistrar.createCorsWrapper((ctx, req) -> HttpResponse.of(SystemProviderRegistrar.renderReadinessResponse(evita, externalApiServer, enabledEndPoints))));
        CertificateOptions certificateSettings = apiOptions.certificate();
        boolean atLeastOnEndpointRequiresTls = apiOptions.atLeastOneEndpointRequiresTls();
        if (atLeastOnEndpointRequiresTls) {
            String fileName;
            File file;
            if (certificateSettings.generateAndUseSelfSigned()) {
                file = apiOptions.certificate().getFolderPath().toFile();
                fileName = CertificateUtils.getGeneratedServerCertificateFileName();
            } else {
                CertificatePath certificatePath = certificateSettings.custom();
                if (certificatePath == null || certificatePath.certificate() == null || certificatePath.privateKey() == null) {
                    throw new GenericEvitaInternalError("Certificate path is not properly set in the configuration file and `generateAndUseSelfSigned` is set to false.");
                }
                String certificate = certificatePath.certificate();
                int lastSeparatorIndex = certificatePath.certificate().lastIndexOf(File.separator);
                file = new File(certificate.substring(0, lastSeparatorIndex));
                fileName = certificate.substring(lastSeparatorIndex);
            }
            router.add(HttpMethod.GET, "/" + fileName, SystemProviderRegistrar.createCorsWrapper((ctx, req) -> {
                ctx.addAdditionalResponseHeader((CharSequence)HttpHeaderNames.CONTENT_DISPOSITION, (Object)("attachment; filename=\"" + fileName + "\""));
                return HttpFile.of((File)new File(file, fileName)).asService().serve(ctx, req);
            }));
            router.add(HttpMethod.GET, "/" + CertificateUtils.getGeneratedClientCertificateFileName(), SystemProviderRegistrar.createCorsWrapper((ctx, req) -> {
                ctx.addAdditionalResponseHeader((CharSequence)HttpHeaderNames.CONTENT_DISPOSITION, (Object)("attachment; filename=\"" + CertificateUtils.getGeneratedClientCertificateFileName() + "\""));
                return HttpFile.of((File)new File(file, CertificateUtils.getGeneratedClientCertificateFileName())).asService().serve(ctx, req);
            }));
            router.add(HttpMethod.GET, "/" + CertificateUtils.getGeneratedClientCertificatePrivateKeyFileName(), SystemProviderRegistrar.createCorsWrapper((ctx, req) -> {
                ctx.addAdditionalResponseHeader((CharSequence)HttpHeaderNames.CONTENT_DISPOSITION, (Object)("attachment; filename=\"" + CertificateUtils.getGeneratedClientCertificatePrivateKeyFileName() + "\""));
                return HttpFile.of((File)new File(file, CertificateUtils.getGeneratedClientCertificatePrivateKeyFileName())).asService().serve(ctx, req);
            }));
        } else {
            Object fileName = null;
        }
        boolean atLeastOnEndpointRequiresMtls = apiOptions.atLeastOnEndpointRequiresMtls();
        LinkedHashMap<String, String[]> endpoints = new LinkedHashMap<String, String[]>(16);
        endpoints.put("serverNameUrl", (String[])Arrays.stream(systemConfig.getBaseUrls()).map(it -> it + ENDPOINT_SERVER_NAME).toArray(String[]::new));
        if (certificateSettings.generateAndUseSelfSigned() && atLeastOnEndpointRequiresTls) {
            endpoints.put("serverCertificateUrl", (String[])Arrays.stream(systemConfig.getBaseUrls()).map(it -> it + CertificateUtils.getGeneratedServerCertificateFileName()).toArray(String[]::new));
        }
        if (certificateSettings.generateAndUseSelfSigned() && atLeastOnEndpointRequiresMtls) {
            endpoints.put("clientCertificateUrl", (String[])Arrays.stream(systemConfig.getBaseUrls()).map(it -> it + CertificateUtils.getGeneratedClientCertificateFileName()).toArray(String[]::new));
            endpoints.put("clientPrivateKeyUrl", (String[])Arrays.stream(systemConfig.getBaseUrls()).map(it -> it + CertificateUtils.getGeneratedClientCertificatePrivateKeyFileName()).toArray(String[]::new));
        }
        return new SystemProvider(systemConfig, (HttpService)router, endpoints, apiOptions.requestTimeoutInMillis());
    }

    @Nonnull
    private static HttpService createCorsWrapper(@Nonnull HttpService delegate) {
        return CorsService.filter((HttpService)delegate, Set.of(HttpMethod.GET), Set.of());
    }
}

