/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.system;

import com.linecorp.armeria.server.HttpService;
import io.evitadb.externalApi.event.ReadinessEvent;
import io.evitadb.externalApi.http.ExternalApiProvider;
import io.evitadb.externalApi.http.ExternalApiProviderWithConsoleOutput;
import io.evitadb.externalApi.system.configuration.SystemOptions;
import io.evitadb.utils.ArrayUtils;
import io.evitadb.utils.ConsoleWriter;
import io.evitadb.utils.NetworkUtils;
import io.evitadb.utils.StringUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemProvider
implements ExternalApiProviderWithConsoleOutput<SystemOptions> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SystemProvider.class);
    public static final String CODE = "system";
    public static final String SERVER_CERTIFICATE_URL = "serverCertificateUrl";
    public static final String CLIENT_CERTIFICATE_URL = "clientCertificateUrl";
    public static final String CLIENT_PRIVATE_KEY_URL = "clientPrivateKeyUrl";
    public static final String SERVER_NAME_URL = "serverNameUrl";
    @Nonnull
    private final SystemOptions configuration;
    @Nonnull
    private final HttpService apiHandler;
    @Nonnull
    private final LinkedHashMap<String, String[]> endpoints;
    private final long requestTimeout;
    private String reachableUrl;

    public SystemProvider(@Nonnull SystemOptions configuration, @Nonnull HttpService apiHandler, @Nonnull LinkedHashMap<String, String[]> endpoints, long requestTimeoutInMillis) {
        this.configuration = configuration;
        this.apiHandler = apiHandler;
        this.endpoints = endpoints;
        this.requestTimeout = requestTimeoutInMillis;
    }

    @Nonnull
    public String getCode() {
        return CODE;
    }

    @Nonnull
    public ExternalApiProvider.HttpServiceDefinition[] getHttpServiceDefinitions() {
        return new ExternalApiProvider.HttpServiceDefinition[]{new ExternalApiProvider.HttpServiceDefinition(this.apiHandler, ExternalApiProvider.PathHandlingMode.DYNAMIC_PATH_HANDLING)};
    }

    public boolean isReady() {
        Predicate<String> isReady = url -> {
            ReadinessEvent readinessEvent = new ReadinessEvent(CODE, ReadinessEvent.Prospective.CLIENT);
            boolean reachable = NetworkUtils.isReachable((String)url, (long)this.requestTimeout, error -> {
                log.error("Error while checking readiness of System API: {}", error);
                readinessEvent.finish(ReadinessEvent.Result.ERROR);
            }, timeouted -> {
                log.error("{}", timeouted);
                readinessEvent.finish(ReadinessEvent.Result.TIMEOUT);
            });
            if (reachable) {
                readinessEvent.finish(ReadinessEvent.Result.READY);
            }
            return reachable;
        };
        String[] baseUrls = this.configuration.getBaseUrls();
        if (this.reachableUrl == null) {
            for (String baseUrl : baseUrls) {
                String nameUrl = baseUrl + "server-name";
                if (!isReady.test(nameUrl)) continue;
                this.reachableUrl = nameUrl;
                return true;
            }
            return false;
        }
        return isReady.test(this.reachableUrl);
    }

    @Nonnull
    public Map<String, String[]> getKeyEndPoints() {
        return this.endpoints;
    }

    public void writeToConsole() {
        this.writeLine("   - server name served at: ", SERVER_NAME_URL);
        this.writeLine("   - server certificate served at: ", SERVER_CERTIFICATE_URL);
        this.writeLine("   - client certificate served at: ", CLIENT_CERTIFICATE_URL);
        this.writeLine("   - client private key served at: ", CLIENT_PRIVATE_KEY_URL);
        if (!ArrayUtils.isEmpty((Object[])this.endpoints.get(CLIENT_CERTIFICATE_URL))) {
            ConsoleWriter.write((String)"\n************************* WARNING!!! *************************\nYou use mTLS with automatically generated client certificate.\nThis is not safe for production environments!\nSupply the certificate for production manually and set `useGeneratedCertificate` to false.\n************************* WARNING!!! *************************\n\n", (ConsoleWriter.ConsoleColor)ConsoleWriter.ConsoleColor.BRIGHT_RED, (ConsoleWriter.ConsoleDecoration[])new ConsoleWriter.ConsoleDecoration[]{ConsoleWriter.ConsoleDecoration.BOLD});
        }
    }

    private void writeLine(@Nonnull String label, @Nonnull String endpointKey) {
        Object[] urls = this.endpoints.get(endpointKey);
        if (!ArrayUtils.isEmpty((Object[])urls)) {
            ConsoleWriter.write((String)StringUtils.rightPad((String)label, (String)" ", (int)40));
            for (int i = 0; i < urls.length; ++i) {
                Object serverNameUrl = urls[i];
                if (i > 0) {
                    ConsoleWriter.write((String)", ", (ConsoleWriter.ConsoleColor)ConsoleWriter.ConsoleColor.WHITE);
                }
                ConsoleWriter.write((String)serverNameUrl, (ConsoleWriter.ConsoleColor)ConsoleWriter.ConsoleColor.DARK_BLUE, (ConsoleWriter.ConsoleDecoration[])new ConsoleWriter.ConsoleDecoration[]{ConsoleWriter.ConsoleDecoration.UNDERLINE});
            }
            ConsoleWriter.write((String)"\n", (ConsoleWriter.ConsoleColor)ConsoleWriter.ConsoleColor.WHITE);
        }
    }

    @Nonnull
    @Generated
    public SystemOptions getConfiguration() {
        return this.configuration;
    }

    @Nonnull
    @Generated
    public HttpService getApiHandler() {
        return this.apiHandler;
    }
}

