/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.metric.event.request;

import graphql.language.OperationDefinition;
import io.evitadb.api.configuration.metric.MetricType;
import io.evitadb.api.observability.annotation.ExportDurationMetric;
import io.evitadb.api.observability.annotation.ExportInvocationMetric;
import io.evitadb.api.observability.annotation.ExportMetric;
import io.evitadb.api.observability.annotation.ExportMetricLabel;
import io.evitadb.api.observability.annotation.HistogramSettings;
import io.evitadb.externalApi.graphql.exception.GraphQLInternalError;
import io.evitadb.externalApi.graphql.io.GraphQLInstanceType;
import io.evitadb.externalApi.graphql.metric.event.request.AbstractGraphQLRequestEvent;
import io.evitadb.utils.Assert;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jdk.jfr.Description;
import jdk.jfr.Label;
import jdk.jfr.Name;
import lombok.Generated;

@Name(value="io.evitadb.externalApi.graphql.request.Executed")
@Description(value="Event that is fired when a GraphQL request is executed.")
@ExportInvocationMetric(label="GraphQL request executed total")
@ExportDurationMetric(label="GraphQL request execution duration")
@Label(value="GraphQL request executed")
public class ExecutedEvent
extends AbstractGraphQLRequestEvent {
    @Label(value="GraphQL operation type")
    @Description(value="The type of operation specified in the GQL request: QUERY, MUTATION, or SUBSCRIPTION.")
    @ExportMetricLabel
    @Nullable
    String graphQLOperationType;
    @Label(value="Catalog")
    @Name(value="catalogName")
    @Description(value="The name of the catalog to which this event/metric is associated.")
    @ExportMetricLabel
    @Nullable
    String catalogName;
    @Label(value="GraphQL operation")
    @Description(value="The name of the operation specified in the GQL request.")
    @ExportMetricLabel
    @Nullable
    String operationName;
    @Label(value="Response status")
    @Description(value="The status of the response: OK or ERROR.")
    @Name(value="responseStatus")
    @ExportMetricLabel
    @Nonnull
    String responseStatus = ResponseStatus.OK.name();
    @Label(value="Input deserialization duration")
    @Description(value="Time to deserialize the incoming JSON input GraphQL request to internal structure in milliseconds.")
    @ExportMetric(metricType=MetricType.HISTOGRAM)
    @HistogramSettings(factor=1.9)
    private long inputDeserializationDurationMilliseconds;
    private final long processStarted;
    @Label(value="Request preparation duration")
    @Description(value="Time to prepare and initialize the GraphQL server engine for parsing and executing the incoming request in milliseconds.")
    @ExportMetric(metricType=MetricType.HISTOGRAM)
    @HistogramSettings(factor=1.9)
    private long preparationDurationMilliseconds;
    private long preparationStarted;
    @Label(value="Request parsing duration")
    @Description(value="Time to parse the GraphQL request (query and variables) by the GraphQL server engine from internal structure for validation and execution in milliseconds.")
    @ExportMetric(metricType=MetricType.HISTOGRAM)
    @HistogramSettings(factor=1.9)
    private long parseDurationMilliseconds;
    private long parseStarted;
    @Label(value="Validation duration")
    @Description(value="Time to validate the parsed request (query and variables) by the GraphQL server engine before execution in milliseconds.")
    @ExportMetric(metricType=MetricType.HISTOGRAM)
    @HistogramSettings(factor=1.9)
    private long validationDurationMilliseconds;
    private long validationStarted;
    @Label(value="Execution duration")
    @Description(value="Time to execute the entire parsed and validated GraphQL operation by the GraphQL server engine in milliseconds. Includes all data fetcher business logic, including evitaDB input reconstruction and evitaDB query execution.")
    @ExportMetric(metricType=MetricType.HISTOGRAM)
    @HistogramSettings(factor=1.9)
    private long operationExecutionDurationMilliseconds;
    private long operationExecutionStarted;
    @Label(value="evitaDB input reconstruction duration")
    @Description(value="Time to reconstruct query input into evitaDB engine in milliseconds. Usually converts JSON query into internal evitaDB query representation or JSON mutations into internal evitaDB mutation representation.")
    @ExportMetric(metricType=MetricType.HISTOGRAM)
    @HistogramSettings(factor=1.9)
    private long internalEvitadbInputReconstructionDurationMilliseconds;
    private long internalEvitadbExecutionDurationMilliseconds;
    @Label(value="Result serializatio duration")
    @Description(value="Time to serialize the final request result into output JSON in milliseconds.")
    @ExportMetric(metricType=MetricType.HISTOGRAM)
    @HistogramSettings(factor=1.9)
    private long resultSerializationDurationMilliseconds;
    private long resultSerializationStarted;
    private long executionDurationMilliseconds;
    @Label(value="Request execution overhead")
    @Description(value="Time to execute the entire request in milliseconds without internal evitaDB execution.")
    @ExportMetric(metricType=MetricType.HISTOGRAM)
    @HistogramSettings(factor=1.9)
    private long executionApiOverheadDurationMilliseconds;
    @Label(value="Request root fields count")
    @Description(value="Number of root fields (queries, mutations) processed within a single GraphQL request.")
    @ExportMetric(metricType=MetricType.GAUGE)
    private int rootFieldsProcessed;

    public ExecutedEvent(@Nonnull GraphQLInstanceType instanceType) {
        super(instanceType);
        this.begin();
        this.processStarted = System.currentTimeMillis();
    }

    @Nonnull
    public ExecutedEvent provideOperationType(@Nonnull OperationDefinition.Operation operationType) {
        Assert.isPremiseValid((this.graphQLOperationType == null ? 1 : 0) != 0, () -> new GraphQLInternalError("Operation type is already set."));
        this.graphQLOperationType = operationType.toString();
        return this;
    }

    @Nonnull
    public ExecutedEvent provideCatalogName(@Nonnull String catalogName) {
        Assert.isPremiseValid((this.catalogName == null ? 1 : 0) != 0, () -> new GraphQLInternalError("Catalog name is already set."));
        this.catalogName = catalogName;
        return this;
    }

    @Nonnull
    public ExecutedEvent provideOperationName(@Nonnull String operationName) {
        this.operationName = operationName;
        return this;
    }

    @Nonnull
    public ExecutedEvent provideResponseStatus(@Nonnull ResponseStatus responseStatus) {
        this.responseStatus = responseStatus.toString();
        return this;
    }

    @Nonnull
    public ExecutedEvent provideRootFieldsProcessed(int rootFieldsProcessed) {
        this.rootFieldsProcessed = rootFieldsProcessed;
        return this;
    }

    @Nonnull
    public ExecutedEvent finishInputDeserialization() {
        Assert.isPremiseValid((this.processStarted != 0L ? 1 : 0) != 0, () -> new GraphQLInternalError("Process didn't started. Cannot measure input deserialization duration."));
        long now = System.currentTimeMillis();
        this.inputDeserializationDurationMilliseconds = now - this.processStarted;
        this.preparationStarted = now;
        return this;
    }

    @Nonnull
    public ExecutedEvent finishPreparation() {
        Assert.isPremiseValid((this.preparationStarted != 0L ? 1 : 0) != 0, () -> new GraphQLInternalError("Preparation didn't started. Cannot measure preparation duration."));
        long now = System.currentTimeMillis();
        this.preparationDurationMilliseconds = now - this.preparationStarted;
        this.parseStarted = now;
        return this;
    }

    @Nonnull
    public ExecutedEvent finishParse() {
        Assert.isPremiseValid((this.parseStarted != 0L ? 1 : 0) != 0, () -> new GraphQLInternalError("Parse didn't started. Cannot measure parse duration."));
        long now = System.currentTimeMillis();
        this.parseDurationMilliseconds = now - this.parseStarted;
        this.validationStarted = now;
        return this;
    }

    @Nonnull
    public ExecutedEvent finishValidation() {
        Assert.isPremiseValid((this.validationStarted != 0L ? 1 : 0) != 0, () -> new GraphQLInternalError("Validation didn't started. Cannot measure validation duration."));
        long now = System.currentTimeMillis();
        this.validationDurationMilliseconds = now - this.validationStarted;
        this.operationExecutionStarted = now;
        return this;
    }

    public <T> T measureInternalEvitaDBInputReconstruction(@Nonnull Supplier<T> supplier) {
        long started = System.currentTimeMillis();
        T result = supplier.get();
        this.internalEvitadbInputReconstructionDurationMilliseconds += System.currentTimeMillis() - started;
        return result;
    }

    public <T> T measureInternalEvitaDBExecution(@Nonnull Supplier<T> supplier) {
        long started = System.currentTimeMillis();
        T result = supplier.get();
        this.internalEvitadbExecutionDurationMilliseconds += System.currentTimeMillis() - started;
        return result;
    }

    @Nonnull
    public ExecutedEvent finishOperationExecution() {
        long now = System.currentTimeMillis();
        this.operationExecutionDurationMilliseconds = now - this.operationExecutionStarted;
        this.resultSerializationStarted = now;
        return this;
    }

    @Nonnull
    public ExecutedEvent finishResultSerialization() {
        this.resultSerializationDurationMilliseconds = System.currentTimeMillis() - this.resultSerializationStarted;
        return this;
    }

    @Nonnull
    public ExecutedEvent finish() {
        this.end();
        Assert.isPremiseValid((this.processStarted != 0L ? 1 : 0) != 0, () -> new GraphQLInternalError("Process didn't started. Cannot measure execution duration duration."));
        if (this.operationExecutionStarted > 0L && this.operationExecutionDurationMilliseconds == 0L) {
            this.finishOperationExecution();
        }
        this.executionDurationMilliseconds = System.currentTimeMillis() - this.processStarted;
        this.executionApiOverheadDurationMilliseconds = this.executionDurationMilliseconds - this.internalEvitadbExecutionDurationMilliseconds;
        return this;
    }

    @Nullable
    @Generated
    public String getGraphQLOperationType() {
        return this.graphQLOperationType;
    }

    @Nullable
    @Generated
    public String getCatalogName() {
        return this.catalogName;
    }

    @Nullable
    @Generated
    public String getOperationName() {
        return this.operationName;
    }

    @Nonnull
    @Generated
    public String getResponseStatus() {
        return this.responseStatus;
    }

    @Generated
    public long getInputDeserializationDurationMilliseconds() {
        return this.inputDeserializationDurationMilliseconds;
    }

    @Generated
    public long getProcessStarted() {
        return this.processStarted;
    }

    @Generated
    public long getPreparationDurationMilliseconds() {
        return this.preparationDurationMilliseconds;
    }

    @Generated
    public long getPreparationStarted() {
        return this.preparationStarted;
    }

    @Generated
    public long getParseDurationMilliseconds() {
        return this.parseDurationMilliseconds;
    }

    @Generated
    public long getParseStarted() {
        return this.parseStarted;
    }

    @Generated
    public long getValidationDurationMilliseconds() {
        return this.validationDurationMilliseconds;
    }

    @Generated
    public long getValidationStarted() {
        return this.validationStarted;
    }

    @Generated
    public long getOperationExecutionDurationMilliseconds() {
        return this.operationExecutionDurationMilliseconds;
    }

    @Generated
    public long getOperationExecutionStarted() {
        return this.operationExecutionStarted;
    }

    @Generated
    public long getInternalEvitadbInputReconstructionDurationMilliseconds() {
        return this.internalEvitadbInputReconstructionDurationMilliseconds;
    }

    @Generated
    public long getInternalEvitadbExecutionDurationMilliseconds() {
        return this.internalEvitadbExecutionDurationMilliseconds;
    }

    @Generated
    public long getResultSerializationDurationMilliseconds() {
        return this.resultSerializationDurationMilliseconds;
    }

    @Generated
    public long getResultSerializationStarted() {
        return this.resultSerializationStarted;
    }

    @Generated
    public long getExecutionDurationMilliseconds() {
        return this.executionDurationMilliseconds;
    }

    @Generated
    public long getExecutionApiOverheadDurationMilliseconds() {
        return this.executionApiOverheadDurationMilliseconds;
    }

    @Generated
    public int getRootFieldsProcessed() {
        return this.rootFieldsProcessed;
    }

    public static enum ResponseStatus {
        OK,
        ERROR;

    }
}

