/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.model;

import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import io.evitadb.externalApi.api.model.ObjectPropertyDataTypeDescriptor;
import io.evitadb.externalApi.api.model.PrimitivePropertyDataTypeDescriptor;
import io.evitadb.externalApi.api.model.PropertyDataTypeDescriptor;
import io.evitadb.externalApi.api.model.PropertyDataTypeDescriptorTransformer;
import io.evitadb.externalApi.graphql.api.builder.GraphQLSchemaBuildingContext;
import io.evitadb.externalApi.graphql.api.dataType.DataTypesConverter;
import io.evitadb.externalApi.graphql.exception.GraphQLSchemaBuildingError;
import javax.annotation.Nonnull;
import lombok.Generated;

public class PropertyDataTypeDescriptorToGraphQLTypeTransformer
implements PropertyDataTypeDescriptorTransformer<GraphQLType> {
    @Nonnull
    private final GraphQLSchemaBuildingContext graphQLSchemaBuildingContext;

    public GraphQLType apply(@Nonnull PropertyDataTypeDescriptor typeDescriptor) {
        if (typeDescriptor instanceof PrimitivePropertyDataTypeDescriptor) {
            PrimitivePropertyDataTypeDescriptor primitiveType = (PrimitivePropertyDataTypeDescriptor)typeDescriptor;
            if (primitiveType.javaType().isEnum() || primitiveType.javaType().isArray() && ((Class)primitiveType.javaType().componentType()).isEnum()) {
                DataTypesConverter.ConvertedEnum enumType = DataTypesConverter.getGraphQLEnumType(primitiveType.javaType(), primitiveType.nonNull());
                this.graphQLSchemaBuildingContext.registerCustomEnumIfAbsent(enumType.enumType());
                return enumType.resultType();
            }
            return DataTypesConverter.getGraphQLScalarType(primitiveType.javaType(), primitiveType.nonNull());
        }
        if (typeDescriptor instanceof ObjectPropertyDataTypeDescriptor) {
            ObjectPropertyDataTypeDescriptor objectType = (ObjectPropertyDataTypeDescriptor)typeDescriptor;
            GraphQLTypeReference graphQLType = GraphQLTypeReference.typeRef((String)objectType.objectReference().name());
            if (objectType.list()) {
                graphQLType = GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)graphQLType));
            }
            if (objectType.nonNull()) {
                graphQLType = GraphQLNonNull.nonNull((GraphQLType)graphQLType);
            }
            return graphQLType;
        }
        throw new GraphQLSchemaBuildingError("Unsupported property data type `" + typeDescriptor.getClass().getName() + "`.");
    }

    @Generated
    public PropertyDataTypeDescriptorToGraphQLTypeTransformer(@Nonnull GraphQLSchemaBuildingContext graphQLSchemaBuildingContext) {
        if (graphQLSchemaBuildingContext == null) {
            throw new NullPointerException("graphQLSchemaBuildingContext is marked non-null but is null");
        }
        this.graphQLSchemaBuildingContext = graphQLSchemaBuildingContext;
    }

    @Nonnull
    @Generated
    protected GraphQLSchemaBuildingContext getGraphQLSchemaBuildingContext() {
        return this.graphQLSchemaBuildingContext;
    }
}

