/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.entity;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.evitadb.api.requestResponse.data.AttributesContract;
import io.evitadb.api.requestResponse.schema.AttributeSchemaContract;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.EntityQueryContext;
import io.evitadb.externalApi.graphql.exception.GraphQLInvalidArgumentException;
import java.io.Serializable;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class AttributeValueDataFetcher<T extends Serializable>
implements DataFetcher<T> {
    @Nonnull
    private final AttributeSchemaContract attributeSchema;

    @Nullable
    public T get(DataFetchingEnvironment environment) throws Exception {
        AttributesContract attributes = (AttributesContract)environment.getSource();
        Locale locale = ((EntityQueryContext)environment.getLocalContext()).getDesiredLocale();
        if (locale == null && this.attributeSchema.isLocalized()) {
            throw new GraphQLInvalidArgumentException("Attribute `" + this.attributeSchema.getName() + "` is localized, yet no locale for attributes was specified.");
        }
        if (locale == null) {
            return (T)((Serializable)attributes.getAttributeValue(this.attributeSchema.getName()).map(a -> a.value()).orElse(null));
        }
        return (T)((Serializable)attributes.getAttributeValue(this.attributeSchema.getName(), locale).map(a -> a.value()).orElse(null));
    }

    @Generated
    public AttributeValueDataFetcher(@Nonnull AttributeSchemaContract attributeSchema) {
        if (attributeSchema == null) {
            throw new NullPointerException("attributeSchema is marked non-null but is null");
        }
        this.attributeSchema = attributeSchema;
    }
}

