/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.builder;

import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLObjectType;
import io.evitadb.api.CatalogContract;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.externalApi.graphql.api.catalog.builder.CatalogGraphQLSchemaBuildingContext;
import io.evitadb.externalApi.graphql.exception.GraphQLSchemaBuildingError;
import io.evitadb.utils.Assert;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.Generated;

public class CollectionGraphQLSchemaBuildingContext {
    @Nonnull
    private final CatalogGraphQLSchemaBuildingContext catalogCtx;
    @Nonnull
    private final EntitySchemaContract schema;
    private GraphQLInputType headInputObject;
    private GraphQLInputType filterByInputObject;
    private GraphQLInputType orderByInputObject;
    private GraphQLInputType listRequireInputObject;
    private GraphQLInputType queryRequireInputObject;

    @Nonnull
    public CatalogContract getCatalog() {
        return this.catalogCtx.getCatalog();
    }

    public void registerEntityObject(@Nonnull GraphQLObjectType entityObject) {
        this.catalogCtx.registerEntityObject(this.schema.getName(), entityObject);
    }

    public void setHeadInputObject(@Nonnull GraphQLInputType headInputObject) {
        Assert.isPremiseValid((this.headInputObject == null ? 1 : 0) != 0, () -> new GraphQLSchemaBuildingError("Head input object for schema `" + this.schema.getName() + "` has been already initialized."));
        this.headInputObject = headInputObject;
    }

    public void setFilterByInputObject(@Nonnull GraphQLInputType filterByInputObject) {
        Assert.isPremiseValid((this.filterByInputObject == null ? 1 : 0) != 0, () -> new GraphQLSchemaBuildingError("FilterBy input object for schema `" + this.schema.getName() + "` has been already initialized."));
        this.filterByInputObject = filterByInputObject;
    }

    @Nonnull
    public GraphQLInputType getFilterByInputObject() {
        return Optional.ofNullable(this.filterByInputObject).orElseThrow(() -> new GraphQLSchemaBuildingError("FilterBy input object for schema `" + this.schema.getName() + "` has not been initialized yet."));
    }

    public void setOrderByInputObject(@Nonnull GraphQLInputType orderByInputObject) {
        Assert.isPremiseValid((this.orderByInputObject == null ? 1 : 0) != 0, () -> new GraphQLSchemaBuildingError("OrderBy input object for schema `" + this.schema.getName() + "` has been already initialized."));
        this.orderByInputObject = orderByInputObject;
    }

    @Nonnull
    public GraphQLInputType getOrderByInputObject() {
        return Optional.ofNullable(this.orderByInputObject).orElseThrow(() -> new GraphQLSchemaBuildingError("OrderBy input object for schema `" + this.schema.getName() + "` has not been initialized yet."));
    }

    public void setListRequireInputObject(@Nonnull GraphQLInputType listRequireInputObject) {
        Assert.isPremiseValid((this.listRequireInputObject == null ? 1 : 0) != 0, () -> new GraphQLSchemaBuildingError("List require input object for schema `" + this.schema.getName() + "` has been already initialized."));
        this.listRequireInputObject = listRequireInputObject;
    }

    @Nonnull
    public Optional<GraphQLInputType> getListRequireInputObject() {
        return Optional.ofNullable(this.listRequireInputObject);
    }

    public void setQueryRequireInputObject(@Nonnull GraphQLInputType queryRequireInputObject) {
        Assert.isPremiseValid((this.queryRequireInputObject == null ? 1 : 0) != 0, () -> new GraphQLSchemaBuildingError("Query require input object for schema `" + this.schema.getName() + "` has been already initialized."));
        this.queryRequireInputObject = queryRequireInputObject;
    }

    @Nonnull
    public Optional<GraphQLInputType> getQueryRequireInputObject() {
        return Optional.ofNullable(this.queryRequireInputObject);
    }

    @Generated
    public CollectionGraphQLSchemaBuildingContext(@Nonnull CatalogGraphQLSchemaBuildingContext catalogCtx, @Nonnull EntitySchemaContract schema) {
        if (catalogCtx == null) {
            throw new NullPointerException("catalogCtx is marked non-null but is null");
        }
        if (schema == null) {
            throw new NullPointerException("schema is marked non-null but is null");
        }
        this.catalogCtx = catalogCtx;
        this.schema = schema;
    }

    @Nonnull
    @Generated
    public CatalogGraphQLSchemaBuildingContext getCatalogCtx() {
        return this.catalogCtx;
    }

    @Nonnull
    @Generated
    public EntitySchemaContract getSchema() {
        return this.schema;
    }

    @Generated
    public GraphQLInputType getHeadInputObject() {
        return this.headInputObject;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CollectionGraphQLSchemaBuildingContext)) {
            return false;
        }
        CollectionGraphQLSchemaBuildingContext other = (CollectionGraphQLSchemaBuildingContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CatalogGraphQLSchemaBuildingContext this$catalogCtx = this.getCatalogCtx();
        CatalogGraphQLSchemaBuildingContext other$catalogCtx = other.getCatalogCtx();
        if (this$catalogCtx == null ? other$catalogCtx != null : !this$catalogCtx.equals(other$catalogCtx)) {
            return false;
        }
        EntitySchemaContract this$schema = this.getSchema();
        EntitySchemaContract other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        GraphQLInputType this$headInputObject = this.getHeadInputObject();
        GraphQLInputType other$headInputObject = other.getHeadInputObject();
        if (this$headInputObject == null ? other$headInputObject != null : !this$headInputObject.equals(other$headInputObject)) {
            return false;
        }
        GraphQLInputType this$filterByInputObject = this.getFilterByInputObject();
        GraphQLInputType other$filterByInputObject = other.getFilterByInputObject();
        if (this$filterByInputObject == null ? other$filterByInputObject != null : !this$filterByInputObject.equals(other$filterByInputObject)) {
            return false;
        }
        GraphQLInputType this$orderByInputObject = this.getOrderByInputObject();
        GraphQLInputType other$orderByInputObject = other.getOrderByInputObject();
        if (this$orderByInputObject == null ? other$orderByInputObject != null : !this$orderByInputObject.equals(other$orderByInputObject)) {
            return false;
        }
        Optional<GraphQLInputType> this$listRequireInputObject = this.getListRequireInputObject();
        Optional<GraphQLInputType> other$listRequireInputObject = other.getListRequireInputObject();
        if (this$listRequireInputObject == null ? other$listRequireInputObject != null : !((Object)this$listRequireInputObject).equals(other$listRequireInputObject)) {
            return false;
        }
        Optional<GraphQLInputType> this$queryRequireInputObject = this.getQueryRequireInputObject();
        Optional<GraphQLInputType> other$queryRequireInputObject = other.getQueryRequireInputObject();
        return !(this$queryRequireInputObject == null ? other$queryRequireInputObject != null : !((Object)this$queryRequireInputObject).equals(other$queryRequireInputObject));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CollectionGraphQLSchemaBuildingContext;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CatalogGraphQLSchemaBuildingContext $catalogCtx = this.getCatalogCtx();
        result = result * 59 + ($catalogCtx == null ? 43 : $catalogCtx.hashCode());
        EntitySchemaContract $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        GraphQLInputType $headInputObject = this.getHeadInputObject();
        result = result * 59 + ($headInputObject == null ? 43 : $headInputObject.hashCode());
        GraphQLInputType $filterByInputObject = this.getFilterByInputObject();
        result = result * 59 + ($filterByInputObject == null ? 43 : $filterByInputObject.hashCode());
        GraphQLInputType $orderByInputObject = this.getOrderByInputObject();
        result = result * 59 + ($orderByInputObject == null ? 43 : $orderByInputObject.hashCode());
        Optional<GraphQLInputType> $listRequireInputObject = this.getListRequireInputObject();
        result = result * 59 + ($listRequireInputObject == null ? 43 : ((Object)$listRequireInputObject).hashCode());
        Optional<GraphQLInputType> $queryRequireInputObject = this.getQueryRequireInputObject();
        result = result * 59 + ($queryRequireInputObject == null ? 43 : ((Object)$queryRequireInputObject).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CollectionGraphQLSchemaBuildingContext(catalogCtx=" + String.valueOf(this.getCatalogCtx()) + ", schema=" + String.valueOf(this.getSchema()) + ", headInputObject=" + String.valueOf(this.getHeadInputObject()) + ", filterByInputObject=" + String.valueOf(this.getFilterByInputObject()) + ", orderByInputObject=" + String.valueOf(this.getOrderByInputObject()) + ", listRequireInputObject=" + String.valueOf(this.getListRequireInputObject()) + ", queryRequireInputObject=" + String.valueOf(this.getQueryRequireInputObject()) + ")";
    }
}

