/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog;

import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.GraphQL;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.instrumentation.ChainedInstrumentation;
import graphql.execution.instrumentation.Instrumentation;
import graphql.schema.GraphQLSchema;
import io.evitadb.api.CatalogContract;
import io.evitadb.core.Evita;
import io.evitadb.externalApi.graphql.api.GraphQLBuilder;
import io.evitadb.externalApi.graphql.api.catalog.EvitaSessionManagingInstrumentation;
import io.evitadb.externalApi.graphql.api.tracing.OperationTracingInstrumentation;
import io.evitadb.externalApi.graphql.configuration.GraphQLOptions;
import io.evitadb.externalApi.graphql.exception.EvitaDataFetcherExceptionHandler;
import io.evitadb.externalApi.graphql.metric.event.request.RequestMetricInstrumentation;
import io.evitadb.externalApi.graphql.traffic.SourceQueryRecordingInstrumentation;
import javax.annotation.Nonnull;
import lombok.Generated;

public class CatalogGraphQLBuilder
implements GraphQLBuilder {
    @Nonnull
    private final Evita evita;
    @Nonnull
    private final CatalogContract catalog;
    @Nonnull
    private final GraphQLSchema graphQLSchema;
    @Nonnull
    private final ObjectMapper objectMapper;

    @Override
    public GraphQL build(@Nonnull GraphQLOptions config) {
        ChainedInstrumentation instrumentation = new ChainedInstrumentation(new Instrumentation[]{new OperationTracingInstrumentation(), new RequestMetricInstrumentation(this.catalog.getName()), new EvitaSessionManagingInstrumentation(this.evita, this.catalog.getName()), new SourceQueryRecordingInstrumentation(this.objectMapper, this.evita.getConfiguration().server().trafficRecording())});
        EvitaDataFetcherExceptionHandler dataFetcherExceptionHandler = new EvitaDataFetcherExceptionHandler();
        return GraphQL.newGraphQL((GraphQLSchema)this.graphQLSchema).instrumentation((Instrumentation)instrumentation).defaultDataFetcherExceptionHandler((DataFetcherExceptionHandler)dataFetcherExceptionHandler).build();
    }

    @Generated
    public CatalogGraphQLBuilder(@Nonnull Evita evita, @Nonnull CatalogContract catalog, @Nonnull GraphQLSchema graphQLSchema, @Nonnull ObjectMapper objectMapper) {
        if (evita == null) {
            throw new NullPointerException("evita is marked non-null but is null");
        }
        if (catalog == null) {
            throw new NullPointerException("catalog is marked non-null but is null");
        }
        if (graphQLSchema == null) {
            throw new NullPointerException("graphQLSchema is marked non-null but is null");
        }
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper is marked non-null but is null");
        }
        this.evita = evita;
        this.catalog = catalog;
        this.graphQLSchema = graphQLSchema;
        this.objectMapper = objectMapper;
    }
}

