/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.metric.event.request;

import graphql.ExecutionResult;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimplePerformantInstrumentation;
import graphql.execution.instrumentation.parameters.InstrumentationExecuteOperationParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.execution.instrumentation.parameters.InstrumentationValidationParameters;
import graphql.language.Document;
import graphql.language.OperationDefinition;
import graphql.validation.ValidationError;
import io.evitadb.externalApi.graphql.api.catalog.GraphQLContextKey;
import io.evitadb.externalApi.graphql.metric.event.request.ExecutedEvent;
import io.evitadb.externalApi.graphql.utils.GraphQLOperationNameResolver;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class RequestMetricInstrumentation
extends SimplePerformantInstrumentation {
    @Nonnull
    private final String catalogName;

    @Nullable
    public InstrumentationContext<ExecutionResult> beginExecution(InstrumentationExecutionParameters parameters, InstrumentationState state) {
        ExecutedEvent requestExecutedEvent = (ExecutedEvent)((Object)parameters.getGraphQLContext().get((Object)GraphQLContextKey.METRIC_EXECUTED_EVENT));
        if (requestExecutedEvent != null) {
            requestExecutedEvent.provideCatalogName(this.catalogName);
        }
        return super.beginExecution(parameters, state);
    }

    @Nullable
    public InstrumentationContext<Document> beginParse(InstrumentationExecutionParameters parameters, InstrumentationState state) {
        ExecutedEvent requestExecutedEvent = (ExecutedEvent)((Object)parameters.getGraphQLContext().get((Object)GraphQLContextKey.METRIC_EXECUTED_EVENT));
        if (requestExecutedEvent != null) {
            requestExecutedEvent.finishPreparation();
        }
        return super.beginParse(parameters, state);
    }

    @Nullable
    public InstrumentationContext<List<ValidationError>> beginValidation(InstrumentationValidationParameters parameters, InstrumentationState state) {
        ExecutedEvent requestExecutedEvent = (ExecutedEvent)((Object)parameters.getGraphQLContext().get((Object)GraphQLContextKey.METRIC_EXECUTED_EVENT));
        if (requestExecutedEvent != null) {
            requestExecutedEvent.finishParse();
        }
        return super.beginValidation(parameters, state);
    }

    @Nullable
    public InstrumentationContext<ExecutionResult> beginExecuteOperation(InstrumentationExecuteOperationParameters parameters, InstrumentationState state) {
        ExecutedEvent requestExecutedEvent = (ExecutedEvent)((Object)parameters.getExecutionContext().getGraphQLContext().get((Object)GraphQLContextKey.METRIC_EXECUTED_EVENT));
        if (requestExecutedEvent != null) {
            requestExecutedEvent.finishValidation();
            OperationDefinition operationDefinition = parameters.getExecutionContext().getOperationDefinition();
            requestExecutedEvent.provideOperationType(operationDefinition.getOperation());
            requestExecutedEvent.provideOperationName(GraphQLOperationNameResolver.resolve(operationDefinition));
            requestExecutedEvent.provideRootFieldsProcessed(operationDefinition.getSelectionSet().getSelections().size());
        }
        return super.beginExecuteOperation(parameters, state);
    }

    @Nonnull
    public CompletableFuture<ExecutionResult> instrumentExecutionResult(ExecutionResult executionResult, InstrumentationExecutionParameters parameters, InstrumentationState state) {
        ExecutedEvent requestExecutedEvent = (ExecutedEvent)((Object)parameters.getGraphQLContext().get((Object)GraphQLContextKey.METRIC_EXECUTED_EVENT));
        if (requestExecutedEvent != null) {
            requestExecutedEvent.finishOperationExecution();
            if (executionResult.getErrors() != null && !executionResult.getErrors().isEmpty() && ExecutedEvent.ResponseStatus.OK.name().equals(requestExecutedEvent.getResponseStatus())) {
                requestExecutedEvent.provideResponseStatus(ExecutedEvent.ResponseStatus.ERROR);
            }
        }
        return super.instrumentExecutionResult(executionResult, parameters, state);
    }

    @Generated
    public RequestMetricInstrumentation(@Nonnull String catalogName) {
        if (catalogName == null) {
            throw new NullPointerException("catalogName is marked non-null but is null");
        }
        this.catalogName = catalogName;
    }
}

