/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.io;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.ServiceRequestContext;
import graphql.GraphQL;
import io.evitadb.core.Evita;
import io.evitadb.externalApi.configuration.HeaderOptions;
import io.evitadb.externalApi.graphql.exception.GraphQLInternalError;
import io.evitadb.externalApi.graphql.io.GraphQLExceptionHandler;
import io.evitadb.externalApi.graphql.io.GraphQLHandler;
import io.evitadb.externalApi.graphql.io.GraphQLInstanceType;
import io.evitadb.externalApi.graphql.io.GraphQLSchemaHandler;
import io.evitadb.externalApi.http.CorsEndpoint;
import io.evitadb.externalApi.http.CorsService;
import io.evitadb.externalApi.utils.UriPath;
import io.evitadb.externalApi.utils.path.PathHandlingService;
import io.evitadb.externalApi.utils.path.RoutingHandlerService;
import io.evitadb.utils.Assert;
import io.evitadb.utils.CollectionUtils;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import lombok.Generated;

public class GraphQLRouter
implements HttpService {
    public static final String SYSTEM_PREFIX = "system";
    private static final UriPath SYSTEM_PATH = UriPath.of((String[])new String[]{"/", "system"});
    private static final Map<GraphQLInstanceType, UriPath> API_PATH_MAPPING = CollectionUtils.createHashMap((CollectionUtils.Property[])new CollectionUtils.Property[]{new CollectionUtils.Property((Object)GraphQLInstanceType.SYSTEM, (Object)UriPath.of((String[])new String[]{"/"})), new CollectionUtils.Property((Object)GraphQLInstanceType.DATA, (Object)UriPath.of((String[])new String[]{"/"})), new CollectionUtils.Property((Object)GraphQLInstanceType.SCHEMA, (Object)UriPath.of((String[])new String[]{"/", "schema"}))});
    @Nonnull
    private final ObjectMapper objectMapper;
    @Nonnull
    private final Evita evita;
    @Nonnull
    private final HeaderOptions headers;
    private final PathHandlingService delegateRouter = new PathHandlingService();
    private boolean systemApiRegistered = false;
    @Nonnull
    private final Map<String, RegisteredCatalog> registeredCatalogs = CollectionUtils.createConcurrentHashMap((int)20);

    @Nonnull
    public HttpResponse serve(@Nonnull ServiceRequestContext ctx, @Nonnull HttpRequest req) throws Exception {
        return this.delegateRouter.serve(ctx, req);
    }

    public void registerSystemApi(@Nonnull GraphQL systemApi) {
        Assert.isPremiseValid((!this.systemApiRegistered ? 1 : 0) != 0, () -> new GraphQLInternalError("System API has been already registered."));
        RoutingHandlerService apiRouter = new RoutingHandlerService();
        this.registerApi(apiRouter, new RegisteredApi(GraphQLInstanceType.SYSTEM, API_PATH_MAPPING.get((Object)GraphQLInstanceType.SYSTEM), new AtomicReference<GraphQL>(systemApi)));
        this.delegateRouter.addPrefixPath(SYSTEM_PATH.toString(), (HttpService)apiRouter);
        this.systemApiRegistered = true;
    }

    public void registerCatalogApi(@Nonnull String catalogName, @Nonnull GraphQLInstanceType instanceType, @Nonnull GraphQL api) {
        RegisteredCatalog registeredCatalog = this.registeredCatalogs.computeIfAbsent(catalogName, k -> {
            RoutingHandlerService apiRouter = new RoutingHandlerService();
            this.delegateRouter.addPrefixPath(GraphQLRouter.constructCatalogPath(catalogName).toString(), (HttpService)apiRouter);
            return new RegisteredCatalog(apiRouter);
        });
        RegisteredApi registeredDataApi = new RegisteredApi(instanceType, API_PATH_MAPPING.get((Object)instanceType), new AtomicReference<GraphQL>(api));
        this.registerApi(registeredCatalog.getApiRouter(), registeredDataApi);
        registeredCatalog.setApi(instanceType, registeredDataApi);
    }

    public void refreshCatalogApi(@Nonnull String catalogName, @Nonnull GraphQLInstanceType instanceType, @Nonnull GraphQL newApi) {
        RegisteredCatalog registeredCatalog = this.registeredCatalogs.get(catalogName);
        if (registeredCatalog == null) {
            throw new GraphQLInternalError("No catalog APIs registered for `" + catalogName + "`. Cannot refresh.");
        }
        registeredCatalog.getApi(instanceType).graphQLReference().set(newApi);
    }

    public void unregisterCatalogApis(@Nonnull String catalogName) {
        RegisteredCatalog registeredCatalog = this.registeredCatalogs.remove(catalogName);
        if (registeredCatalog != null) {
            this.delegateRouter.removePrefixPath(GraphQLRouter.constructCatalogPath(catalogName).toString());
        }
    }

    private void registerApi(@Nonnull RoutingHandlerService apiRouter, @Nonnull RegisteredApi registeredApi) {
        CorsEndpoint corsEndpoint = new CorsEndpoint(this.headers);
        corsEndpoint.addMetadata(Set.of(HttpMethod.GET, HttpMethod.POST), true, true);
        apiRouter.add(HttpMethod.POST, registeredApi.path().toString(), (HttpService)CorsService.standaloneFilter((HttpService)((HttpService)new GraphQLHandler(this.evita, this.headers, this.objectMapper, registeredApi.instanceType(), registeredApi.graphQLReference()).decorate(service -> new GraphQLExceptionHandler(this.objectMapper, (HttpService)service)))));
        apiRouter.add(HttpMethod.GET, registeredApi.path().toString(), (HttpService)CorsService.standaloneFilter((HttpService)((HttpService)new GraphQLSchemaHandler(this.evita, registeredApi.graphQLReference()).decorate(service -> new GraphQLExceptionHandler(this.objectMapper, (HttpService)service)))));
        apiRouter.add(HttpMethod.OPTIONS, registeredApi.path().toString(), corsEndpoint.toHandler());
    }

    @Nonnull
    private static UriPath constructCatalogPath(@Nonnull String catalogName) {
        return UriPath.of((String[])new String[]{"/", catalogName});
    }

    @Generated
    public GraphQLRouter(@Nonnull ObjectMapper objectMapper, @Nonnull Evita evita, @Nonnull HeaderOptions headers) {
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper is marked non-null but is null");
        }
        if (evita == null) {
            throw new NullPointerException("evita is marked non-null but is null");
        }
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        this.objectMapper = objectMapper;
        this.evita = evita;
        this.headers = headers;
    }

    private record RegisteredApi(@Nonnull GraphQLInstanceType instanceType, @Nonnull UriPath path, @Nonnull AtomicReference<GraphQL> graphQLReference) {
    }

    private static class RegisteredCatalog {
        private static final Set<GraphQLInstanceType> ALLOWED_API_INSTANCES = Set.of(GraphQLInstanceType.DATA, GraphQLInstanceType.SCHEMA);
        private final RoutingHandlerService apiRouter;
        private final Map<GraphQLInstanceType, RegisteredApi> apis = CollectionUtils.createHashMap((int)2);

        public void setApi(@Nonnull GraphQLInstanceType instanceType, @Nonnull RegisteredApi api) {
            Assert.isPremiseValid((boolean)ALLOWED_API_INSTANCES.contains((Object)instanceType), () -> new GraphQLInternalError("API `" + instanceType.name() + "` is not allowed for catalog."));
            Assert.isPremiseValid((!this.apis.containsKey((Object)instanceType) ? 1 : 0) != 0, () -> new GraphQLInternalError("`" + instanceType.name() + "` API has been already registered."));
            this.apis.put(instanceType, api);
        }

        public RegisteredApi getApi(@Nonnull GraphQLInstanceType instanceType) {
            RegisteredApi api = this.apis.get((Object)instanceType);
            Assert.isPremiseValid((api != null ? 1 : 0) != 0, () -> new GraphQLInternalError("API `" + instanceType.name() + "` has not been registered yet."));
            return api;
        }

        @Generated
        public RegisteredCatalog(RoutingHandlerService apiRouter) {
            this.apiRouter = apiRouter;
        }

        @Generated
        public RoutingHandlerService getApiRouter() {
            return this.apiRouter;
        }
    }
}

