/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.exception;

import graphql.GraphQLContext;
import graphql.GraphQLError;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.DataFetcherExceptionHandlerResult;
import io.evitadb.api.observability.trace.TracingBlockReference;
import io.evitadb.exception.EvitaError;
import io.evitadb.externalApi.graphql.api.catalog.GraphQLContextKey;
import io.evitadb.externalApi.graphql.exception.EvitaGraphQLError;
import io.evitadb.externalApi.graphql.exception.GraphQLInternalError;
import io.evitadb.externalApi.graphql.metric.event.request.ExecutedEvent;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvitaDataFetcherExceptionHandler
implements DataFetcherExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EvitaDataFetcherExceptionHandler.class);

    public CompletableFuture<DataFetcherExceptionHandlerResult> handleException(@Nonnull DataFetcherExceptionHandlerParameters handlerParameters) {
        Throwable exception = this.unwrap(handlerParameters.getException());
        Object evitaError = exception instanceof EvitaError ? (EvitaError)exception : new GraphQLInternalError("Unexpected internal evitaDB GraphQL API error occurred: " + exception.getMessage(), "Unexpected internal evitaDB GraphQL API error occurred.", exception);
        if (evitaError instanceof GraphQLInternalError) {
            GraphQLInternalError graphQLInternalError = (GraphQLInternalError)((Object)evitaError);
            log.error("Internal evitaDB GraphQL API error occurred in {}: {}", new Object[]{graphQLInternalError.getErrorCode(), graphQLInternalError.getPrivateMessage(), graphQLInternalError});
        }
        GraphQLContext graphQlContext = handlerParameters.getDataFetchingEnvironment().getGraphQlContext();
        TracingBlockReference operationBlockReference = (TracingBlockReference)graphQlContext.get((Object)GraphQLContextKey.OPERATION_TRACING_BLOCK);
        operationBlockReference.setError((Throwable)evitaError);
        UUID sourceQueryRecordingId = (UUID)graphQlContext.get((Object)GraphQLContextKey.TRAFFIC_SOURCE_QUERY_RECORDING_ID);
        if (sourceQueryRecordingId != null) {
            LinkedList<EvitaError> exceptions = (LinkedList<EvitaError>)graphQlContext.get((Object)GraphQLContextKey.TRAFFIC_SOURCE_QUERY_RECORDING_EXCEPTIONS);
            if (exceptions == null) {
                exceptions = new LinkedList<EvitaError>();
                graphQlContext.put((Object)GraphQLContextKey.TRAFFIC_SOURCE_QUERY_RECORDING_EXCEPTIONS, exceptions);
            }
            exceptions.add((EvitaError)evitaError);
        }
        EvitaGraphQLError error = new EvitaGraphQLError(evitaError.getPublicMessage(), handlerParameters.getSourceLocation(), handlerParameters.getPath().toList(), Map.of("errorCode", evitaError.getErrorCode()));
        ExecutedEvent requestExecutedEvent = (ExecutedEvent)((Object)graphQlContext.get((Object)GraphQLContextKey.METRIC_EXECUTED_EVENT));
        if (requestExecutedEvent != null) {
            requestExecutedEvent.provideResponseStatus(ExecutedEvent.ResponseStatus.ERROR);
        }
        return CompletableFuture.completedFuture(DataFetcherExceptionHandlerResult.newResult().error((GraphQLError)error).build());
    }

    protected Throwable unwrap(Throwable exception) {
        if (exception.getCause() != null && exception instanceof CompletionException) {
            return exception.getCause();
        }
        return exception;
    }
}

