/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.model;

import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.api.requestResponse.schema.NamedSchemaContract;
import io.evitadb.externalApi.api.model.EndpointDescriptor;
import io.evitadb.externalApi.api.model.EndpointDescriptorTransformer;
import io.evitadb.externalApi.api.model.PropertyDataTypeDescriptorTransformer;
import io.evitadb.externalApi.graphql.exception.GraphQLSchemaBuildingError;
import io.evitadb.utils.Assert;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class EndpointDescriptorToGraphQLFieldTransformer
implements EndpointDescriptorTransformer<GraphQLFieldDefinition.Builder> {
    @Nonnull
    private final PropertyDataTypeDescriptorTransformer<GraphQLType> propertyDataTypeTransformer;
    @Nullable
    private final EntitySchemaContract entitySchema;

    public EndpointDescriptorToGraphQLFieldTransformer(@Nonnull PropertyDataTypeDescriptorTransformer<GraphQLType> propertyDataTypeTransformer) {
        this(propertyDataTypeTransformer, null);
    }

    public GraphQLFieldDefinition.Builder apply(@Nonnull EndpointDescriptor endpointDescriptor) {
        String fieldName;
        if (endpointDescriptor.hasClassifier()) {
            Assert.isPremiseValid((this.entitySchema == null ? 1 : 0) != 0, () -> new GraphQLSchemaBuildingError("Classifier in endpoint `" + String.valueOf(endpointDescriptor) + "` has static classifier but dynamic one was provided."));
            fieldName = endpointDescriptor.operation();
        } else {
            fieldName = this.entitySchema != null ? endpointDescriptor.operation((NamedSchemaContract)this.entitySchema) : endpointDescriptor.operation();
        }
        GraphQLFieldDefinition.Builder fieldBuilder = GraphQLFieldDefinition.newFieldDefinition().name(fieldName).description(endpointDescriptor.description());
        if (this.entitySchema != null) {
            fieldBuilder.deprecate(this.entitySchema.getDeprecationNotice());
        }
        if (endpointDescriptor.type() != null) {
            GraphQLOutputType graphQLType = (GraphQLOutputType)this.propertyDataTypeTransformer.apply((Object)endpointDescriptor.type());
            fieldBuilder.type(graphQLType);
        }
        return fieldBuilder;
    }

    @Generated
    public EndpointDescriptorToGraphQLFieldTransformer(@Nonnull PropertyDataTypeDescriptorTransformer<GraphQLType> propertyDataTypeTransformer, @Nullable EntitySchemaContract entitySchema) {
        if (propertyDataTypeTransformer == null) {
            throw new NullPointerException("propertyDataTypeTransformer is marked non-null but is null");
        }
        this.propertyDataTypeTransformer = propertyDataTypeTransformer;
        this.entitySchema = entitySchema;
    }
}

