/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.entity;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.evitadb.api.requestResponse.data.ReferenceContract;
import io.evitadb.api.requestResponse.data.structure.EntityDecorator;
import io.evitadb.api.requestResponse.schema.Cardinality;
import io.evitadb.api.requestResponse.schema.ReferenceSchemaContract;
import io.evitadb.externalApi.graphql.exception.GraphQLInternalError;
import io.evitadb.externalApi.graphql.exception.GraphQLQueryResolvingInternalError;
import io.evitadb.utils.Assert;
import java.util.Collection;
import javax.annotation.Nonnull;
import lombok.Generated;

public class ReferenceDataFetcher
implements DataFetcher<ReferenceContract> {
    @Nonnull
    private final ReferenceSchemaContract referenceSchema;

    @Nonnull
    public ReferenceContract get(@Nonnull DataFetchingEnvironment environment) throws Exception {
        ReferenceContract reference;
        EntityDecorator entity = (EntityDecorator)environment.getSource();
        Assert.isPremiseValid((this.referenceSchema.getCardinality() == Cardinality.ZERO_OR_ONE || this.referenceSchema.getCardinality() == Cardinality.EXACTLY_ONE ? 1 : 0) != 0, () -> new GraphQLQueryResolvingInternalError("Reference `" + this.referenceSchema.getName() + "` doesn't have cardinality of single reference but single reference were requested."));
        Collection references = entity.getReferences(this.referenceSchema.getName());
        Assert.isPremiseValid((references.size() <= 1 ? 1 : 0) != 0, () -> new GraphQLQueryResolvingInternalError("Reference `" + this.referenceSchema.getName() + "` is expected to be single reference but multiple found."));
        ReferenceContract referenceContract = reference = references.isEmpty() ? null : (ReferenceContract)references.iterator().next();
        if (this.referenceSchema.getCardinality() == Cardinality.EXACTLY_ONE && reference == null) {
            throw new GraphQLInternalError("evitaDB should returned exactly one reference for name `" + this.referenceSchema.getName() + "` but zero found.");
        }
        return reference;
    }

    @Generated
    public ReferenceDataFetcher(@Nonnull ReferenceSchemaContract referenceSchema) {
        if (referenceSchema == null) {
            throw new NullPointerException("referenceSchema is marked non-null but is null");
        }
        this.referenceSchema = referenceSchema;
    }
}

