/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.entity;

import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.evitadb.api.requestResponse.data.PricesContract;
import io.evitadb.api.requestResponse.data.structure.EntityDecorator;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.entity.AccompanyingPriceFieldHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.entity.PriceForSaleDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.entity.PriceForSaleFieldHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.EntityQueryContext;
import io.evitadb.externalApi.graphql.api.resolver.SelectionSetAggregator;
import io.evitadb.externalApi.graphql.exception.GraphQLInternalError;
import io.evitadb.externalApi.graphql.exception.GraphQLInvalidArgumentException;
import java.time.OffsetDateTime;
import java.util.Currency;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractPriceForSaleDataFetcher<P>
implements DataFetcher<DataFetcherResult<P>> {
    @Nonnull
    public DataFetcherResult<P> get(DataFetchingEnvironment environment) throws Exception {
        P result;
        EntityDecorator entity = (EntityDecorator)environment.getSource();
        if (entity == null) {
            throw new GraphQLInternalError("Missing entity");
        }
        EntityQueryContext context = (EntityQueryContext)environment.getLocalContext();
        if (context == null) {
            throw new GraphQLInternalError("Missing entity context");
        }
        String[] priceLists = this.resolveDesiredPricesLists(environment, context);
        Currency currency = this.resolveDesiredCurrency(environment, context);
        OffsetDateTime validIn = this.resolveDesiredValidIn(environment, entity, context);
        if (environment.getArguments().isEmpty()) {
            result = this.computeDefaultPrices(entity);
        } else {
            PricesContract.AccompanyingPrice[] desiredAccompanyingPrices = this.resolveDesiredAccompanyingPricesForCustomPriceForSale(environment);
            result = this.computePrices(entity, priceLists, currency, validIn, desiredAccompanyingPrices);
        }
        Locale customLocale = (Locale)environment.getArgument(PriceForSaleFieldHeaderDescriptor.LOCALE.name());
        EntityQueryContext newContext = context.toBuilder().desiredPriceInPriceLists(priceLists).desiredPriceInCurrency(currency).desiredPriceValidIn(validIn).desiredPriceValidInNow(false).desiredLocale(customLocale != null ? customLocale : context.getDesiredLocale()).build();
        return DataFetcherResult.newResult().data(result).localContext((Object)newContext).build();
    }

    @Nullable
    protected abstract P computeDefaultPrices(@Nonnull EntityDecorator var1);

    @Nullable
    protected abstract P computePrices(@Nonnull EntityDecorator var1, @Nonnull String[] var2, @Nonnull Currency var3, @Nullable OffsetDateTime var4, @Nonnull PricesContract.AccompanyingPrice[] var5);

    @Nonnull
    protected String[] resolveDesiredPricesLists(@Nonnull DataFetchingEnvironment environment, @Nonnull EntityQueryContext context) {
        return Optional.ofNullable((List)environment.getArgument(PriceForSaleFieldHeaderDescriptor.PRICE_LISTS.name())).map(it -> (String[])it.toArray(String[]::new)).or(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }).or(() -> Optional.ofNullable(context.getDesiredPriceInPriceLists())).orElseThrow(() -> new GraphQLInvalidArgumentException("Missing price list argument. You can use `" + PriceForSaleFieldHeaderDescriptor.PRICE_LIST.name() + "` or `" + PriceForSaleFieldHeaderDescriptor.PRICE_LISTS.name() + "` parameter for specifying custom price list."));
    }

    @Nonnull
    protected Currency resolveDesiredCurrency(@Nonnull DataFetchingEnvironment environment, @Nonnull EntityQueryContext context) {
        return Optional.ofNullable((Currency)environment.getArgument(PriceForSaleFieldHeaderDescriptor.CURRENCY.name())).or(() -> Optional.ofNullable(context.getDesiredPriceInCurrency())).orElseThrow(() -> new GraphQLInvalidArgumentException("Missing `currency` argument. You can use `" + PriceForSaleFieldHeaderDescriptor.CURRENCY.name() + "` parameter for specifying custom currency."));
    }

    @Nullable
    protected OffsetDateTime resolveDesiredValidIn(@Nonnull DataFetchingEnvironment environment, @Nonnull EntityDecorator entity, @Nonnull EntityQueryContext context) {
        return Optional.ofNullable((OffsetDateTime)environment.getArgument(PriceForSaleFieldHeaderDescriptor.VALID_IN.name())).or(() -> Optional.ofNullable((Boolean)environment.getArgument(PriceForSaleFieldHeaderDescriptor.VALID_NOW.name())).map(validNow -> validNow != false ? entity.getAlignedNow() : null)).or(() -> Optional.ofNullable(context.getDesiredPriceValidIn())).or(() -> Optional.of(context.isDesiredPriceValidInNow()).map(validNow -> validNow != false ? entity.getAlignedNow() : null)).orElse(null);
    }

    @Nonnull
    protected PricesContract.AccompanyingPrice[] resolveDesiredAccompanyingPricesForCustomPriceForSale(@Nonnull DataFetchingEnvironment environment) {
        return (PricesContract.AccompanyingPrice[])SelectionSetAggregator.getImmediateFields(PriceForSaleDescriptor.ACCOMPANYING_PRICE.name(), environment.getSelectionSet()).stream().map(f -> {
            String priceName = f.getAlias() != null ? f.getAlias() : f.getName();
            List priceLists = (List)f.getArguments().get(AccompanyingPriceFieldHeaderDescriptor.PRICE_LISTS.name());
            if (priceLists == null || priceLists.isEmpty()) {
                throw new GraphQLInvalidArgumentException("Custom price for sale requires custom price lists for accompanying prices.");
            }
            return new PricesContract.AccompanyingPrice(priceName, (String[])priceLists.toArray(String[]::new));
        }).toArray(PricesContract.AccompanyingPrice[]::new);
    }
}

