/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql;

import io.evitadb.api.CatalogStructuralChangeObserver;
import io.evitadb.core.Evita;
import io.evitadb.externalApi.configuration.ApiOptions;
import io.evitadb.externalApi.graphql.GraphQLManager;
import io.evitadb.externalApi.graphql.GraphQLProvider;
import io.evitadb.externalApi.graphql.api.catalog.CatalogGraphQLRefreshingObserver;
import io.evitadb.externalApi.graphql.configuration.GraphQLOptions;
import io.evitadb.externalApi.http.ExternalApiProvider;
import io.evitadb.externalApi.http.ExternalApiProviderRegistrar;
import io.evitadb.externalApi.http.ExternalApiServer;
import javax.annotation.Nonnull;

public class GraphQLProviderRegistrar
implements ExternalApiProviderRegistrar<GraphQLOptions> {
    @Nonnull
    public String getExternalApiCode() {
        return "graphQL";
    }

    @Nonnull
    public Class<GraphQLOptions> getConfigurationClass() {
        return GraphQLOptions.class;
    }

    @Nonnull
    public ExternalApiProvider<GraphQLOptions> register(@Nonnull Evita evita, @Nonnull ExternalApiServer externalApiServer, @Nonnull ApiOptions apiOptions, @Nonnull GraphQLOptions graphQLConfig) {
        GraphQLManager graphQLManager = new GraphQLManager(evita, apiOptions.headers(), graphQLConfig);
        evita.registerStructuralChangeObserver((CatalogStructuralChangeObserver)new CatalogGraphQLRefreshingObserver(graphQLManager));
        return new GraphQLProvider(graphQLConfig, graphQLManager, apiOptions.requestTimeoutInMillis());
    }
}

