/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.dataType.coercing;

import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import javax.annotation.Nonnull;

public class LongCoercing
implements Coercing<Long, String> {
    @Nonnull
    public String serialize(@Nonnull Object dataFetcherResult) throws CoercingSerializeException {
        if (!(dataFetcherResult instanceof Long)) {
            throw new CoercingSerializeException("Long data fetcher result is not a long.");
        }
        return String.valueOf(dataFetcherResult);
    }

    @Nonnull
    public Long parseValue(@Nonnull Object input) throws CoercingParseValueException {
        if (!(input instanceof String)) {
            throw new CoercingParseValueException("Long input value is not a string.");
        }
        try {
            return Long.parseLong((String)input);
        }
        catch (NumberFormatException ex) {
            throw new CoercingParseValueException(ex.getMessage(), (Throwable)ex);
        }
    }

    @Nonnull
    public Long parseLiteral(@Nonnull Object input) throws CoercingParseLiteralException {
        if (!(input instanceof StringValue)) {
            throw new CoercingParseValueException("Long input value is not a string.");
        }
        try {
            return Long.parseLong(((StringValue)input).getValue());
        }
        catch (NumberFormatException ex) {
            throw new CoercingParseLiteralException(ex.getMessage(), (Throwable)ex);
        }
    }
}

