/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.io;

import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.GraphQL;
import io.evitadb.core.Evita;
import io.evitadb.externalApi.graphql.configuration.GraphQLConfig;
import io.evitadb.externalApi.graphql.exception.GraphQLInternalError;
import io.evitadb.externalApi.graphql.io.GraphQLExceptionHandler;
import io.evitadb.externalApi.graphql.io.GraphQLHandler;
import io.evitadb.externalApi.graphql.io.GraphQLSchemaHandler;
import io.evitadb.externalApi.http.CorsFilter;
import io.evitadb.externalApi.http.CorsPreflightHandler;
import io.evitadb.externalApi.utils.UriPath;
import io.evitadb.utils.Assert;
import io.evitadb.utils.CollectionUtils;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.RoutingHandler;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.util.Methods;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;

public class GraphQLRouter
implements HttpHandler {
    public static final String SYSTEM_PREFIX = "system";
    private static final UriPath SYSTEM_PATH = UriPath.of((String[])new String[]{"/", "system"});
    private static final UriPath SYSTEM_API_PATH = UriPath.of((String[])new String[]{"/"});
    private static final UriPath DATA_API_PATH = UriPath.of((String[])new String[]{"/"});
    private static final UriPath SCHEMA_API_PATH = UriPath.of((String[])new String[]{"/", "schema"});
    @Nonnull
    private final ObjectMapper objectMapper;
    @Nonnull
    private final Evita evita;
    @Nonnull
    private final GraphQLConfig graphQLConfig;
    private final PathHandler delegateRouter = Handlers.path();
    private boolean systemApiRegistered = false;
    @Nonnull
    private final Map<String, RegisteredCatalog> registeredCatalogs = CollectionUtils.createConcurrentHashMap((int)20);

    public void handleRequest(HttpServerExchange httpServerExchange) throws Exception {
        this.delegateRouter.handleRequest(httpServerExchange);
    }

    public void registerSystemApi(@Nonnull GraphQL systemApi) {
        Assert.isPremiseValid((!this.systemApiRegistered ? 1 : 0) != 0, () -> new GraphQLInternalError("System API has been already registered."));
        RoutingHandler apiRouter = Handlers.routing();
        this.registerApi(apiRouter, new RegisteredApi(SYSTEM_API_PATH, new AtomicReference<GraphQL>(systemApi)));
        this.delegateRouter.addPrefixPath(SYSTEM_PATH.toString(), (HttpHandler)apiRouter);
        this.systemApiRegistered = true;
    }

    public void registerCatalogApis(@Nonnull String catalogName, @Nonnull GraphQL dataApi, @Nonnull GraphQL schemaApi) {
        Assert.isPremiseValid((!this.registeredCatalogs.containsKey(catalogName) ? 1 : 0) != 0, () -> new GraphQLInternalError("Catalog `" + catalogName + "` has been already registered."));
        RoutingHandler apiRouter = Handlers.routing();
        RegisteredApi registeredDataApi = new RegisteredApi(DATA_API_PATH, new AtomicReference<GraphQL>(dataApi));
        this.registerApi(apiRouter, registeredDataApi);
        RegisteredApi registeredSchemaApi = new RegisteredApi(SCHEMA_API_PATH, new AtomicReference<GraphQL>(schemaApi));
        this.registerApi(apiRouter, registeredSchemaApi);
        this.delegateRouter.addPrefixPath(this.constructCatalogPath(catalogName).toString(), (HttpHandler)apiRouter);
        RegisteredCatalog registeredCatalog = new RegisteredCatalog(registeredDataApi, registeredSchemaApi);
        this.registeredCatalogs.put(catalogName, registeredCatalog);
    }

    public void refreshCatalogApis(@Nonnull String catalogName, @Nonnull GraphQL newDataApi, @Nonnull GraphQL newSchemaApi) {
        RegisteredCatalog registeredCatalog = this.registeredCatalogs.get(catalogName);
        if (registeredCatalog == null) {
            throw new GraphQLInternalError("No catalog APIs registered for `" + catalogName + "`. Cannot refresh.");
        }
        registeredCatalog.dataApi().graphQLReference().set(newDataApi);
        registeredCatalog.schemaApi().graphQLReference().set(newSchemaApi);
    }

    public void unregisterCatalogApis(@Nonnull String catalogName) {
        RegisteredCatalog registeredCatalog = this.registeredCatalogs.remove(catalogName);
        if (registeredCatalog != null) {
            this.delegateRouter.removePrefixPath(this.constructCatalogPath(catalogName).toString());
        }
    }

    private void registerApi(@Nonnull RoutingHandler apiRouter, @Nonnull RegisteredApi registeredApi) {
        apiRouter.add(Methods.POST, registeredApi.path().toString(), (HttpHandler)new BlockingHandler((HttpHandler)new CorsFilter((HttpHandler)new GraphQLExceptionHandler(this.objectMapper, (HttpHandler)new GraphQLHandler(this.objectMapper, this.evita, registeredApi.graphQLReference())), this.graphQLConfig.getAllowedOrigins())));
        apiRouter.add(Methods.GET, registeredApi.path().toString(), (HttpHandler)new BlockingHandler((HttpHandler)new CorsFilter((HttpHandler)new GraphQLExceptionHandler(this.objectMapper, (HttpHandler)new GraphQLSchemaHandler(registeredApi.graphQLReference())), this.graphQLConfig.getAllowedOrigins())));
        apiRouter.add(Methods.OPTIONS, registeredApi.path().toString(), (HttpHandler)new BlockingHandler((HttpHandler)new CorsFilter((HttpHandler)new CorsPreflightHandler(this.graphQLConfig.getAllowedOrigins(), Set.of("GET", "POST"), Set.of("Content-Type", "Accept", "traceparent", "X-EvitaDB-ClientID")), this.graphQLConfig.getAllowedOrigins())));
    }

    @Nonnull
    private UriPath constructCatalogPath(@Nonnull String catalogName) {
        return UriPath.of((String[])new String[]{"/", catalogName});
    }

    public GraphQLRouter(@Nonnull ObjectMapper objectMapper, @Nonnull Evita evita, @Nonnull GraphQLConfig graphQLConfig) {
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper is marked non-null but is null");
        }
        if (evita == null) {
            throw new NullPointerException("evita is marked non-null but is null");
        }
        if (graphQLConfig == null) {
            throw new NullPointerException("graphQLConfig is marked non-null but is null");
        }
        this.objectMapper = objectMapper;
        this.evita = evita;
        this.graphQLConfig = graphQLConfig;
    }

    private record RegisteredApi(@Nonnull UriPath path, @Nonnull AtomicReference<GraphQL> graphQLReference) {
    }

    private record RegisteredCatalog(@Nonnull RegisteredApi dataApi, @Nonnull RegisteredApi schemaApi) {
    }
}

