/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.dataType.coercing;

import graphql.language.StringValue;
import graphql.schema.CoercingParseLiteralException;
import io.evitadb.dataType.BigDecimalNumberRange;
import io.evitadb.externalApi.graphql.api.dataType.coercing.RangeCoercing;
import io.evitadb.externalApi.graphql.exception.GraphQLInvalidArgumentException;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BigDecimalNumberRangeCoercing
extends RangeCoercing<BigDecimal, BigDecimalNumberRange, String> {
    @Override
    protected Class<BigDecimalNumberRange> getRangeClass() {
        return BigDecimalNumberRange.class;
    }

    @Override
    protected Class<String> getTupleComponentClass() {
        return String.class;
    }

    @Nonnull
    protected String[] createTuple(@Nullable String from, @Nullable String to) {
        return new String[]{from, to};
    }

    @Override
    @Nonnull
    protected BigDecimalNumberRange createRange(@Nullable BigDecimal left, @Nullable BigDecimal right) {
        if (left != null && right != null) {
            return BigDecimalNumberRange.between((BigDecimal)left, (BigDecimal)right);
        }
        if (left != null) {
            return BigDecimalNumberRange.from((BigDecimal)left);
        }
        if (right != null) {
            return BigDecimalNumberRange.to((BigDecimal)right);
        }
        throw new GraphQLInvalidArgumentException("Both left and right arguments cannot be null!");
    }

    @Override
    @Nonnull
    protected String extractRangeEndFromNode(@Nonnull Object node) {
        if (!(node instanceof StringValue)) {
            throw new CoercingParseLiteralException("Item of range input value is not a string.");
        }
        return ((StringValue)node).getValue();
    }

    @Override
    @Nullable
    protected String formatRangeEnd(@Nullable BigDecimal end) {
        return Optional.ofNullable(end).map(Objects::toString).orElse(null);
    }

    @Override
    @Nullable
    protected BigDecimal parseRangeEnd(@Nullable String end) {
        return Optional.ofNullable(end).map(BigDecimal::new).orElse(null);
    }
}

