/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.entity;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.evitadb.api.query.require.QueryPriceMode;
import io.evitadb.api.requestResponse.data.PriceInnerRecordHandling;
import io.evitadb.api.requestResponse.data.structure.EntityDecorator;
import io.evitadb.externalApi.graphql.exception.GraphQLInternalError;
import java.util.List;
import javax.annotation.Nonnull;

public class MultiplePricesForSaleAvailableDataFetcher
implements DataFetcher<Boolean> {
    @Nonnull
    public Boolean get(@Nonnull DataFetchingEnvironment environment) throws Exception {
        boolean hasMultiplePricesForSale;
        EntityDecorator entity = (EntityDecorator)environment.getSource();
        List allPricesForSale = entity.getAllPricesForSale();
        if (allPricesForSale.size() <= 1) {
            return false;
        }
        PriceInnerRecordHandling priceInnerRecordHandling = entity.getPriceInnerRecordHandling();
        if (priceInnerRecordHandling.equals((Object)PriceInnerRecordHandling.LOWEST_PRICE)) {
            if (allPricesForSale.size() <= 1) {
                return false;
            }
            QueryPriceMode desiredPriceType = entity.getPricePredicate().getQueryPriceMode();
            long uniquePriceValuesCount = allPricesForSale.stream().map(price -> {
                if (desiredPriceType.equals((Object)QueryPriceMode.WITH_TAX)) {
                    return price.priceWithTax();
                }
                if (desiredPriceType.equals((Object)QueryPriceMode.WITHOUT_TAX)) {
                    return price.priceWithoutTax();
                }
                throw new GraphQLInternalError("Unsupported price type `" + desiredPriceType + "`");
            }).distinct().count();
            hasMultiplePricesForSale = uniquePriceValuesCount > 1L;
        } else {
            hasMultiplePricesForSale = false;
        }
        return hasMultiplePricesForSale;
    }
}

