/*
 *
 *                         _ _        ____  ____
 *               _____   _(_) |_ __ _|  _ \| __ )
 *              / _ \ \ / / | __/ _` | | | |  _ \
 *             |  __/\ V /| | || (_| | |_| | |_) |
 *              \___| \_/ |_|\__\__,_|____/|____/
 *
 *   Copyright (c) 2023
 *
 *   Licensed under the Business Source License, Version 1.1 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *   https://github.com/FgForrest/evitaDB/blob/master/LICENSE
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */

package io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.extraResult;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.evitadb.api.requestResponse.extraResult.FacetSummary;
import io.evitadb.api.requestResponse.extraResult.FacetSummary.FacetGroupStatistics;
import io.evitadb.api.requestResponse.schema.ReferenceSchemaContract;
import lombok.RequiredArgsConstructor;

import javax.annotation.Nonnull;
import java.util.Collection;

/**
 * Extracts list of all {@link FacetGroupStatistics} of certain reference name from {@link FacetSummary}.
 *
 * @author Lukáš Hornych, FG Forrest a.s. (c) 2022
 */
@RequiredArgsConstructor
public class FacetGroupStatisticsDataFetcher implements DataFetcher<Collection<FacetGroupStatistics>> {

	@Nonnull
	private final ReferenceSchemaContract referenceSchema;

	@Nonnull
	@Override
	public Collection<FacetGroupStatistics> get(@Nonnull DataFetchingEnvironment environment) throws Exception {
		final FacetSummary facetSummary = environment.getSource();
		return facetSummary.getReferenceStatistics()
			.stream()
			.filter(it -> it.getReferenceName().equals(referenceSchema.getName()))
			.toList();
	}
}
