/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint;

import graphql.schema.SelectedField;
import io.evitadb.api.query.QueryConstraints;
import io.evitadb.api.query.RequireConstraint;
import io.evitadb.externalApi.api.catalog.dataApi.model.ResponseDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.ResponseHeaderDescriptor;
import io.evitadb.externalApi.graphql.exception.GraphQLInternalError;
import javax.annotation.Nonnull;

public class PagingRequireResolver {
    @Nonnull
    public RequireConstraint resolve(@Nonnull SelectedField recordField) {
        if (recordField.getName().equals(ResponseDescriptor.RECORD_PAGE.name())) {
            Integer pageNumber = recordField.getArguments().getOrDefault(ResponseHeaderDescriptor.RecordPageFieldHeaderDescriptor.NUMBER.name(), 1);
            Integer pageSize = recordField.getArguments().getOrDefault(ResponseHeaderDescriptor.RecordPageFieldHeaderDescriptor.SIZE.name(), 20);
            return QueryConstraints.page((Integer)pageNumber, (Integer)pageSize);
        }
        if (recordField.getName().equals(ResponseDescriptor.RECORD_STRIP.name())) {
            Integer offset = recordField.getArguments().getOrDefault(ResponseHeaderDescriptor.RecordStripFieldHeaderDescriptor.OFFSET.name(), 0);
            Integer limit = recordField.getArguments().getOrDefault(ResponseHeaderDescriptor.RecordStripFieldHeaderDescriptor.LIMIT.name(), 20);
            return QueryConstraints.strip((Integer)offset, (Integer)limit);
        }
        throw new GraphQLInternalError("Expected field `" + ResponseDescriptor.RECORD_PAGE + "` or `" + ResponseDescriptor.RECORD_STRIP + "` but was `" + recordField.getName() + "`.");
    }
}

