/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.io;

import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.GraphQLException;
import graphql.execution.InputMapDefinesTooManyFieldsException;
import graphql.execution.NonNullableValueCoercedAsNullException;
import graphql.execution.UnknownOperationException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import io.evitadb.api.configuration.EvitaConfiguration;
import io.evitadb.api.observability.trace.TracingBlockReference;
import io.evitadb.core.Evita;
import io.evitadb.exception.EvitaInternalError;
import io.evitadb.exception.EvitaInvalidUsageException;
import io.evitadb.externalApi.exception.ExternalApiInternalError;
import io.evitadb.externalApi.exception.ExternalApiInvalidUsageException;
import io.evitadb.externalApi.exception.HttpExchangeException;
import io.evitadb.externalApi.graphql.api.catalog.GraphQLContextKey;
import io.evitadb.externalApi.graphql.exception.GraphQLInternalError;
import io.evitadb.externalApi.graphql.exception.GraphQLInvalidUsageException;
import io.evitadb.externalApi.graphql.io.GraphQLRequest;
import io.evitadb.externalApi.graphql.io.GraphQLResponse;
import io.evitadb.externalApi.http.EndpointExchange;
import io.evitadb.externalApi.http.EndpointHandler;
import io.evitadb.externalApi.http.EndpointResponse;
import io.evitadb.externalApi.http.SuccessEndpointResponse;
import io.evitadb.externalApi.trace.ExternalApiTracingContextProvider;
import io.evitadb.externalApi.utils.ExternalApiTracingContext;
import io.evitadb.utils.CollectionUtils;
import io.undertow.server.HttpServerExchange;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLHandler
extends EndpointHandler<GraphQLEndpointExchange> {
    private static final Logger log = LoggerFactory.getLogger(GraphQLHandler.class);
    private static final Set<Class<? extends GraphQLException>> GRAPHQL_USER_ERRORS = Set.of(CoercingSerializeException.class, CoercingParseValueException.class, NonNullableValueCoercedAsNullException.class, InputMapDefinesTooManyFieldsException.class, UnknownOperationException.class);
    @Nonnull
    private final ObjectMapper objectMapper;
    @Nonnull
    private final ExternalApiTracingContext<Object> tracingContext;
    @Nonnull
    private final EvitaConfiguration evitaConfiguration;
    @Nonnull
    private final AtomicReference<GraphQL> graphQL;

    public GraphQLHandler(@Nonnull ObjectMapper objectMapper, @Nonnull Evita evita, @Nonnull AtomicReference<GraphQL> graphQL) {
        this.objectMapper = objectMapper;
        this.tracingContext = ExternalApiTracingContextProvider.getContext();
        this.evitaConfiguration = evita.getConfiguration();
        this.graphQL = graphQL;
    }

    @Nonnull
    protected GraphQLEndpointExchange createEndpointExchange(@Nonnull HttpServerExchange serverExchange, @Nonnull String httpMethod, @Nullable String requestBodyMediaType, @Nullable String preferredResponseMediaType) {
        return new GraphQLEndpointExchange(serverExchange, httpMethod, requestBodyMediaType, preferredResponseMediaType);
    }

    public void handleRequest(HttpServerExchange serverExchange) {
        this.handleRequestWithTracingContext(serverExchange);
    }

    private void handleRequestWithTracingContext(@Nonnull HttpServerExchange serverExchange) {
        this.tracingContext.executeWithinBlock("GraphQL", (Object)serverExchange, () -> super.handleRequest(serverExchange));
    }

    @Nonnull
    protected EndpointResponse doHandleRequest(@Nonnull GraphQLEndpointExchange exchange) {
        GraphQLRequest graphQLRequest = this.parseRequestBody(exchange, GraphQLRequest.class);
        GraphQLResponse<?> graphQLResponse = this.executeRequest(graphQLRequest);
        return new SuccessEndpointResponse(graphQLResponse);
    }

    @Nonnull
    protected <T extends ExternalApiInternalError> T createInternalError(@Nonnull String message) {
        return (T)((Object)new GraphQLInternalError(message));
    }

    @Nonnull
    protected <T extends ExternalApiInternalError> T createInternalError(@Nonnull String message, @Nonnull Throwable cause) {
        return (T)((Object)new GraphQLInternalError(message, cause));
    }

    @Nonnull
    protected <T extends ExternalApiInvalidUsageException> T createInvalidUsageException(@Nonnull String message) {
        return (T)((Object)new GraphQLInvalidUsageException(message));
    }

    @Nonnull
    public Set<String> getSupportedHttpMethods() {
        return Set.of("POST");
    }

    @Nonnull
    public Set<String> getSupportedRequestContentTypes() {
        return Set.of("application/json");
    }

    @Nonnull
    public LinkedHashSet<String> getSupportedResponseContentTypes() {
        LinkedHashSet mediaTypes = CollectionUtils.createLinkedHashSet((int)2);
        mediaTypes.add("application/graphql-response+json");
        mediaTypes.add("application/json");
        return mediaTypes;
    }

    @Nonnull
    protected <T> T parseRequestBody(@Nonnull GraphQLEndpointExchange exchange, @Nonnull Class<T> dataClass) {
        String rawBody = this.readRawRequestBody(exchange);
        try {
            return (T)this.objectMapper.readValue(rawBody, dataClass);
        }
        catch (IOException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof EvitaInternalError) {
                EvitaInternalError internalError = (EvitaInternalError)throwable;
                throw internalError;
            }
            throwable = e.getCause();
            if (throwable instanceof EvitaInvalidUsageException) {
                EvitaInvalidUsageException invalidUsageException = (EvitaInvalidUsageException)throwable;
                throw invalidUsageException;
            }
            throw new HttpExchangeException(415, "Invalid request body format. Expected JSON object.");
        }
    }

    @Nonnull
    private GraphQLResponse<?> executeRequest(@Nonnull GraphQLRequest graphQLRequest) {
        try {
            ExecutionInput executionInput = graphQLRequest.toExecutionInput();
            ExecutionResult result = (ExecutionResult)this.graphQL.get().executeAsync(executionInput).orTimeout(this.evitaConfiguration.server().shortRunningThreadsTimeoutInSeconds(), TimeUnit.SECONDS).join();
            TracingBlockReference blockReference = (TracingBlockReference)executionInput.getGraphQLContext().get((Object)GraphQLContextKey.OPERATION_TRACING_BLOCK);
            if (blockReference != null) {
                blockReference.close();
            }
            return GraphQLResponse.fromExecutionResult(result);
        }
        catch (CompletionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof TimeoutException) {
                throw new HttpExchangeException(504, "Could not complete GraphQL request. Process timed out.");
            }
            if (GRAPHQL_USER_ERRORS.contains(cause.getClass())) {
                throw new GraphQLInvalidUsageException("Invalid GraphQL API request: " + cause.getMessage());
            }
            if (cause instanceof GraphQLException) {
                GraphQLException graphQLException = (GraphQLException)cause;
                throw new GraphQLInternalError("Internal GraphQL API error: " + graphQLException.getMessage(), "Internal GraphQL API error.", (Throwable)graphQLException);
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw e;
        }
        catch (RuntimeException e) {
            throw new GraphQLInternalError("Internal GraphQL API error: " + e.getMessage(), "Internal GraphQL API error.", e);
        }
    }

    protected void writeResult(@Nonnull GraphQLEndpointExchange exchange, @Nonnull OutputStream outputStream, @Nonnull Object response) {
        try {
            this.objectMapper.writeValue(outputStream, response);
        }
        catch (IOException e) {
            throw new GraphQLInternalError("Could not serialize GraphQL API response to JSON: " + e.getMessage(), "Could not provide GraphQL API response.", e);
        }
    }

    protected record GraphQLEndpointExchange(@Nonnull HttpServerExchange serverExchange, @Nonnull String httpMethod, @Nullable String requestBodyContentType, @Nullable String preferredResponseContentType) implements EndpointExchange
    {
    }
}

