/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.dataType.coercing;

import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import javax.annotation.Nonnull;

public class LocalDateCoercing
implements Coercing<LocalDate, String> {
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE;

    public String serialize(@Nonnull Object dataFetcherResult) throws CoercingSerializeException {
        if (!(dataFetcherResult instanceof LocalDate)) {
            throw new CoercingSerializeException("Local date data fetcher result is not a local date.");
        }
        try {
            return ((LocalDate)dataFetcherResult).format(FORMATTER);
        }
        catch (DateTimeException ex) {
            throw new CoercingSerializeException(ex.getMessage(), (Throwable)ex);
        }
    }

    @Nonnull
    public LocalDate parseValue(@Nonnull Object input) throws CoercingParseValueException {
        if (!(input instanceof String)) {
            throw new CoercingParseValueException("Local date input is not a string.");
        }
        try {
            return LocalDate.parse((String)input, FORMATTER);
        }
        catch (DateTimeParseException ex) {
            throw new CoercingParseValueException(ex.getMessage(), (Throwable)ex);
        }
    }

    @Nonnull
    public LocalDate parseLiteral(@Nonnull Object input) throws CoercingParseLiteralException {
        if (!(input instanceof StringValue)) {
            throw new CoercingParseValueException("Local date input is not a StringValue.");
        }
        try {
            return LocalDate.parse(((StringValue)input).getValue(), FORMATTER);
        }
        catch (DateTimeParseException ex) {
            throw new CoercingParseLiteralException(ex.getMessage(), (Throwable)ex);
        }
    }
}

