/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql;

import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.GraphQL;
import io.evitadb.api.CatalogContract;
import io.evitadb.core.CorruptedCatalog;
import io.evitadb.core.Evita;
import io.evitadb.exception.EvitaInternalError;
import io.evitadb.externalApi.graphql.api.catalog.CatalogGraphQLBuilder;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.CatalogDataApiGraphQLSchemaBuilder;
import io.evitadb.externalApi.graphql.api.catalog.schemaApi.CatalogSchemaApiGraphQLSchemaBuilder;
import io.evitadb.externalApi.graphql.api.system.SystemGraphQLBuilder;
import io.evitadb.externalApi.graphql.configuration.GraphQLConfig;
import io.evitadb.externalApi.graphql.exception.GraphQLInternalError;
import io.evitadb.externalApi.graphql.io.GraphQLRouter;
import io.evitadb.externalApi.http.PathNormalizingHandler;
import io.evitadb.utils.Assert;
import io.evitadb.utils.CollectionUtils;
import io.evitadb.utils.StringUtils;
import io.undertow.server.HttpHandler;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLManager {
    private static final Logger log = LoggerFactory.getLogger(GraphQLManager.class);
    @Nonnull
    private final ObjectMapper objectMapper = new ObjectMapper();
    @Nonnull
    private final Evita evita;
    @Nonnull
    private final GraphQLConfig graphQLConfig;
    @Nonnull
    private final GraphQLRouter graphQLRouter;
    @Nonnull
    private final Set<String> registeredCatalogs = CollectionUtils.createHashSet((int)20);

    public GraphQLManager(@Nonnull Evita evita, @Nonnull GraphQLConfig graphQLConfig) {
        this.evita = evita;
        this.graphQLConfig = graphQLConfig;
        this.graphQLRouter = new GraphQLRouter(this.objectMapper, evita, graphQLConfig);
        long buildingStartTime = System.currentTimeMillis();
        this.registerSystemApi();
        this.evita.getCatalogs().forEach(catalog -> this.registerCatalog(catalog.getName()));
        log.info("Built GraphQL API in " + StringUtils.formatPreciseNano((long)(System.currentTimeMillis() - buildingStartTime)));
    }

    @Nonnull
    public HttpHandler getGraphQLRouter() {
        return new PathNormalizingHandler((HttpHandler)this.graphQLRouter);
    }

    private void registerSystemApi() {
        this.graphQLRouter.registerSystemApi(new SystemGraphQLBuilder(this.evita).build(this.graphQLConfig));
    }

    public void registerCatalog(@Nonnull String catalogName) {
        CatalogContract catalog = this.evita.getCatalogInstanceOrThrowException(catalogName);
        if (catalog instanceof CorruptedCatalog) {
            log.warn("Catalog `" + catalogName + "` is corrupted. Skipping...");
            return;
        }
        Assert.isPremiseValid((!this.registeredCatalogs.contains(catalogName) ? 1 : 0) != 0, () -> new GraphQLInternalError("Catalog `" + catalogName + "` has been already registered."));
        try {
            GraphQL dataApi = new CatalogGraphQLBuilder(this.evita, catalog, new CatalogDataApiGraphQLSchemaBuilder(this.graphQLConfig, this.evita, catalog).build()).build(this.graphQLConfig);
            GraphQL schemaApi = new CatalogGraphQLBuilder(this.evita, catalog, new CatalogSchemaApiGraphQLSchemaBuilder(this.graphQLConfig, this.evita, catalog).build()).build(this.graphQLConfig);
            this.registeredCatalogs.add(catalogName);
            this.graphQLRouter.registerCatalogApis(catalogName, dataApi, schemaApi);
        }
        catch (EvitaInternalError ex) {
            log.error("Catalog `" + catalogName + "` is corrupted and will not accessible by GraphQL API.", (Throwable)ex);
        }
    }

    public void refreshCatalog(@Nonnull String catalogName) {
        boolean catalogRegistered = this.registeredCatalogs.contains(catalogName);
        if (!catalogRegistered) {
            log.info("Could not refresh existing catalog `{}`. Registering new one instead...", (Object)catalogName);
            this.registerCatalog(catalogName);
            return;
        }
        CatalogContract catalog = this.evita.getCatalogInstanceOrThrowException(catalogName);
        GraphQL newDataApi = new CatalogGraphQLBuilder(this.evita, catalog, new CatalogDataApiGraphQLSchemaBuilder(this.graphQLConfig, this.evita, catalog).build()).build(this.graphQLConfig);
        GraphQL newSchemaApi = new CatalogGraphQLBuilder(this.evita, catalog, new CatalogSchemaApiGraphQLSchemaBuilder(this.graphQLConfig, this.evita, catalog).build()).build(this.graphQLConfig);
        this.graphQLRouter.refreshCatalogApis(catalogName, newDataApi, newSchemaApi);
    }

    public void unregisterCatalog(@Nonnull String catalogName) {
        boolean catalogRegistered = this.registeredCatalogs.remove(catalogName);
        if (catalogRegistered) {
            this.graphQLRouter.unregisterCatalogApis(catalogName);
        }
    }
}

