/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint;

import graphql.schema.SelectedField;
import io.evitadb.api.query.QueryConstraints;
import io.evitadb.api.query.RequireConstraint;
import io.evitadb.api.query.require.HistogramBehavior;
import io.evitadb.externalApi.api.catalog.dataApi.model.extraResult.ExtraResultsDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.extraResult.HistogramDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.ResponseHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.HistogramRequest;
import io.evitadb.externalApi.graphql.api.resolver.SelectionSetAggregator;
import io.evitadb.externalApi.graphql.exception.GraphQLInvalidResponseUsageException;
import io.evitadb.utils.Assert;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class PriceHistogramResolver {
    @Nonnull
    public Optional<RequireConstraint> resolve(@Nonnull SelectionSetAggregator extraResultsSelectionSet) {
        List<SelectedField> priceHistogramFields = extraResultsSelectionSet.getImmediateFields(ExtraResultsDescriptor.PRICE_HISTOGRAM.name());
        if (priceHistogramFields.isEmpty()) {
            return Optional.empty();
        }
        Set requests = priceHistogramFields.stream().flatMap(f -> SelectionSetAggregator.getImmediateFields(HistogramDescriptor.BUCKETS.name(), f.getSelectionSet()).stream()).map(f -> {
            int requestedBucketCount = (Integer)f.getArguments().get(ResponseHeaderDescriptor.BucketsFieldHeaderDescriptor.REQUESTED_COUNT.name());
            HistogramBehavior behavior = f.getArguments().getOrDefault(ResponseHeaderDescriptor.BucketsFieldHeaderDescriptor.BEHAVIOR.name(), HistogramBehavior.STANDARD);
            return new HistogramRequest(requestedBucketCount, behavior);
        }).collect(Collectors.toSet());
        Assert.isTrue((!requests.isEmpty() ? 1 : 0) != 0, () -> new GraphQLInvalidResponseUsageException("Price histogram must have at least one `" + HistogramDescriptor.BUCKETS.name() + "` field."));
        Assert.isTrue((requests.size() == 1 ? 1 : 0) != 0, () -> new GraphQLInvalidResponseUsageException("Price histogram was requested with multiple different parameters. Only a single set of parameters can be requested."));
        HistogramRequest request = (HistogramRequest)requests.iterator().next();
        return Optional.of(QueryConstraints.priceHistogram((int)request.requestedBucketCount(), (HistogramBehavior)request.behavior()));
    }
}

