/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog;

import graphql.execution.ExecutionContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimplePerformantInstrumentation;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.language.OperationDefinition;
import io.evitadb.api.trace.TracingBlockReference;
import io.evitadb.api.trace.TracingContext;
import io.evitadb.api.trace.TracingContextProvider;
import io.evitadb.externalApi.graphql.api.catalog.GraphQLContextKey;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class OperationTracingInstrumentation
extends SimplePerformantInstrumentation {
    @Nonnull
    private final TracingContext tracingContext = TracingContextProvider.getContext();

    @Nonnull
    public ExecutionContext instrumentExecutionContext(@Nonnull ExecutionContext executionContext, @Nonnull InstrumentationExecutionParameters parameters, @Nonnull InstrumentationState state) {
        OperationDefinition.Operation operation = executionContext.getOperationDefinition().getOperation();
        String operationName = executionContext.getOperationDefinition().getName() != null ? executionContext.getOperationDefinition().getName() : "<unnamed>";
        TracingBlockReference blockReference = this.tracingContext.createAndActivateBlockIfParentContextAvailable("GraphQL " + operation.name().toLowerCase() + " - " + operationName, new TracingContext.SpanAttribute[]{new TracingContext.SpanAttribute("operation", (Object)operation.name()), new TracingContext.SpanAttribute("operationName", (Object)operationName)});
        if (blockReference != null) {
            executionContext.getGraphQLContext().put((Object)GraphQLContextKey.OPERATION_TRACING_BLOCK, (Object)blockReference);
        }
        return executionContext;
    }
}

