/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql;

import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.GraphQL;
import io.evitadb.api.CatalogContract;
import io.evitadb.api.requestResponse.schema.CatalogSchemaContract;
import io.evitadb.core.CorruptedCatalog;
import io.evitadb.core.Evita;
import io.evitadb.exception.EvitaInternalError;
import io.evitadb.externalApi.graphql.api.catalog.CatalogGraphQLBuilder;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.CatalogDataApiGraphQLSchemaBuilder;
import io.evitadb.externalApi.graphql.api.catalog.schemaApi.CatalogSchemaApiGraphQLSchemaBuilder;
import io.evitadb.externalApi.graphql.api.system.SystemGraphQLBuilder;
import io.evitadb.externalApi.graphql.configuration.GraphQLConfig;
import io.evitadb.externalApi.graphql.exception.GraphQLInternalError;
import io.evitadb.externalApi.graphql.io.GraphQLExceptionHandler;
import io.evitadb.externalApi.graphql.io.GraphQLHandler;
import io.evitadb.externalApi.graphql.io.GraphQLSchemaHandler;
import io.evitadb.externalApi.http.CorsFilter;
import io.evitadb.externalApi.http.CorsPreflightHandler;
import io.evitadb.externalApi.http.PathNormalizingHandler;
import io.evitadb.externalApi.utils.UriPath;
import io.evitadb.utils.Assert;
import io.evitadb.utils.CollectionUtils;
import io.evitadb.utils.StringUtils;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.RoutingHandler;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.util.Methods;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLManager {
    private static final Logger log = LoggerFactory.getLogger(GraphQLManager.class);
    public static final String SYSTEM_API_PREFIX = "system";
    @Nonnull
    private final ObjectMapper objectMapper = new ObjectMapper();
    @Nonnull
    private final Evita evita;
    @Nonnull
    private final GraphQLConfig graphQLConfig;
    @Nonnull
    private final RoutingHandler graphQLRouter = Handlers.routing();
    @Nonnull
    private final Map<String, RegisteredCatalog> registeredCatalogs = CollectionUtils.createHashMap((int)20);

    public GraphQLManager(@Nonnull Evita evita, @Nonnull GraphQLConfig graphQLConfig) {
        this.evita = evita;
        this.graphQLConfig = graphQLConfig;
        long buildingStartTime = System.currentTimeMillis();
        this.registerSystemApi();
        this.evita.getCatalogs().forEach(catalog -> this.registerCatalog(catalog.getName()));
        log.info("Built GraphQL API in " + StringUtils.formatPreciseNano((long)(System.currentTimeMillis() - buildingStartTime)));
    }

    @Nonnull
    public HttpHandler getGraphQLRouter() {
        return new PathNormalizingHandler((HttpHandler)this.graphQLRouter);
    }

    public void registerCatalog(@Nonnull String catalogName) {
        CatalogContract catalog = this.evita.getCatalogInstanceOrThrowException(catalogName);
        if (catalog instanceof CorruptedCatalog) {
            log.warn("Catalog `" + catalogName + "` is corrupted. Skipping...");
            return;
        }
        Assert.isPremiseValid((!this.registeredCatalogs.containsKey(catalogName) ? 1 : 0) != 0, () -> new GraphQLInternalError("Catalog `" + catalogName + "` has been already registered."));
        try {
            UriPath catalogDataApiPath = this.buildCatalogDataApiPath((CatalogSchemaContract)catalog.getSchema());
            GraphQL catalogDataApiGraphQL = new CatalogGraphQLBuilder(this.evita, catalog, new CatalogDataApiGraphQLSchemaBuilder(this.graphQLConfig, this.evita, catalog).build()).build(this.graphQLConfig);
            RegisteredGraphQLApi registeredDataApiGraphQL = new RegisteredGraphQLApi(catalogDataApiPath, new AtomicReference<GraphQL>(catalogDataApiGraphQL));
            this.registerGraphQLEndpoint(registeredDataApiGraphQL);
            UriPath catalogSchemaApiPath = this.buildCatalogSchemaApiPath((CatalogSchemaContract)catalog.getSchema());
            GraphQL catalogSchemaApiGraphQL = new CatalogGraphQLBuilder(this.evita, catalog, new CatalogSchemaApiGraphQLSchemaBuilder(this.graphQLConfig, this.evita, catalog).build()).build(this.graphQLConfig);
            RegisteredGraphQLApi registeredSchemaApiGraphQL = new RegisteredGraphQLApi(catalogSchemaApiPath, new AtomicReference<GraphQL>(catalogSchemaApiGraphQL));
            this.registerGraphQLEndpoint(registeredSchemaApiGraphQL);
            RegisteredCatalog registeredCatalog = new RegisteredCatalog(registeredDataApiGraphQL, registeredSchemaApiGraphQL);
            this.registeredCatalogs.put(catalogName, registeredCatalog);
        }
        catch (EvitaInternalError ex) {
            log.error("Catalog `" + catalogName + "` is corrupted and will not accessible by GraphQL API.", (Throwable)ex);
        }
    }

    public void refreshCatalog(@Nonnull String catalogName) {
        RegisteredCatalog registeredCatalog = this.registeredCatalogs.get(catalogName);
        if (registeredCatalog == null) {
            log.info("Could not refresh existing catalog `{}`. Registering new one instead...", (Object)catalogName);
            this.registerCatalog(catalogName);
            return;
        }
        CatalogContract catalog = this.evita.getCatalogInstanceOrThrowException(catalogName);
        GraphQL newCatalogDataApiGraphQL = new CatalogGraphQLBuilder(this.evita, catalog, new CatalogDataApiGraphQLSchemaBuilder(this.graphQLConfig, this.evita, catalog).build()).build(this.graphQLConfig);
        registeredCatalog.dataApi().graphQLReference().set(newCatalogDataApiGraphQL);
        GraphQL newCatalogSchemaApiGraphQL = new CatalogGraphQLBuilder(this.evita, catalog, new CatalogSchemaApiGraphQLSchemaBuilder(this.graphQLConfig, this.evita, catalog).build()).build(this.graphQLConfig);
        registeredCatalog.schemaApi().graphQLReference().set(newCatalogSchemaApiGraphQL);
    }

    public void unregisterCatalog(@Nonnull String catalogName) {
        RegisteredCatalog registeredCatalog = this.registeredCatalogs.remove(catalogName);
        if (registeredCatalog != null) {
            this.graphQLRouter.remove(Methods.GET, registeredCatalog.dataApi().path().toString());
            this.graphQLRouter.remove(Methods.GET, registeredCatalog.schemaApi().path().toString());
            this.graphQLRouter.remove(Methods.POST, registeredCatalog.dataApi().path().toString());
            this.graphQLRouter.remove(Methods.POST, registeredCatalog.schemaApi().path().toString());
            this.graphQLRouter.remove(Methods.OPTIONS, registeredCatalog.dataApi().path().toString());
            this.graphQLRouter.remove(Methods.OPTIONS, registeredCatalog.schemaApi().path().toString());
        }
    }

    private void registerSystemApi() {
        this.registerGraphQLEndpoint(new RegisteredGraphQLApi(UriPath.of((String[])new String[]{"/", SYSTEM_API_PREFIX}), new AtomicReference<GraphQL>(new SystemGraphQLBuilder(this.evita).build(this.graphQLConfig))));
    }

    private void registerGraphQLEndpoint(@Nonnull RegisteredGraphQLApi registeredGraphQLApi) {
        this.graphQLRouter.add(Methods.POST, registeredGraphQLApi.path().toString(), (HttpHandler)new BlockingHandler((HttpHandler)new CorsFilter((HttpHandler)new GraphQLExceptionHandler(this.objectMapper, (HttpHandler)new GraphQLHandler(this.objectMapper, this.evita, registeredGraphQLApi.graphQLReference())), this.graphQLConfig.getAllowedOrigins())));
        this.graphQLRouter.add(Methods.GET, registeredGraphQLApi.path().toString(), (HttpHandler)new BlockingHandler((HttpHandler)new CorsFilter((HttpHandler)new GraphQLExceptionHandler(this.objectMapper, (HttpHandler)new GraphQLSchemaHandler(registeredGraphQLApi.graphQLReference())), this.graphQLConfig.getAllowedOrigins())));
        this.graphQLRouter.add(Methods.OPTIONS, registeredGraphQLApi.path().toString(), (HttpHandler)new BlockingHandler((HttpHandler)new CorsFilter((HttpHandler)new CorsPreflightHandler(this.graphQLConfig.getAllowedOrigins(), Set.of("GET", "POST"), Set.of("Content-Type", "Accept", "traceparent", "X-EvitaDB-ClientID")), this.graphQLConfig.getAllowedOrigins())));
    }

    @Nonnull
    private UriPath buildCatalogDataApiPath(@Nonnull CatalogSchemaContract catalogSchema) {
        return UriPath.of((String[])new String[]{catalogSchema.getName()});
    }

    @Nonnull
    private UriPath buildCatalogSchemaApiPath(@Nonnull CatalogSchemaContract catalogSchema) {
        return UriPath.of((UriPath)this.buildCatalogDataApiPath(catalogSchema), (String[])new String[]{"schema"});
    }

    private record RegisteredGraphQLApi(@Nonnull UriPath path, @Nonnull AtomicReference<GraphQL> graphQLReference) {
    }

    private record RegisteredCatalog(@Nonnull RegisteredGraphQLApi dataApi, @Nonnull RegisteredGraphQLApi schemaApi) {
    }
}

