/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.dataType.coercing;

import graphql.language.StringValue;
import graphql.schema.CoercingParseLiteralException;
import io.evitadb.dataType.DateTimeRange;
import io.evitadb.externalApi.graphql.api.dataType.coercing.RangeCoercing;
import io.evitadb.externalApi.graphql.exception.GraphQLInvalidArgumentException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DateTimeRangeCoercing
extends RangeCoercing<OffsetDateTime, DateTimeRange, String> {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME;

    @Override
    protected Class<DateTimeRange> getRangeClass() {
        return DateTimeRange.class;
    }

    @Override
    protected Class<String> getTupleComponentClass() {
        return String.class;
    }

    @Nonnull
    protected String[] createTuple(@Nullable String from, @Nullable String to) {
        return new String[]{from, to};
    }

    @Override
    @Nonnull
    protected DateTimeRange createRange(@Nullable OffsetDateTime from, @Nullable OffsetDateTime to) {
        if (from != null && to != null) {
            return DateTimeRange.between((OffsetDateTime)from, (OffsetDateTime)to);
        }
        if (from != null) {
            return DateTimeRange.since((OffsetDateTime)from);
        }
        if (to != null) {
            return DateTimeRange.until((OffsetDateTime)to);
        }
        throw new GraphQLInvalidArgumentException("Datetime range can never be created with both bounds null!");
    }

    @Override
    @Nonnull
    protected String extractRangeEndFromNode(@Nonnull Object node) {
        if (!(node instanceof StringValue)) {
            throw new CoercingParseLiteralException("Item of range input value is not a string.");
        }
        return ((StringValue)node).getValue();
    }

    @Override
    @Nullable
    protected String formatRangeEnd(@Nullable OffsetDateTime end) {
        return Optional.ofNullable(end).map(e -> e.truncatedTo(ChronoUnit.MILLIS).format(FORMATTER)).orElse(null);
    }

    @Override
    @Nullable
    protected OffsetDateTime parseRangeEnd(@Nullable String end) {
        return Optional.ofNullable(end).map(e -> OffsetDateTime.parse(e, FORMATTER)).orElse(null);
    }
}

