/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.resolver.dataFetcher;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.evitadb.api.trace.TracingContext;
import io.evitadb.api.trace.TracingContextReference;
import io.evitadb.externalApi.graphql.exception.GraphQLInternalError;
import io.evitadb.thread.ShortRunningSupplier;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadDataFetcher
implements DataFetcher<Object> {
    private static final Logger log = LoggerFactory.getLogger(ReadDataFetcher.class);
    @Nonnull
    private final DataFetcher<?> delegate;
    @Nonnull
    private final TracingContext tracingContext;
    @Nullable
    private final Executor executor;

    public Object get(DataFetchingEnvironment environment) throws Exception {
        if (this.executor == null) {
            log.debug("No executor for processing data fetcher `" + this.getClass().getName() + "`, processing synchronously.");
            return this.delegate.get(environment);
        }
        TracingContextReference parentContextReference = this.tracingContext.getCurrentContext();
        return CompletableFuture.supplyAsync(new ShortRunningSupplier(() -> this.tracingContext.executeWithinBlockWithParentContext(parentContextReference, "GraphQL fetch", () -> {
            try {
                return this.delegate.get(environment);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    RuntimeException re = (RuntimeException)e;
                    throw re;
                }
                throw new GraphQLInternalError("Unexpected exception occurred during data fetching.", e);
            }
        })), this.executor);
    }

    public ReadDataFetcher(@Nonnull DataFetcher<?> delegate, @Nonnull TracingContext tracingContext, @Nullable Executor executor) {
        if (delegate == null) {
            throw new NullPointerException("delegate is marked non-null but is null");
        }
        if (tracingContext == null) {
            throw new NullPointerException("tracingContext is marked non-null but is null");
        }
        this.delegate = delegate;
        this.tracingContext = tracingContext;
        this.executor = executor;
    }
}

