/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.schemaApi.resolver.dataFetcher;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import io.evitadb.externalApi.graphql.api.dataType.DataTypesConverter;
import io.evitadb.externalApi.graphql.exception.GraphQLQueryResolvingInternalError;
import javax.annotation.Nonnull;

public abstract class SchemaTypeDataFetcher
implements DataFetcher<String> {
    @Nonnull
    public String get(@Nonnull DataFetchingEnvironment environment) throws Exception {
        Class<?> javaType = this.getJavaType(environment);
        Object graphQLType = DataTypesConverter.getGraphQLScalarType(javaType);
        return this.resolveGraphQLTypeName((GraphQLType)graphQLType);
    }

    @Nonnull
    private String resolveGraphQLTypeName(@Nonnull GraphQLType graphQLType) {
        if (graphQLType instanceof GraphQLList) {
            GraphQLList graphQLList = (GraphQLList)graphQLType;
            String wrappedTypeName = this.resolveGraphQLTypeName(graphQLList.getWrappedType());
            return "[" + wrappedTypeName + "]";
        }
        if (graphQLType instanceof GraphQLNonNull) {
            GraphQLNonNull graphQLNonNull = (GraphQLNonNull)graphQLType;
            String wrappedTypeName = this.resolveGraphQLTypeName(graphQLNonNull.getWrappedType());
            return wrappedTypeName + "!";
        }
        if (graphQLType instanceof GraphQLScalarType) {
            GraphQLScalarType graphQLScalarType = (GraphQLScalarType)graphQLType;
            return graphQLScalarType.getName();
        }
        throw new GraphQLQueryResolvingInternalError("Unsupported GraphQL type `" + graphQLType.getClass().getName() + "`.");
    }

    @Nonnull
    protected abstract Class<?> getJavaType(@Nonnull DataFetchingEnvironment var1);
}

